/*
 * Decompiled with CFR 0.152.
 */
package kieker.tcp;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kieker.tcp.SocketListener;

public final class TestExperiment0 {
    private static final int PORT1 = 10133;
    private static final int PORT2 = 10134;
    static final AtomicInteger counter = new AtomicInteger(0);
    static final AtomicLong totalBytes = new AtomicLong(0L);

    private TestExperiment0() {
    }

    public static void main(String[] args) throws InterruptedException {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        executorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                int bytes = counter.getAndSet(0);
                totalBytes.addAndGet(bytes);
                if (bytes > 0x100000) {
                    System.out.println("MB/s: " + bytes / 0x100000);
                } else if (bytes > 1024) {
                    System.out.println("KB/s: " + bytes / 1024);
                } else {
                    System.out.println(" B/s: " + bytes);
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        Thread thread1 = new Thread(new SocketListener(10133));
        Thread thread2 = new Thread(new SocketListener(10134));
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        executorService.shutdown();
        System.out.println("Total bytes read: " + totalBytes.get());
    }
}

