/*
 * Decompiled with CFR 0.152.
 */
package kieker.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kieker.tcp.TestExperiment0;

class SocketListener
implements Runnable {
    private static final int MESSAGE_BUFFER_SIZE = 65535;
    private final int port;

    public SocketListener(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port));
            System.out.println("Connected: " + this.port);
            SocketChannel socketChannel = serversocket.accept();
            ByteBuffer buffer = ByteBuffer.allocateDirect(65535);
            while (socketChannel.read(buffer) != -1) {
                buffer.flip();
                TestExperiment0.counter.addAndGet(buffer.remaining());
                buffer.clear();
            }
            socketChannel.close();
        }
        catch (IOException ex) {
            System.err.println("Error while reading: " + ex);
        }
        finally {
            if (null != serversocket) {
                try {
                    serversocket.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to close TCP connection!" + e);
                }
            }
        }
    }
}

