/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.IOException;
import org.apache.jmeter.protocol.http.util.accesslog.TCLogParser;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestCloneable;
import org.apache.jmeter.testelement.TestElement;

public class SharedTCLogParser
extends TCLogParser
implements TestCloneable {
    public SharedTCLogParser() {
    }

    public SharedTCLogParser(String source) {
        super(source);
    }

    public Object clone() {
        SharedTCLogParser parser = new SharedTCLogParser();
        parser.FILENAME = this.FILENAME;
        parser.FILTER = this.FILTER;
        return parser;
    }

    public int parse(TestElement el, int parseCount) {
        FileServer fileServer = FileServer.getFileServer();
        fileServer.reserveFile(this.FILENAME);
        try {
            return this.parse(fileServer, el, parseCount);
        }
        catch (Exception exception) {
            log.error("Problem creating samples", (Throwable)exception);
            return -1;
        }
    }

    protected int parse(FileServer breader, TestElement el, int parseCount) {
        int actualCount = 0;
        String line = null;
        try {
            line = breader.readLine(this.FILENAME);
            while (line != null) {
                if (line.length() > 0) {
                    actualCount += this.parseLine(line, el);
                }
                if (parseCount != -1 && actualCount >= parseCount) break;
                line = breader.readLine(this.FILENAME);
            }
            if (line == null) {
                breader.closeFile(this.FILENAME);
            }
        }
        catch (IOException ioe) {
            log.error("Error reading log file", (Throwable)ioe);
        }
        return actualCount;
    }

    public void close() {
        try {
            FileServer.getFileServer().closeFile(this.FILENAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

