/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.net.URL;
import java.util.Locale;
import org.apache.jmeter.samplers.SampleResult;

public class HTTPSampleResult
extends SampleResult {
    private static final long serialVersionUID = 240L;
    private String cookies = "";
    private String method;
    private String redirectLocation;
    private String queryString = "";
    private static final String HTTP_NO_CONTENT_CODE = Integer.toString(204);
    private static final String HTTP_NO_CONTENT_MSG = "No Content";

    public HTTPSampleResult() {
    }

    public HTTPSampleResult(long elapsed) {
        super(elapsed, true);
    }

    public HTTPSampleResult(HTTPSampleResult res) {
        super((SampleResult)res);
        this.method = res.method;
        this.cookies = res.cookies;
        this.queryString = res.queryString;
        this.redirectLocation = res.redirectLocation;
    }

    public void setHTTPMethod(String method) {
        this.method = method;
    }

    public String getHTTPMethod() {
        return this.method;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public boolean isRedirect() {
        String[] REDIRECT_CODES = new String[]{"301", "302", "303"};
        String code = this.getResponseCode();
        for (int i = 0; i < REDIRECT_CODES.length; ++i) {
            if (!REDIRECT_CODES[i].equals(code)) continue;
            return true;
        }
        return false;
    }

    public String getSamplerData() {
        String sampData;
        StringBuilder sb = new StringBuilder();
        sb.append(this.method);
        URL u = super.getURL();
        if (u != null) {
            sb.append(' ');
            sb.append(u.toString());
            sb.append("\n");
            if ("POST".equals(this.method) || "PUT".equals(this.method) || "PATCH".equals(this.method)) {
                sb.append("\n" + this.method + " data:\n");
                sb.append(this.queryString);
                sb.append("\n");
            }
            if (this.cookies.length() > 0) {
                sb.append("\nCookie Data:\n");
                sb.append(this.cookies);
            } else {
                sb.append("\n[no cookies]");
            }
            sb.append("\n");
        }
        if ((sampData = super.getSamplerData()) != null) {
            sb.append(sampData);
        }
        return sb.toString();
    }

    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(String string) {
        this.cookies = string == null ? "" : string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string == null ? "" : string;
    }

    public String getDataEncodingWithDefault() {
        if (this.getDataEncodingNoDefault() == null && this.getContentType().startsWith("text/html")) {
            int tagend;
            byte[] bytes = this.getResponseData();
            String prefix = new String(bytes, 0, Math.min(bytes.length, 2000)).toLowerCase(Locale.ENGLISH);
            String METATAG = "<meta http-equiv=\"content-type\" content=\"";
            int tagstart = prefix.indexOf("<meta http-equiv=\"content-type\" content=\"");
            if (tagstart != -1 && (tagend = prefix.indexOf(34, tagstart += "<meta http-equiv=\"content-type\" content=\"".length())) != -1) {
                String ct = new String(bytes, tagstart, tagend - tagstart);
                this.setEncodingAndType(ct);
            }
        }
        return super.getDataEncodingWithDefault("ISO-8859-1");
    }

    public void setResponseNoContent() {
        this.setResponseCode(HTTP_NO_CONTENT_CODE);
        this.setResponseMessage(HTTP_NO_CONTENT_MSG);
    }
}

