/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.protocol.http.proxy.DefaultSamplerCreator;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.SamplerCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplerCreatorFactory {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final SamplerCreator DEFAULT_SAMPLER_CREATOR = new DefaultSamplerCreator();
    private Map<String, SamplerCreator> samplerCreatorMap = new HashMap<String, SamplerCreator>();

    public SamplerCreatorFactory() {
        this.init();
    }

    private void init() {
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{SamplerCreator.class});
            for (String strClassName : listClasses) {
                try {
                    String[] contentTypes;
                    Class<?> commandClass;
                    if (log.isDebugEnabled()) {
                        log.debug("Loading class: " + strClassName);
                    }
                    if (Modifier.isAbstract((commandClass = Class.forName(strClassName)).getModifiers())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Instantiating: " + commandClass.getName());
                    }
                    SamplerCreator creator = (SamplerCreator)commandClass.newInstance();
                    for (String contentType : contentTypes = creator.getManagedContentTypes()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Registering samplerCreator " + commandClass.getName() + " for content type:" + contentType);
                        }
                        this.samplerCreatorMap.put(contentType, creator);
                    }
                }
                catch (Exception e) {
                    log.error("Exception registering " + SamplerCreator.class.getName() + " with implementation:" + strClassName, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception finding implementations of " + SamplerCreator.class, (Throwable)e);
        }
    }

    public SamplerCreator getSamplerCreator(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) {
        SamplerCreator creator = this.samplerCreatorMap.get(request.getContentType());
        if (creator == null) {
            return DEFAULT_SAMPLER_CREATOR;
        }
        return creator;
    }
}

