/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.gui.HTTPFileArgsPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class MultipartUrlConfigGui
extends UrlConfigGui {
    private static final long serialVersionUID = 240L;
    private HTTPFileArgsPanel filesPanel;

    public MultipartUrlConfigGui() {
        this.init();
    }

    public MultipartUrlConfigGui(boolean showSamplerFields) {
        super(showSamplerFields);
        this.init();
    }

    public MultipartUrlConfigGui(boolean showSamplerFields, boolean showImplementation) {
        super(showSamplerFields, showImplementation, true);
        this.init();
    }

    public void modifyTestElement(TestElement sampler) {
        super.modifyTestElement(sampler);
        this.filesPanel.modifyTestElement(sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.filesPanel.configure(el);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        northPanel.add(this.getProtocolAndMethodPanel());
        northPanel.add(this.getPathPanel());
        webRequestPanel.add((Component)northPanel, "North");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        webRequestPanel.add((Component)this.getHTTPFileArgsPanel(), "South");
        this.add((Component)this.getWebServerTimeoutPanel(), "North");
        this.add((Component)webRequestPanel, "Center");
        this.add((Component)this.getProxyServerPanel(), "South");
    }

    private JPanel getHTTPFileArgsPanel() {
        this.filesPanel = new HTTPFileArgsPanel(JMeterUtils.getResString((String)"send_file"));
        return this.filesPanel;
    }

    public void clear() {
        super.clear();
        this.filesPanel.clear();
    }
}

