/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScopedLogHandlersManager {
    private static final String PACKAGE_NAME = "net.sourceforge.pmd";
    private Logger logger;
    private Level oldLogLevel;
    private Handler[] oldHandlers;
    private Handler[] newHandlers;

    public ScopedLogHandlersManager(Level level, Handler ... handlers) {
        this.newHandlers = handlers;
        this.logger = Logger.getLogger(PACKAGE_NAME);
        this.oldHandlers = this.logger.getHandlers();
        this.oldLogLevel = this.logger.getLevel();
        this.logger.setLevel(level);
        for (Handler handler : this.oldHandlers) {
            this.logger.removeHandler(handler);
        }
        for (Handler handler : this.newHandlers) {
            this.logger.addHandler(handler);
        }
    }

    public void close() {
        for (Handler handler : this.newHandlers) {
            this.logger.removeHandler(handler);
        }
        for (Handler handler : this.oldHandlers) {
            this.logger.addHandler(handler);
        }
        this.logger.setLevel(this.oldLogLevel);
    }
}

