/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sourceforge.pmd.util.log.PmdLogFormatter;
import org.apache.tools.ant.Task;

public class AntLogHandler
extends Handler {
    private Task antTask;
    private static final Formatter FORMATTER = new PmdLogFormatter();

    public AntLogHandler(Task antTask) {
        this.antTask = antTask;
    }

    public void publish(LogRecord logRecord) {
        int antLevel;
        Level level = logRecord.getLevel();
        if (level == Level.FINEST) {
            antLevel = 4;
        } else if (level == Level.FINE || level == Level.FINER || level == Level.CONFIG) {
            antLevel = 3;
        } else if (level == Level.INFO) {
            antLevel = 2;
        } else if (level == Level.WARNING) {
            antLevel = 1;
        } else if (level == Level.SEVERE) {
            antLevel = 0;
        } else {
            throw new IllegalStateException("Unknown logging level");
        }
        this.antTask.log(FORMATTER.format(logRecord), antLevel);
        if (logRecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            logRecord.getThrown().printStackTrace(printWriter);
            this.antTask.log(stringWriter.toString(), antLevel);
        }
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }
}

