/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.processor.PmdRunnable;

public class PmdThreadFactory
implements ThreadFactory {
    private final RuleSetFactory ruleSetFactory;
    private final RuleContext ctx;
    private final AtomicInteger counter = new AtomicInteger();
    public List<Runnable> threadList = Collections.synchronizedList(new LinkedList());

    public PmdThreadFactory(RuleSetFactory ruleSetFactory, RuleContext ctx) {
        this.ruleSetFactory = ruleSetFactory;
        this.ctx = ctx;
    }

    public Thread newThread(Runnable r) {
        Thread t = PmdRunnable.createThread(this.counter.incrementAndGet(), r, this.ruleSetFactory, this.ctx);
        this.threadList.add(t);
        return t;
    }
}

