/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractMultiNumericProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleMultiProperty
extends AbstractMultiNumericProperty<Double[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<DoubleMultiProperty>(Double[].class, numberFieldTypesByKey){

        public DoubleMultiProperty createWith(Map<String, String> valuesById) {
            String[] minMax = 1.minMaxFrom(valuesById);
            Double[] defaultValues = 1.doublesIn(this.defaultValueIn(valuesById));
            return new DoubleMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), Double.parseDouble(minMax[0]), Double.parseDouble(minMax[1]), defaultValues, 0.0f);
        }
    };

    public DoubleMultiProperty(String theName, String theDescription, Double min, Double max, Double[] defaultValues, float theUIOrder) {
        super(theName, theDescription, min, max, defaultValues, theUIOrder);
    }

    @Override
    public Class<Double[]> type() {
        return Double[].class;
    }

    @Override
    protected Object createFrom(String value) {
        return Double.valueOf(value);
    }

    @Override
    protected Object[] arrayFor(int size) {
        return new Double[size];
    }
}

