/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.Scope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableUsageFinderFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassScope
extends AbstractScope {
    protected Map<ClassNameDeclaration, List<NameOccurrence>> classNames = new HashMap<ClassNameDeclaration, List<NameOccurrence>>();
    protected Map<MethodNameDeclaration, List<NameOccurrence>> methodNames = new HashMap<MethodNameDeclaration, List<NameOccurrence>>();
    protected Map<VariableNameDeclaration, List<NameOccurrence>> variableNames = new HashMap<VariableNameDeclaration, List<NameOccurrence>>();
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    @Override
    public void addDeclaration(VariableNameDeclaration variableDecl) {
        if (this.variableNames.containsKey(variableDecl)) {
            throw new RuntimeException(variableDecl + " is already in the symbol table");
        }
        this.variableNames.put(variableDecl, new ArrayList());
    }

    @Override
    public NameDeclaration addVariableNameOccurrence(NameOccurrence occurrence) {
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && occurrence.isMethodOrConstructorInvocation()) {
            List<NameOccurrence> nameOccurrences = this.methodNames.get(decl);
            if (nameOccurrences != null) {
                nameOccurrences.add(occurrence);
                JavaNode n = occurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !occurrence.isThisOrSuper()) {
            List<NameOccurrence> nameOccurrences = this.variableNames.get(decl);
            if (nameOccurrences == null) {
                for (ClassNameDeclaration innerClass : this.classNames.keySet()) {
                    Scope innerClassScope = innerClass.getScope();
                    if (!innerClassScope.contains(occurrence)) continue;
                    innerClassScope.addVariableNameOccurrence(occurrence);
                }
            } else {
                nameOccurrences.add(occurrence);
                JavaNode n = occurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        }
        return decl;
    }

    @Override
    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        VariableUsageFinderFunction f = new VariableUsageFinderFunction(this.variableNames);
        Applier.apply(f, this.variableNames.keySet().iterator());
        return f.getUsed();
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.methodNames;
    }

    @Override
    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.classNames;
    }

    @Override
    public ClassScope getEnclosingClassScope() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void addDeclaration(MethodNameDeclaration decl) {
        this.methodNames.put(decl, new ArrayList());
    }

    @Override
    public void addDeclaration(ClassNameDeclaration decl) {
        this.classNames.put(decl, new ArrayList());
    }

    @Override
    protected NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (this.variableNames.isEmpty() && this.methodNames.isEmpty()) {
                return null;
            }
            if (!this.variableNames.isEmpty()) {
                return this.variableNames.keySet().iterator().next();
            }
            return this.methodNames.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : this.methodNames.keySet()) {
                int args;
                if (!mnd.getImage().equals(occurrence.getImage()) || (args = occurrence.getArgumentCount()) != mnd.getParameterCount() && (!mnd.isVarargs() || args < mnd.getParameterCount() - 1)) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, this.variableNames.keySet().iterator());
        NameDeclaration result = finder.getDecl();
        if (result == null && !this.classNames.isEmpty()) {
            for (ClassNameDeclaration innerClass : this.classNames.keySet()) {
                Applier.apply(finder, innerClass.getScope().getVariableDeclarations().keySet().iterator());
                result = finder.getDecl();
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder res = new StringBuilder("ClassScope (").append(this.className).append("): ");
        if (!this.classNames.isEmpty()) {
            res.append("Inner Classes ").append(this.glomNames(this.classNames.keySet())).append("; ");
        }
        if (!this.methodNames.isEmpty()) {
            for (MethodNameDeclaration mnd : this.methodNames.keySet()) {
                res.append(mnd.toString());
                int usages = this.methodNames.get(mnd).size();
                res.append("(begins at line ").append(mnd.getNode().getBeginLine()).append(", ").append(usages).append(" usages)");
                res.append(", ");
            }
        }
        if (!this.variableNames.isEmpty()) {
            res.append("Variables ").append(this.glomNames(this.variableNames.keySet()));
        }
        return res.toString();
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

