/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.junit;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNormalAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;

public class JUnitTestsShouldIncludeAssertRule
extends AbstractJUnitRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration method, Object data) {
        if (this.isJUnitMethod(method, data) && !this.containsAssert(method.getBlock(), false) && !this.containsExpect(method.jjtGetParent())) {
            this.addViolation(data, method);
        }
        return data;
    }

    private boolean containsAssert(Node n, boolean assertFound) {
        if (!assertFound) {
            if (n instanceof ASTStatementExpression && this.isAssertOrFailStatement((ASTStatementExpression)n)) {
                return true;
            }
            if (!assertFound) {
                for (int i = 0; i < n.jjtGetNumChildren() && !assertFound; ++i) {
                    Node c = n.jjtGetChild(i);
                    if (!this.containsAssert(c, assertFound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsExpect(Node methodParent) {
        List<ASTNormalAnnotation> annotations = methodParent.findDescendantsOfType(ASTNormalAnnotation.class);
        for (ASTNormalAnnotation annotation : annotations) {
            ASTName name = annotation.getFirstChildOfType(ASTName.class);
            if (name == null || !"Test".equals(name.getImage()) && (name.getType() == null || !name.getType().equals(JUNIT4_CLASS))) continue;
            List<ASTMemberValuePair> memberValues = annotation.findDescendantsOfType(ASTMemberValuePair.class);
            for (ASTMemberValuePair pair : memberValues) {
                if (!"expected".equals(pair.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAssertOrFailStatement(ASTStatementExpression expression) {
        String img;
        ASTPrimaryPrefix pp;
        ASTPrimaryExpression pe;
        return expression != null && expression.jjtGetNumChildren() > 0 && expression.jjtGetChild(0) instanceof ASTPrimaryExpression && (pe = (ASTPrimaryExpression)expression.jjtGetChild(0)).jjtGetNumChildren() > 0 && pe.jjtGetChild(0) instanceof ASTPrimaryPrefix && (pp = (ASTPrimaryPrefix)pe.jjtGetChild(0)).jjtGetNumChildren() > 0 && pp.jjtGetChild(0) instanceof ASTName && (img = ((ASTName)pp.jjtGetChild(0)).getImage()) != null && (img.startsWith("assert") || img.startsWith("fail") || img.startsWith("Assert.assert") || img.startsWith("Assert.fail"));
    }
}

