/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.comments;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.comments.AbstractCommentRule;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentSizeRule
extends AbstractCommentRule {
    public static final IntegerProperty MAX_LINES = new IntegerProperty("maxLines", "Maximum lines", 2, 200, 6, 2.0f);
    public static final IntegerProperty MAX_LINE_LENGTH = new IntegerProperty("maxLineLength", "Maximum line length", 1, 200, 80, 2.0f);
    private static final String CR = "\n";

    public CommentSizeRule() {
        this.definePropertyDescriptor(MAX_LINES);
        this.definePropertyDescriptor(MAX_LINE_LENGTH);
    }

    private static boolean hasRealText(String line) {
        if (StringUtil.isEmpty(line)) {
            return false;
        }
        return !StringUtil.isAnyOf(line.trim(), "//", "/*", "/**", "*", "*/");
    }

    private boolean hasTooManyLines(Comment comment) {
        int end;
        int start;
        String[] lines = comment.getImage().split(CR);
        for (start = 0; start < lines.length && !CommentSizeRule.hasRealText(lines[start]); ++start) {
        }
        for (end = lines.length - 1; end > 0 && !CommentSizeRule.hasRealText(lines[end]); --end) {
        }
        int lineCount = end - start + 1;
        return lineCount > this.getProperty(MAX_LINES);
    }

    private String withoutCommentMarkup(String text) {
        return StringUtil.withoutPrefixes(text.trim(), "//", "*", "/**");
    }

    private List<Integer> overLengthLineIndicesIn(Comment comment) {
        int maxLength = this.getProperty(MAX_LINE_LENGTH);
        ArrayList<Integer> indicies = new ArrayList<Integer>();
        String[] lines = comment.getImage().split(CR);
        int offset = comment.getBeginLine();
        for (int i = 0; i < lines.length; ++i) {
            String cleaned = this.withoutCommentMarkup(lines[i]);
            if (cleaned.length() <= maxLength) continue;
            indicies.add(i + offset);
        }
        return indicies;
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        for (Comment comment : cUnit.getComments()) {
            List<Integer> lineNumbers;
            if (this.hasTooManyLines(comment)) {
                this.addViolationWithMessage(data, cUnit, this.getMessage() + ": Too many lines", comment.getBeginLine(), comment.getEndLine());
            }
            if ((lineNumbers = this.overLengthLineIndicesIn(comment)).isEmpty()) continue;
            for (Integer lineNum : lineNumbers) {
                this.addViolationWithMessage(data, cUnit, this.getMessage() + ": Line too long", lineNum, lineNum);
            }
        }
        return super.visit(cUnit, data);
    }
}

