/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.comments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.comments.AbstractCommentRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentContentRule
extends AbstractCommentRule {
    private boolean caseSensitive;
    private boolean wordsAreRegex;
    private String[] originalBadWords;
    private String[] currentBadWords;
    private static final String[] badWords = new String[]{"idiot", "jerk"};
    public static final BooleanProperty WORDS_ARE_REGEX_DESCRIPTOR = new BooleanProperty("wordsAreRegex", "Use regular expressions", false, 1.0f);
    public static final BooleanProperty CASE_SENSITIVE_DESCRIPTOR = new BooleanProperty("caseSensitive", "Case sensitive", false, 2.0f);
    public static final StringMultiProperty DISSALLOWED_TERMS_DESCRIPTOR = new StringMultiProperty("disallowedTerms", "Illegal terms or phrases", badWords, 3.0f, '|');
    private static final Set<PropertyDescriptor<?>> NonRegexProperties = new HashSet(1);

    public CommentContentRule() {
        this.definePropertyDescriptor(WORDS_ARE_REGEX_DESCRIPTOR);
        this.definePropertyDescriptor(CASE_SENSITIVE_DESCRIPTOR);
        this.definePropertyDescriptor(DISSALLOWED_TERMS_DESCRIPTOR);
    }

    @Override
    public void start(RuleContext ctx) {
        this.wordsAreRegex = this.getProperty(WORDS_ARE_REGEX_DESCRIPTOR);
        this.originalBadWords = this.getProperty(DISSALLOWED_TERMS_DESCRIPTOR);
        this.caseSensitive = this.getProperty(CASE_SENSITIVE_DESCRIPTOR);
        if (this.caseSensitive) {
            this.currentBadWords = this.originalBadWords;
        } else {
            this.currentBadWords = new String[this.originalBadWords.length];
            for (int i = 0; i < this.currentBadWords.length; ++i) {
                this.currentBadWords[i] = this.originalBadWords[i].toUpperCase();
            }
        }
    }

    @Override
    public Set<PropertyDescriptor<?>> ignoredProperties() {
        return this.getProperty(WORDS_ARE_REGEX_DESCRIPTOR) != false ? NonRegexProperties : Collections.EMPTY_SET;
    }

    @Override
    public void end(RuleContext ctx) {
    }

    private List<String> illegalTermsIn(Comment comment) {
        if (this.currentBadWords.length == 0) {
            return Collections.emptyList();
        }
        String commentText = this.filteredCommentIn(comment);
        if (StringUtil.isEmpty(commentText)) {
            return Collections.emptyList();
        }
        if (!this.caseSensitive) {
            commentText = commentText.toUpperCase();
        }
        ArrayList<String> foundWords = new ArrayList<String>();
        for (int i = 0; i < this.currentBadWords.length; ++i) {
            if (commentText.indexOf(this.currentBadWords[i]) < 0) continue;
            foundWords.add(this.originalBadWords[i]);
        }
        return foundWords;
    }

    private String errorMsgFor(List<String> badWords) {
        StringBuilder msg = new StringBuilder(this.getMessage()).append(": ");
        if (badWords.size() == 1) {
            msg.append("Invalid term: '").append(badWords.get(0)).append('\'');
        } else {
            msg.append("Invalid terms: '");
            msg.append(badWords.get(0));
            for (int i = 1; i < badWords.size(); ++i) {
                msg.append("', '").append(badWords.get(i));
            }
            msg.append('\'');
        }
        return msg.toString();
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        if (this.currentBadWords == null) {
            this.start(null);
        }
        for (Comment comment : cUnit.getComments()) {
            List<String> badWords = this.illegalTermsIn(comment);
            if (badWords.isEmpty()) continue;
            this.addViolationWithMessage(data, cUnit, this.errorMsgFor(badWords), comment.getBeginLine(), comment.getEndLine());
        }
        return super.visit(cUnit, data);
    }

    public boolean hasDissallowedTerms() {
        Object[] terms = this.getProperty(DISSALLOWED_TERMS_DESCRIPTOR);
        return CollectionUtil.isNotEmpty(terms);
    }

    @Override
    public String dysfunctionReason() {
        return this.hasDissallowedTerms() ? null : "No disallowed terms specified";
    }

    static {
        NonRegexProperties.add(CASE_SENSITIVE_DESCRIPTOR);
    }
}

