/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessTypeNode;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTFieldDeclaration
extends AbstractJavaAccessTypeNode
implements Dimensionable {
    public ASTFieldDeclaration(int id) {
        super(id);
    }

    public ASTFieldDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isSyntacticallyPublic() {
        return super.isPublic();
    }

    public boolean isPublic() {
        if (this.isInterfaceMember()) {
            return true;
        }
        return super.isPublic();
    }

    public boolean isSyntacticallyStatic() {
        return super.isStatic();
    }

    public boolean isStatic() {
        if (this.isInterfaceMember()) {
            return true;
        }
        return super.isStatic();
    }

    public boolean isSyntacticallyFinal() {
        return super.isFinal();
    }

    public boolean isFinal() {
        if (this.isInterfaceMember()) {
            return true;
        }
        return super.isFinal();
    }

    public boolean isPrivate() {
        if (this.isInterfaceMember()) {
            return false;
        }
        return super.isPrivate();
    }

    public boolean isPackagePrivate() {
        if (this.isInterfaceMember()) {
            return false;
        }
        return super.isPackagePrivate();
    }

    public boolean isProtected() {
        if (this.isInterfaceMember()) {
            return false;
        }
        return super.isProtected();
    }

    public boolean isInterfaceMember() {
        if (this.jjtGetParent().jjtGetParent() instanceof ASTEnumBody) {
            return false;
        }
        ASTClassOrInterfaceDeclaration n = this.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        return n != null && n.isInterface();
    }

    public boolean isArray() {
        return this.checkType() + this.checkDecl() > 0;
    }

    public int getArrayDepth() {
        if (!this.isArray()) {
            return 0;
        }
        return this.checkType() + this.checkDecl();
    }

    private int checkType() {
        if (this.jjtGetNumChildren() == 0 || !(this.jjtGetChild(0) instanceof ASTType)) {
            return 0;
        }
        return ((ASTType)this.jjtGetChild(0)).getArrayDepth();
    }

    private int checkDecl() {
        if (this.jjtGetNumChildren() < 2 || !(this.jjtGetChild(1) instanceof ASTVariableDeclarator)) {
            return 0;
        }
        return ((ASTVariableDeclaratorId)this.jjtGetChild(1).jjtGetChild(0)).getArrayDepth();
    }

    public String getVariableName() {
        ASTVariableDeclaratorId decl = this.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        if (decl != null) {
            return decl.getImage();
        }
        return null;
    }
}

