/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.GridBagHelper;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUI
implements CPDListener {
    private static final Object[][] RENDERER_SETS = new Object[][]{{"Text", new Renderer(){

        @Override
        public String render(Iterator<Match> items) {
            return new SimpleRenderer().render(items);
        }
    }}, {"XML", new Renderer(){

        @Override
        public String render(Iterator<Match> items) {
            return new XMLRenderer().render(items);
        }
    }}, {"CSV (comma)", new Renderer(){

        @Override
        public String render(Iterator<Match> items) {
            return new CSVRenderer(',').render(items);
        }
    }}, {"CSV (tab)", new Renderer(){

        @Override
        public String render(Iterator<Match> items) {
            return new CSVRenderer('\t').render(items);
        }
    }}};
    private static final Object[][] LANGUAGE_SETS = new Object[][]{{"Java", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("java");
        }

        public boolean canIgnoreIdentifiers() {
            return true;
        }

        public boolean canIgnoreLiterals() {
            return true;
        }

        public boolean canIgnoreAnnotations() {
            return true;
        }

        public String[] extensions() {
            return new String[]{".java", ".class"};
        }
    }}, {"JSP", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("jsp");
        }

        public String[] extensions() {
            return new String[]{".jsp"};
        }
    }}, {"C++", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("cpp");
        }

        public String[] extensions() {
            return new String[]{".cpp", ".c"};
        }
    }}, {"Ruby", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("ruby");
        }

        public String[] extensions() {
            return new String[]{".rb"};
        }
    }}, {"Fortran", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("fortran");
        }

        public String[] extensions() {
            return new String[]{".for", ".f", ".f66", ".f77", ".f90"};
        }
    }}, {"PHP", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("php");
        }

        public String[] extensions() {
            return new String[]{".php"};
        }
    }}, {"C#", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("cs");
        }

        public String[] extensions() {
            return new String[]{".cs"};
        }
    }}, {"Ecmascript", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("js");
        }

        public String[] extensions() {
            return new String[]{".js"};
        }
    }}, {"by extension...", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("by_extension", p);
        }

        public String[] extensions() {
            return new String[]{""};
        }
    }}};
    private static final int DEFAULT_CPD_MINIMUM_LENGTH = 75;
    private static final Map<String, LanguageConfig> LANGUAGE_CONFIGS_BY_LABEL = new HashMap<String, LanguageConfig>(LANGUAGE_SETS.length);
    private static final KeyStroke COPY_KEY_STROKE = KeyStroke.getKeyStroke(67, 2, false);
    private static final KeyStroke DELETE_KEY_STROKE = KeyStroke.getKeyStroke(127, 0);
    private final ColumnSpec[] matchColumns = new ColumnSpec[]{new ColumnSpec("Source", 2, -1, Match.LABEL_COMPARATOR), new ColumnSpec("Matches", 4, 60, Match.MATCHES_COMPARATOR), new ColumnSpec("Lines", 4, 45, Match.LINES_COMPARATOR)};
    private JTextField rootDirectoryField = new JTextField(System.getProperty("user.home"));
    private JTextField minimumLengthField = new JTextField(Integer.toString(75));
    private JTextField encodingField = new JTextField(System.getProperty("file.encoding"));
    private JTextField timeField = new JTextField(6);
    private JLabel phaseLabel = new JLabel();
    private JProgressBar tokenizingFilesBar = new JProgressBar();
    private JTextArea resultsTextArea = new JTextArea();
    private JCheckBox recurseCheckbox = new JCheckBox("", true);
    private JCheckBox ignoreIdentifiersCheckbox = new JCheckBox("", false);
    private JCheckBox ignoreLiteralsCheckbox = new JCheckBox("", false);
    private JCheckBox ignoreAnnotationsCheckbox = new JCheckBox("", false);
    private JComboBox languageBox = new JComboBox();
    private JTextField extensionField = new JTextField();
    private JLabel extensionLabel = new JLabel("Extension:", 4);
    private JTable resultsTable = new JTable();
    private JButton goButton;
    private JButton cancelButton;
    private JPanel progressPanel;
    private JFrame frame;
    private boolean trimLeadingWhitespace;
    private List<Match> matches = new ArrayList<Match>();

    private static LanguageConfig languageConfigFor(String label) {
        return LANGUAGE_CONFIGS_BY_LABEL.get(label);
    }

    private void addSaveOptionsTo(JMenu menu) {
        for (int i = 0; i < RENDERER_SETS.length; ++i) {
            JMenuItem saveItem = new JMenuItem("Save as " + RENDERER_SETS[i][0]);
            saveItem.addActionListener(new SaveListener((Renderer)RENDERER_SETS[i][1]));
            menu.add(saveItem);
        }
    }

    public GUI() {
        this.frame = new JFrame("PMD Duplicate Code Detector (v " + PMD.VERSION + ')');
        this.timeField.setEditable(false);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        this.addSaveOptionsTo(fileMenu);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('x');
        exitItem.addActionListener(new CancelListener());
        fileMenu.add(exitItem);
        JMenu viewMenu = new JMenu("View");
        fileMenu.setMnemonic('v');
        JCheckBoxMenuItem trimItem = new JCheckBoxMenuItem("Trim leading whitespace");
        trimItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AbstractButton button = (AbstractButton)e.getItem();
                GUI.this.trimLeadingWhitespace = button.isSelected();
            }
        });
        viewMenu.add(trimItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        this.frame.setJMenuBar(menuBar);
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        browseButton.addActionListener(new BrowseListener());
        this.goButton = new JButton("Go");
        this.goButton.setMnemonic('g');
        this.goButton.addActionListener(new GoListener());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new CancelListener());
        JPanel settingsPanel = this.makeSettingsPanel(browseButton, this.goButton, this.cancelButton);
        this.progressPanel = this.makeProgressPanel();
        JPanel resultsPanel = this.makeResultsPanel();
        this.adjustLanguageControlsFor((LanguageConfig)LANGUAGE_SETS[0][1]);
        this.frame.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)settingsPanel, "North");
        topPanel.add((Component)this.progressPanel, "Center");
        this.setProgressControls(false);
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)resultsPanel, "Center");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void adjustLanguageControlsFor(LanguageConfig current) {
        this.ignoreIdentifiersCheckbox.setEnabled(current.canIgnoreIdentifiers());
        this.ignoreLiteralsCheckbox.setEnabled(current.canIgnoreLiterals());
        this.ignoreAnnotationsCheckbox.setEnabled(current.canIgnoreAnnotations());
        this.extensionField.setText(current.extensions()[0]);
        boolean enableExtension = current.extensions()[0].length() == 0;
        this.extensionField.setEnabled(enableExtension);
        this.extensionLabel.setEnabled(enableExtension);
    }

    private JPanel makeSettingsPanel(JButton browseButton, JButton goButton, JButton cxButton) {
        JPanel settingsPanel = new JPanel();
        GridBagHelper helper = new GridBagHelper(settingsPanel, new double[]{0.2, 0.7, 0.1, 0.1});
        helper.addLabel("Root source directory:");
        helper.add(this.rootDirectoryField);
        helper.add(browseButton, 2);
        helper.nextRow();
        helper.addLabel("Report duplicate chunks larger than:");
        this.minimumLengthField.setColumns(4);
        helper.add(this.minimumLengthField);
        helper.addLabel("Language:");
        for (int i = 0; i < LANGUAGE_SETS.length; ++i) {
            this.languageBox.addItem(LANGUAGE_SETS[i][0]);
        }
        this.languageBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.adjustLanguageControlsFor(GUI.languageConfigFor((String)GUI.this.languageBox.getSelectedItem()));
            }
        });
        helper.add(this.languageBox);
        helper.nextRow();
        helper.addLabel("Also scan subdirectories?");
        helper.add(this.recurseCheckbox);
        helper.add(this.extensionLabel);
        helper.add(this.extensionField);
        helper.nextRow();
        helper.addLabel("Ignore literals?");
        helper.add(this.ignoreLiteralsCheckbox);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore identifiers?");
        helper.add(this.ignoreIdentifiersCheckbox);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore annotations?");
        helper.add(this.ignoreAnnotationsCheckbox);
        helper.add(goButton);
        helper.add(cxButton);
        helper.nextRow();
        helper.addLabel("File encoding (defaults based upon locale):");
        this.encodingField.setColumns(1);
        helper.add(this.encodingField);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        return settingsPanel;
    }

    private JPanel makeProgressPanel() {
        JPanel progressPanel = new JPanel();
        double[] weights = new double[]{0.0, 0.8, 0.4, 0.2};
        GridBagHelper helper = new GridBagHelper(progressPanel, weights);
        helper.addLabel("Tokenizing files:");
        helper.add(this.tokenizingFilesBar, 3);
        helper.nextRow();
        helper.addLabel("Phase:");
        helper.add(this.phaseLabel);
        helper.addLabel("Time elapsed:");
        helper.add(this.timeField);
        helper.nextRow();
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        return progressPanel;
    }

    private JPanel makeResultsPanel() {
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BorderLayout());
        JScrollPane areaScrollPane = new JScrollPane(this.resultsTextArea);
        this.resultsTextArea.setEditable(false);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(600, 300));
        resultsPanel.add((Component)this.makeMatchList(), "West");
        resultsPanel.add((Component)areaScrollPane, "Center");
        return resultsPanel;
    }

    private void populateResultArea() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        TableModel model = this.resultsTable.getModel();
        ArrayList<Match> selections = new ArrayList<Match>(selectionIndices.length);
        for (int i = 0; i < selectionIndices.length; ++i) {
            selections.add((Match)model.getValueAt(selectionIndices[i], 99));
        }
        String report = new SimpleRenderer(this.trimLeadingWhitespace).render(selections.iterator());
        this.resultsTextArea.setText(report);
        this.resultsTextArea.setCaretPosition(0);
    }

    private void copyMatchListSelectionsToClipboard() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        int colCount = this.resultsTable.getColumnCount();
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < selectionIndices.length; ++r) {
            if (r > 0) {
                sb.append('\n');
            }
            sb.append(this.resultsTable.getValueAt(selectionIndices[r], 0));
            for (int c = 1; c < colCount; ++c) {
                sb.append('\t');
                sb.append(this.resultsTable.getValueAt(selectionIndices[r], c));
            }
        }
        StringSelection ss = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    private void deleteMatchlistSelections() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        for (int i = selectionIndices.length - 1; i >= 0; --i) {
            this.matches.remove(selectionIndices[i]);
        }
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.addNotify();
    }

    private JComponent makeMatchList() {
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GUI.this.populateResultArea();
            }
        });
        this.resultsTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.copyMatchListSelectionsToClipboard();
            }
        }, "Copy", COPY_KEY_STROKE, 0);
        this.resultsTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.deleteMatchlistSelections();
            }
        }, "Del", DELETE_KEY_STROKE, 0);
        int[] alignments = new int[this.matchColumns.length];
        for (int i = 0; i < alignments.length; ++i) {
            alignments[i] = this.matchColumns[i].alignment();
        }
        this.resultsTable.setDefaultRenderer(Object.class, new AlignmentRenderer(alignments));
        final JTableHeader header = this.resultsTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GUI.this.sortOnColumn(header.columnAtPoint(new Point(e.getX(), e.getY())));
            }
        });
        return new JScrollPane(this.resultsTable);
    }

    private boolean isLegalPath(String path, LanguageConfig config) {
        String[] extensions = config.extensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!path.endsWith(extensions[i]) || extensions[i].length() <= 0) continue;
            return true;
        }
        return false;
    }

    private String setLabelFor(Match match) {
        String label;
        HashSet<String> sourceIDs = new HashSet<String>(match.getMarkCount());
        Iterator<TokenEntry> occurrences = match.iterator();
        while (occurrences.hasNext()) {
            sourceIDs.add(occurrences.next().getTokenSrcID());
        }
        if (sourceIDs.size() == 1) {
            String sourceId = (String)sourceIDs.iterator().next();
            int separatorPos = sourceId.lastIndexOf(File.separatorChar);
            label = "..." + sourceId.substring(separatorPos);
        } else {
            label = "(" + sourceIDs.size() + " separate files)";
        }
        match.setLabel(label);
        return label;
    }

    private void setProgressControls(boolean isRunning) {
        this.progressPanel.setVisible(isRunning);
        this.goButton.setEnabled(!isRunning);
        this.cancelButton.setEnabled(isRunning);
    }

    private void go() {
        String dirPath = this.rootDirectoryField.getText();
        try {
            if (!new File(dirPath).exists()) {
                JOptionPane.showMessageDialog(this.frame, "Can't read from that root source directory", "Error", 0);
                return;
            }
            this.setProgressControls(true);
            Properties p = new Properties();
            p.setProperty("ignore_identifiers", String.valueOf(this.ignoreIdentifiersCheckbox.isSelected()));
            p.setProperty("ignore_literals", String.valueOf(this.ignoreLiteralsCheckbox.isSelected()));
            p.setProperty("ignore_annotations", String.valueOf(this.ignoreAnnotationsCheckbox.isSelected()));
            p.setProperty("extension", this.extensionField.getText());
            LanguageConfig conf = GUI.languageConfigFor((String)this.languageBox.getSelectedItem());
            Language language = conf.languageFor(new LanguageFactory(), p);
            language.setProperties(p);
            CPDConfiguration config = new CPDConfiguration(Integer.parseInt(this.minimumLengthField.getText()), language, this.encodingField.getText());
            CPD cpd = new CPD(config);
            cpd.setCpdListener(this);
            this.tokenizingFilesBar.setMinimum(0);
            this.phaseLabel.setText("");
            if (this.isLegalPath(dirPath, conf)) {
                cpd.add(new File(dirPath));
            } else if (this.recurseCheckbox.isSelected()) {
                cpd.addRecursively(dirPath);
            } else {
                cpd.addAllInDirectory(dirPath);
            }
            Timer t = this.createTimer();
            t.start();
            cpd.go();
            t.stop();
            this.matches = new ArrayList<Match>();
            Iterator<Match> i = cpd.getMatches();
            while (i.hasNext()) {
                Match match = i.next();
                this.setLabelFor(match);
                this.matches.add(match);
            }
            this.setListDataFrom(cpd.getMatches());
            String report = new SimpleRenderer().render(cpd.getMatches());
            if (report.length() == 0) {
                JOptionPane.showMessageDialog(this.frame, "Done. Couldn't find any duplicates longer than " + this.minimumLengthField.getText() + " tokens");
            } else {
                this.resultsTextArea.setText(report);
            }
        }
        catch (IOException t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Halted due to " + t.getClass().getName() + "; " + t.getMessage());
        }
        catch (RuntimeException t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Halted due to " + t.getClass().getName() + "; " + t.getMessage());
        }
        this.setProgressControls(false);
    }

    private Timer createTimer() {
        final long start = System.currentTimeMillis();
        Timer t = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                long now = System.currentTimeMillis();
                long elapsedMillis = now - start;
                long elapsedSeconds = elapsedMillis / 1000L;
                long minutes = (long)Math.floor(elapsedSeconds / 60L);
                long seconds = elapsedSeconds - minutes * 60L;
                GUI.this.timeField.setText(GUI.formatTime(minutes, seconds));
            }
        });
        return t;
    }

    private static String formatTime(long minutes, long seconds) {
        StringBuilder sb = new StringBuilder(5);
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes).append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
        return sb.toString();
    }

    private TableModel tableModelFrom(final List<Match> items) {
        SortingTableModel<Match> model = new SortingTableModel<Match>(){
            private int sortColumn;
            private boolean sortDescending;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Match match = (Match)items.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return match.getLabel();
                    }
                    case 2: {
                        return Integer.toString(match.getLineCount());
                    }
                    case 1: {
                        return match.getMarkCount() > 2 ? Integer.toString(match.getMarkCount()) : "";
                    }
                    case 99: {
                        return match;
                    }
                }
                return "";
            }

            @Override
            public int getColumnCount() {
                return GUI.this.matchColumns.length;
            }

            @Override
            public int getRowCount() {
                return items.size();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Object.class;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            @Override
            public String getColumnName(int i) {
                return GUI.this.matchColumns[i].label();
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }

            @Override
            public int sortColumn() {
                return this.sortColumn;
            }

            @Override
            public void sortColumn(int column) {
                this.sortColumn = column;
            }

            @Override
            public boolean sortDescending() {
                return this.sortDescending;
            }

            @Override
            public void sortDescending(boolean flag) {
                this.sortDescending = flag;
            }

            @Override
            public void sort(Comparator<Match> comparator) {
                Collections.sort(items, comparator);
                if (this.sortDescending) {
                    Collections.reverse(items);
                }
            }
        };
        return model;
    }

    private void sortOnColumn(int columnIndex) {
        Comparator<Match> comparator = this.matchColumns[columnIndex].sorter();
        SortingTableModel model = (SortingTableModel)this.resultsTable.getModel();
        if (model.sortColumn() == columnIndex) {
            model.sortDescending(!model.sortDescending());
        }
        model.sortColumn(columnIndex);
        model.sort(comparator);
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.repaint();
    }

    private void setListDataFrom(Iterator iter) {
        this.resultsTable.setModel(this.tableModelFrom(this.matches));
        TableColumnModel colModel = this.resultsTable.getColumnModel();
        for (int i = 0; i < this.matchColumns.length; ++i) {
            if (this.matchColumns[i].width() <= 0) continue;
            TableColumn column = colModel.getColumn(i);
            int width = this.matchColumns[i].width();
            column.setPreferredWidth(width);
            column.setMinWidth(width);
            column.setMaxWidth(width);
        }
    }

    @Override
    public void phaseUpdate(int phase) {
        this.phaseLabel.setText(this.getPhaseText(phase));
    }

    public String getPhaseText(int phase) {
        switch (phase) {
            case 0: {
                return "Initializing";
            }
            case 1: {
                return "Hashing";
            }
            case 2: {
                return "Matching";
            }
            case 3: {
                return "Grouping";
            }
            case 4: {
                return "Done";
            }
        }
        return "Unknown";
    }

    @Override
    public void addedFile(int fileCount, File file) {
        this.tokenizingFilesBar.setMaximum(fileCount);
        this.tokenizingFilesBar.setValue(this.tokenizingFilesBar.getValue() + 1);
    }

    public static void main(String[] args) {
        new GUI();
    }

    static {
        for (int i = 0; i < LANGUAGE_SETS.length; ++i) {
            LANGUAGE_CONFIGS_BY_LABEL.put((String)LANGUAGE_SETS[i][0], (LanguageConfig)LANGUAGE_SETS[i][1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SortingTableModel<E>
    extends TableModel {
        public int sortColumn();

        public void sortColumn(int var1);

        public boolean sortDescending();

        public void sortDescending(boolean var1);

        public void sort(Comparator<E> var1);
    }

    private class AlignmentRenderer
    extends DefaultTableCellRenderer {
        private int[] alignments;

        public AlignmentRenderer(int[] theAlignments) {
            this.alignments = theAlignments;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(this.alignments[column]);
            return this;
        }
    }

    private class BrowseListener
    implements ActionListener {
        private BrowseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(GUI.this.rootDirectoryField.getText());
            fc.setFileSelectionMode(2);
            fc.showDialog(GUI.this.frame, "Select");
            if (fc.getSelectedFile() != null) {
                GUI.this.rootDirectoryField.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        final Renderer renderer;

        public SaveListener(Renderer theRenderer) {
            this.renderer = theRenderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            block5: {
                File f;
                block6: {
                    JFileChooser fcSave = new JFileChooser();
                    int ret = fcSave.showSaveDialog(GUI.this.frame);
                    f = fcSave.getSelectedFile();
                    if (f == null || ret != 0) {
                        return;
                    }
                    if (f.canWrite()) break block6;
                    PrintWriter pw = null;
                    try {
                        pw = new PrintWriter(new FileOutputStream(f));
                        pw.write(this.renderer.render(GUI.this.matches.iterator()));
                        pw.flush();
                        JOptionPane.showMessageDialog(GUI.this.frame, "Saved " + GUI.this.matches.size() + " matches");
                    }
                    catch (IOException e) {
                        try {
                            this.error("Couldn't save file" + f.getAbsolutePath(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeQuietly(pw);
                            throw throwable;
                        }
                        IOUtil.closeQuietly(pw);
                        break block5;
                    }
                    IOUtil.closeQuietly(pw);
                    break block5;
                }
                this.error("Could not write to file " + f.getAbsolutePath(), null);
            }
        }

        private void error(String message, Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(GUI.this.frame, message);
        }
    }

    private class GoListener
    implements ActionListener {
        private GoListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                public void run() {
                    GUI.this.tokenizingFilesBar.setValue(0);
                    GUI.this.tokenizingFilesBar.setString("");
                    GUI.this.resultsTextArea.setText("");
                    GUI.this.phaseLabel.setText("");
                    GUI.this.timeField.setText("");
                    GUI.this.go();
                }
            }).start();
        }
    }

    private static class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnSpec {
        private String label;
        private int alignment;
        private int width;
        private Comparator<Match> sorter;

        public ColumnSpec(String aLabel, int anAlignment, int aWidth, Comparator<Match> aSorter) {
            this.label = aLabel;
            this.alignment = anAlignment;
            this.width = aWidth;
            this.sorter = aSorter;
        }

        public String label() {
            return this.label;
        }

        public int alignment() {
            return this.alignment;
        }

        public int width() {
            return this.width;
        }

        public Comparator<Match> sorter() {
            return this.sorter;
        }
    }

    private static abstract class LanguageConfig {
        private LanguageConfig() {
        }

        public abstract Language languageFor(LanguageFactory var1, Properties var2);

        public boolean canIgnoreIdentifiers() {
            return false;
        }

        public boolean canIgnoreLiterals() {
            return false;
        }

        public boolean canIgnoreAnnotations() {
            return false;
        }

        public abstract String[] extensions();
    }
}

