/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FilenameFilter;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;

public class CPDConfiguration
extends AbstractConfiguration {
    private Language language;
    private int minimumTileSize;
    private boolean skipDuplicates;
    private Renderer renderer;
    private static final int MISSING_REQUIRED_ARGUMENT = 3;

    public CPDConfiguration(String[] args) {
        String languageString = CPDConfiguration.findOptionalStringValue(args, "--language", "java");
        this.language = new LanguageFactory().createLanguage(languageString);
        String formatString = CPDConfiguration.findOptionalStringValue(args, "--format", "text");
        this.renderer = CPDConfiguration.getRendererFromString(formatString);
        String systemDefaultEncoding = System.getProperty("file.encoding");
        this.setEncoding(CPDConfiguration.findOptionalStringValue(args, "--encoding", systemDefaultEncoding));
        this.minimumTileSize = Integer.parseInt(CPDConfiguration.findRequiredStringValue(args, "--minimum-tokens"));
        this.skipDuplicates = CPDConfiguration.findBooleanSwitch(args, "--skip-duplicate-files");
    }

    public CPDConfiguration(int theMinTileSize, Language theLanguage, String theEncoding) {
        this.minimumTileSize = theMinTileSize;
        this.language = theLanguage;
        this.setEncoding(theEncoding);
    }

    public void setEncoding(String theEncoding) {
        super.setSourceEncoding(theEncoding);
        if (!theEncoding.equals(System.getProperty("file.encoding"))) {
            System.setProperty("file.encoding", theEncoding);
        }
    }

    public SourceCode sourceCodeFor(File file) {
        return new SourceCode(new SourceCode.FileCodeLoader(file, this.getSourceEncoding()));
    }

    public Language language() {
        return this.language;
    }

    public int minimumTileSize() {
        return this.minimumTileSize;
    }

    public boolean skipDuplicates() {
        return this.skipDuplicates;
    }

    public void skipDuplicates(boolean flag) {
        this.skipDuplicates = flag;
    }

    public FilenameFilter filenameFilter() {
        return this.language.getFileFilter();
    }

    public Tokenizer tokenizer() {
        return this.language.getTokenizer();
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public static Renderer getRendererFromString(String name) {
        if (name.equalsIgnoreCase("text") || name.equals("")) {
            return new SimpleRenderer();
        }
        if ("xml".equals(name)) {
            return new XMLRenderer();
        }
        if ("csv".equals(name)) {
            return new CSVRenderer();
        }
        if ("vs".equals(name)) {
            return new VSRenderer();
        }
        try {
            return (Renderer)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            System.out.println("Can't find class '" + name + "', defaulting to SimpleRenderer.");
            return new SimpleRenderer();
        }
    }

    public static boolean findBooleanSwitch(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String findOptionalStringValue(String[] args, String name, String defaultValue) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        return defaultValue;
    }

    private static String findRequiredStringValue(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        System.out.println("No " + name + " value passed in");
        CPD.showUsage();
        System.exit(3);
        return "";
    }
}

