/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationMetadata;
import net.sourceforge.stripes.validation.ValidationMetadataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationMetadataProvider
implements ValidationMetadataProvider {
    private static final Log log = Log.getInstance(DefaultValidationMetadataProvider.class);
    private Configuration configuration;
    private final Map<Class<?>, Map<String, ValidationMetadata>> cache = new ConcurrentHashMap();

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, ValidationMetadata> getValidationMetadata(Class<?> beanType) {
        Map<String, ValidationMetadata> meta = this.cache.get(beanType);
        if (meta == null) {
            meta = this.loadForClass(beanType);
            this.cache.put(beanType, meta);
        }
        return meta;
    }

    @Override
    public ValidationMetadata getValidationMetadata(Class<?> beanType, ParameterName field) {
        return this.getValidationMetadata(beanType).get(field.getStrippedName());
    }

    protected Map<String, ValidationMetadata> loadForClass(Class<?> beanType) {
        HashMap<String, ValidationMetadata> meta = new HashMap<String, ValidationMetadata>();
        HashSet<String> seen = new HashSet<String>();
        try {
            for (Class<?> clazz = beanType; clazz != null; clazz = clazz.getSuperclass()) {
                Field[] publicFields;
                ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>(Arrays.asList(ReflectUtil.getPropertyDescriptors(clazz)));
                for (Field field : publicFields = clazz.getFields()) {
                    pds.add(new PropertyDescriptor(field.getName(), null, null));
                }
                for (PropertyDescriptor pd : pds) {
                    Validate[] validates;
                    ValidateNestedProperties nested;
                    Validate simple;
                    String propertyName = pd.getName();
                    Method accessor = pd.getReadMethod();
                    Method mutator = pd.getWriteMethod();
                    Field field = null;
                    try {
                        field = clazz.getDeclaredField(propertyName);
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                    boolean onAccessor = accessor != null && Modifier.isPublic(accessor.getModifiers()) && accessor.getDeclaringClass().equals(clazz) && (accessor.isAnnotationPresent(Validate.class) || accessor.isAnnotationPresent(ValidateNestedProperties.class));
                    boolean onMutator = mutator != null && Modifier.isPublic(mutator.getModifiers()) && mutator.getDeclaringClass().equals(clazz) && (mutator.isAnnotationPresent(Validate.class) || mutator.isAnnotationPresent(ValidateNestedProperties.class));
                    boolean onField = field != null && !Modifier.isStatic(field.getModifiers()) && field.getDeclaringClass().equals(clazz) && (field.isAnnotationPresent(Validate.class) || field.isAnnotationPresent(ValidateNestedProperties.class));
                    int count = 0;
                    if (onAccessor) {
                        ++count;
                    }
                    if (onMutator) {
                        ++count;
                    }
                    if (onField) {
                        ++count;
                    }
                    if (count > 1) {
                        boolean hasNested;
                        boolean hasSimple;
                        StringBuilder buf = new StringBuilder("There are conflicting @Validate and/or @ValidateNestedProperties annotations in ").append(clazz).append(". The following elements are improperly annotated for the '").append(propertyName).append("' property:\n");
                        if (onAccessor) {
                            hasSimple = accessor.isAnnotationPresent(Validate.class);
                            hasNested = accessor.isAnnotationPresent(ValidateNestedProperties.class);
                            buf.append("--> Getter method ").append(accessor.getName()).append(" is annotated with ");
                            if (hasSimple) {
                                buf.append("@Validate");
                            }
                            if (hasSimple && hasNested) {
                                buf.append(" and ");
                            }
                            if (hasNested) {
                                buf.append("@ValidateNestedProperties");
                            }
                            buf.append('\n');
                        }
                        if (onMutator) {
                            hasSimple = mutator.isAnnotationPresent(Validate.class);
                            hasNested = mutator.isAnnotationPresent(ValidateNestedProperties.class);
                            buf.append("--> Setter method ").append(mutator.getName()).append(" is annotated with ");
                            if (hasSimple) {
                                buf.append("@Validate");
                            }
                            if (hasSimple && hasNested) {
                                buf.append(" and ");
                            }
                            if (hasNested) {
                                buf.append("@ValidateNestedProperties");
                            }
                            buf.append('\n');
                        }
                        if (onField) {
                            hasSimple = field.isAnnotationPresent(Validate.class);
                            hasNested = field.isAnnotationPresent(ValidateNestedProperties.class);
                            buf.append("--> Field ").append(field.getName()).append(" is annotated with ");
                            if (hasSimple) {
                                buf.append("@Validate");
                            }
                            if (hasSimple && hasNested) {
                                buf.append(" and ");
                            }
                            if (hasNested) {
                                buf.append("@ValidateNestedProperties");
                            }
                            buf.append('\n');
                        }
                        throw new StripesRuntimeException(buf.toString());
                    }
                    if (seen.contains(propertyName)) continue;
                    if (onAccessor) {
                        simple = accessor.getAnnotation(Validate.class);
                        nested = accessor.getAnnotation(ValidateNestedProperties.class);
                        seen.add(propertyName);
                    } else if (onMutator) {
                        simple = mutator.getAnnotation(Validate.class);
                        nested = mutator.getAnnotation(ValidateNestedProperties.class);
                        seen.add(propertyName);
                    } else if (onField) {
                        simple = field.getAnnotation(Validate.class);
                        nested = field.getAnnotation(ValidateNestedProperties.class);
                        seen.add(propertyName);
                    } else {
                        simple = null;
                        nested = null;
                    }
                    if (simple != null) {
                        if (simple.field() == null || "".equals(simple.field())) {
                            meta.put(propertyName, new ValidationMetadata(propertyName, simple));
                        } else {
                            log.warn("Field name present in @Validate but should be omitted: ", clazz, ", property ", propertyName, ", given field name ", simple.field());
                        }
                    }
                    if (nested == null || (validates = nested.value()) == null) continue;
                    for (Validate validate : validates) {
                        if (validate.field() != null && !"".equals(validate.field())) {
                            String fullName = propertyName + '.' + validate.field();
                            if (meta.containsKey(fullName)) {
                                log.warn("More than one nested @Validate with same field name: " + validate.field() + " on property " + propertyName);
                            }
                            meta.put(fullName, new ValidationMetadata(fullName, validate));
                            continue;
                        }
                        log.warn("Field name missing from nested @Validate: ", clazz, ", property ", propertyName);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            log.error(e, "Failure checking @Validate annotations ", this.getClass().getName());
            throw e;
        }
        catch (Exception e) {
            log.error(e, "Failure checking @Validate annotations ", this.getClass().getName());
            StripesRuntimeException sre = new StripesRuntimeException(e.getMessage(), e);
            sre.setStackTrace(e.getStackTrace());
            throw sre;
        }
        StringBuilder builder = new StringBuilder(128);
        for (Map.Entry entry : meta.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append((String)entry.getKey());
            builder.append("->");
            builder.append(entry.getValue());
        }
        log.debug("Loaded validations for ActionBean ", beanType.getSimpleName(), ": ", builder.length() > 0 ? builder : "<none>");
        return Collections.unmodifiableMap(meta);
    }
}

