/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTypeConverter
implements TypeConverter<Date> {
    private Locale locale;
    private DateFormat[] formats;
    public static final Pattern PRE_PROCESS_PATTERN = Pattern.compile("(?<!GMT)[\\s,/\\.-]+");
    public static final String[] formatStrings = new String[]{"d MMM yy", "yyyy M d", "yyyy MMM d", "EEE MMM dd HH:mm:ss zzz yyyy"};
    public static final String KEY_FORMAT_STRINGS = "stripes.dateTypeConverter.formatStrings";
    public static final String KEY_PRE_PROCESS_PATTERN = "stripes.dateTypeConverter.preProcessPattern";

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.formats = this.getDateFormats();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String[] getFormatStrings() {
        try {
            return this.getResourceString(KEY_FORMAT_STRINGS).split(", *");
        }
        catch (MissingResourceException mre) {
            int[] dateFormats = new int[]{3, 2, 1};
            String[] formatStrings = new String[dateFormats.length + DateTypeConverter.formatStrings.length];
            for (int i = 0; i < dateFormats.length; ++i) {
                SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(dateFormats[i], this.locale);
                formatStrings[i] = this.preProcessInput(dateFormat.toPattern());
            }
            System.arraycopy(DateTypeConverter.formatStrings, 0, formatStrings, dateFormats.length, DateTypeConverter.formatStrings.length);
            return formatStrings;
        }
    }

    protected DateFormat[] getDateFormats() {
        String[] formatStrings = this.getFormatStrings();
        DateFormat[] dateFormats = new SimpleDateFormat[formatStrings.length];
        for (int i = 0; i < formatStrings.length; ++i) {
            dateFormats[i] = new SimpleDateFormat(formatStrings[i], this.locale);
            dateFormats[i].setLenient(false);
        }
        return dateFormats;
    }

    @Override
    public Date convert(String input, Class<? extends Date> targetType, Collection<ValidationError> errors) {
        String parseable = this.preProcessInput(input);
        Date date = null;
        for (DateFormat format : this.formats) {
            try {
                date = format.parse(parseable);
                break;
            }
            catch (ParseException pe) {
            }
        }
        if (date != null) {
            return date;
        }
        errors.add(new ScopedLocalizableError("converter.date", "invalidDate", new Object[0]));
        return null;
    }

    protected Pattern getPreProcessPattern() {
        try {
            return Pattern.compile(this.getResourceString(KEY_PRE_PROCESS_PATTERN));
        }
        catch (MissingResourceException exc) {
            return PRE_PROCESS_PATTERN;
        }
    }

    protected String preProcessInput(String input) {
        input = this.getPreProcessPattern().matcher(input.trim()).replaceAll(" ");
        input = this.checkAndAppendYear(input);
        return input;
    }

    protected String checkAndAppendYear(String input) {
        int count = 0;
        for (char ch : input.toCharArray()) {
            if (ch != ' ') continue;
            ++count;
        }
        if (count == 1) {
            input = input + " " + Calendar.getInstance(this.locale).get(1);
        }
        return input;
    }

    protected String getResourceString(String key) throws MissingResourceException {
        return StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(this.locale).getString(key);
    }
}

