/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Literal;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    private static final Log log = Log.getInstance(ReflectUtil.class);
    private static Map<Class<?>, Map<String, PropertyDescriptor>> propertyDescriptors = new ConcurrentHashMap();
    protected static final Map<Class<?>, Class<?>> interfaceImplementations = new HashMap();
    protected static final Map<Class<?>, Object> primitiveDefaults = new HashMap();
    private static final Set<String> INHERITED_ANNOTATION_METHODS;

    private ReflectUtil() {
    }

    public static Class<?> getImplementingClass(Class<?> iface) {
        return interfaceImplementations.get(iface);
    }

    public static <T> T getInterfaceInstance(Class<T> interfaceType) throws InstantiationException, IllegalAccessException {
        Class<?> impl = ReflectUtil.getImplementingClass(interfaceType);
        if (impl == null) {
            throw new InstantiationException("Stripes needed to instantiate a property who's declared type as an interface (which obviously cannot be instantiated. The interface is not one that Stripes is aware of, so no implementing class was known. The interface type was: '" + interfaceType.getName() + "'. To fix this " + "you'll need to do one of three things. 1) Change the getter/setter methods " + "to use a concrete type so that Stripes can instantiate it. 2) in the bean's " + "setContext() method pre-instantiate the property so Stripes doesn't have to. " + "3) Bug the Stripes author ;)  If the interface is a JDK type it can easily be " + "fixed. If not, if enough people ask, a generic way to handle the problem " + "might get implemented.");
        }
        return (T)impl.newInstance();
    }

    public static Class findClass(String name) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(name);
    }

    public static String toString(Annotation ann) {
        try {
            Method[] methods;
            Class<? extends Annotation> type = ann.annotationType();
            StringBuilder builder = new StringBuilder(128);
            builder.append("@");
            builder.append(type.getSimpleName());
            boolean appendedAnyParameters = false;
            for (Method method : methods = type.getMethods()) {
                if (INHERITED_ANNOTATION_METHODS.contains(method.getName())) continue;
                Object defaultValue = method.getDefaultValue();
                Object actualValue = method.invoke((Object)ann, new Object[0]);
                Object[] defaultArray = null;
                Object[] actualArray = null;
                if (Object[].class.isAssignableFrom(method.getReturnType())) {
                    defaultArray = (Object[])defaultValue;
                    actualArray = (Object[])actualValue;
                }
                if ((defaultArray == null || Arrays.equals(defaultArray, actualArray)) && (defaultArray != null || actualValue.equals(defaultValue))) continue;
                if (appendedAnyParameters) {
                    builder.append(", ");
                } else {
                    builder.append("(");
                }
                builder.append(method.getName());
                builder.append("=");
                if (actualArray != null) {
                    builder.append(Arrays.toString(actualArray));
                } else {
                    builder.append(actualValue);
                }
                appendedAnyParameters = true;
            }
            if (appendedAnyParameters) {
                builder.append(")");
            }
            return builder.toString();
        }
        catch (Exception e) {
            return ann.toString();
        }
    }

    public static Collection<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> found = new ArrayList<Method>();
        while (clazz != null) {
            for (Method m1 : clazz.getDeclaredMethods()) {
                boolean overridden = false;
                for (Method m2 : found) {
                    if (!m2.getName().equals(m1.getName()) || !Arrays.deepEquals(m1.getParameterTypes(), m2.getParameterTypes())) continue;
                    overridden = true;
                    break;
                }
                if (overridden) continue;
                found.add(m1);
            }
            clazz = clazz.getSuperclass();
        }
        return found;
    }

    public static Collection<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
        if (!propertyDescriptors.containsKey(clazz)) {
            ReflectUtil.getPropertyDescriptors(clazz);
        }
        return propertyDescriptors.get(clazz).get(property);
    }

    public static Method findAccessibleMethod(Method m) {
        if (Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return m;
        }
        if (m.isAccessible()) {
            return m;
        }
        Class<?> clazz = m.getDeclaringClass();
        String name = m.getName();
        Class<?>[] ptypes = m.getParameterTypes();
        for (Class<?> iface : clazz.getInterfaces()) {
            try {
                Method m2 = iface.getMethod(name, ptypes);
                if (m2.isAccessible()) {
                    return m2;
                }
                if (!Modifier.isPublic(iface.getModifiers()) || !Modifier.isPublic(m2.getModifiers())) continue;
                return m2;
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
        for (Class<?> c = clazz.getSuperclass(); c != null; c = c.getSuperclass()) {
            try {
                Method m2 = c.getMethod(name, ptypes);
                if (m2.isAccessible()) {
                    return m2;
                }
                if (!Modifier.isPublic(c.getModifiers()) || !Modifier.isPublic(m2.getModifiers())) continue;
                return m2;
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
        return m;
    }

    public static Field getField(Class<?> clazz, String property) {
        try {
            Field field = clazz.getField(property);
            return !Modifier.isStatic(field.getModifiers()) ? field : null;
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return primitiveDefaults.get(clazz);
        }
        return null;
    }

    public static Set<Class<?>> getImplementedInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        while (clazz != null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                interfaces.addAll(ReflectUtil.getImplementedInterfaces(iface));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static Type[] getActualTypeArguments(Class<?> clazz, Class<?> targetType) {
        HashSet classes = new HashSet();
        classes.add(clazz);
        if (targetType.isInterface()) {
            classes.addAll(ReflectUtil.getImplementedInterfaces(clazz));
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.add(superClass);
        }
        for (Class clazz2 : classes) {
            Type[] typeArray;
            if (targetType.isInterface()) {
                typeArray = clazz2.getGenericInterfaces();
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = clazz2.getGenericSuperclass();
            }
            for (Type type : typeArray) {
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !targetType.equals((parameterizedType = (ParameterizedType)type).getRawType())) continue;
                return parameterizedType.getActualTypeArguments();
            }
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        if (propertyDescriptors.containsKey(clazz)) {
            Collection<PropertyDescriptor> pds = propertyDescriptors.get(clazz).values();
            return pds.toArray(new PropertyDescriptor[pds.size()]);
        }
        try {
            PropertyDescriptor[] pds = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            pds = Arrays.asList(pds).toArray(new PropertyDescriptor[pds.length]);
            LinkedHashMap<String, PropertyDescriptor> map = new LinkedHashMap<String, PropertyDescriptor>();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                if (pd.getReadMethod() != null && pd.getReadMethod().isBridge() || pd.getWriteMethod() != null && pd.getWriteMethod().isBridge()) {
                    log.debug("Working around JVM bug involving PropertyDescriptors ", "and bridge methods for ", clazz);
                    if (pd.getWriteMethod() == null && pd.getReadMethod() != null && pd.getReadMethod().isBridge()) {
                        try {
                            pd = new PropertyDescriptor(pd.getName(), clazz);
                            log.debug("Working around JVM bug http://bugs.sun.com/view_bug.do?bug_id=6794807");
                        }
                        catch (IntrospectionException e) {
                            // empty catch block
                        }
                    }
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class BridgedPropertyDescriptor
                    extends PropertyDescriptor {
                        private Method readMethod;
                        private Method writeMethod;
                        private Class<?> propertyType;

                        public BridgedPropertyDescriptor(PropertyDescriptor pd) throws IntrospectionException {
                            super(pd.getName(), pd.getReadMethod(), pd.getWriteMethod());
                            this.readMethod = ReflectUtil.resolveBridgedReadMethod(pd);
                            this.writeMethod = ReflectUtil.resolveBridgedWriteMethod(pd);
                            this.propertyType = ReflectUtil.resolvePropertyType(this);
                        }

                        @Override
                        public synchronized Class<?> getPropertyType() {
                            return this.propertyType;
                        }

                        @Override
                        public synchronized Method getReadMethod() {
                            return this.readMethod;
                        }

                        @Override
                        public synchronized Method getWriteMethod() {
                            return this.writeMethod;
                        }

                        @Override
                        public synchronized void setReadMethod(Method readMethod) {
                            this.readMethod = readMethod;
                        }

                        @Override
                        public synchronized void setWriteMethod(Method writeMethod) {
                            this.writeMethod = writeMethod;
                        }
                    }
                    pds[i] = pd = new BridgedPropertyDescriptor(pd);
                }
                map.put(pd.getName(), pd);
            }
            propertyDescriptors.put(clazz, map);
            return pds;
        }
        catch (IntrospectionException ie) {
            throw new StripesRuntimeException("Could not examine class '" + clazz.getName() + "' using Introspector.getBeanInfo() to determine property information.", ie);
        }
    }

    public static Method resolveBridgedReadMethod(PropertyDescriptor pd) {
        Method getter = pd.getReadMethod();
        if (getter != null && getter.isBridge()) {
            try {
                getter = getter.getDeclaringClass().getMethod(getter.getName(), new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return getter;
    }

    public static Method resolveBridgedWriteMethod(PropertyDescriptor pd) {
        Method setter = pd.getWriteMethod();
        if (setter != null && setter.isBridge()) {
            Method[] methods;
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (Method method : methods = setter.getDeclaringClass().getMethods()) {
                if (method.isBridge() || !method.getName().equals(setter.getName()) || method.getParameterTypes().length != 1 || !pd.getPropertyType().isAssignableFrom(method.getParameterTypes()[0])) continue;
                candidates.add(method);
            }
            if (candidates.size() == 1) {
                setter = (Method)candidates.get(0);
            } else if (candidates.isEmpty()) {
                log.error("Something has gone awry! I have a bridge to nowhere: ", setter);
            } else {
                HashSet<Type> typeArgs = new HashSet<Type>();
                for (Method method : candidates) {
                    Class<?> declarer = method.getDeclaringClass();
                    for (Class<?> iface : ReflectUtil.getImplementedInterfaces(declarer)) {
                        Type[] types = ReflectUtil.getActualTypeArguments(declarer, iface);
                        if (types == null) continue;
                        typeArgs.addAll(Arrays.asList(types));
                    }
                    for (Class<?> c = declarer.getSuperclass(); c != null; c = c.getSuperclass()) {
                        Type[] types = ReflectUtil.getActualTypeArguments(declarer, c);
                        if (types == null) continue;
                        typeArgs.addAll(Arrays.asList(types));
                    }
                }
                ArrayList primeCandidates = new ArrayList(candidates);
                Iterator iterator = primeCandidates.iterator();
                while (iterator.hasNext()) {
                    if (typeArgs.contains(((Method)iterator.next()).getParameterTypes()[0])) continue;
                    iterator.remove();
                }
                if (primeCandidates.size() == 1) {
                    setter = (Method)primeCandidates.get(0);
                } else {
                    log.warn("Unable to locate a bridged setter for ", pd.getName(), " due to a JVM bug and an overloaded method with ", "the same name as the property setter. This could be a problem. ", "The offending overloaded methods are: ", candidates);
                }
            }
        }
        return setter;
    }

    public static Class<?> resolvePropertyType(PropertyDescriptor pd) {
        Class<?> paramType;
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        Class<?> returnType = readMethod == null ? null : readMethod.getReturnType();
        Class<?> clazz = paramType = writeMethod == null ? null : writeMethod.getParameterTypes()[0];
        if (readMethod != null && writeMethod == null) {
            return returnType;
        }
        if (writeMethod != null && readMethod == null) {
            return paramType;
        }
        if (returnType == paramType) {
            return returnType;
        }
        return returnType.isAssignableFrom(paramType) ? paramType : returnType;
    }

    static {
        interfaceImplementations.put(Collection.class, ArrayList.class);
        interfaceImplementations.put(List.class, ArrayList.class);
        interfaceImplementations.put(Set.class, HashSet.class);
        interfaceImplementations.put(SortedSet.class, TreeSet.class);
        interfaceImplementations.put(Queue.class, LinkedList.class);
        interfaceImplementations.put(Map.class, HashMap.class);
        interfaceImplementations.put(SortedMap.class, TreeMap.class);
        primitiveDefaults.put(Boolean.TYPE, false);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveDefaults.put(Byte.TYPE, new Byte("0"));
        primitiveDefaults.put(Short.TYPE, new Short("0"));
        primitiveDefaults.put(Integer.TYPE, new Integer(0));
        primitiveDefaults.put(Long.TYPE, new Long(0L));
        primitiveDefaults.put(Float.TYPE, new Float(0.0f));
        primitiveDefaults.put(Double.TYPE, new Double(0.0));
        INHERITED_ANNOTATION_METHODS = Literal.set("toString", "equals", "hashCode", "annotationType");
    }
}

