/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout.buffered;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.tag.layout.buffered.LayoutDefinitionTag;
import net.sourceforge.stripes.tag.layout.buffered.LayoutRenderTag;
import net.sourceforge.stripes.util.Log;

public class LayoutComponentTag
extends StripesTagSupport
implements BodyTag {
    private static final Log log = Log.getInstance(LayoutComponentTag.class);
    private String name;
    private BodyContent bodyContent;
    private LayoutDefinitionTag definitionTag;
    private LayoutRenderTag renderTag;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0) {
            int length = name.length();
            boolean validJava = Character.isJavaIdentifierStart(name.charAt(0));
            for (int index = 1; validJava && index < length; ++index) {
                validJava = Character.isJavaIdentifierPart(name.charAt(index));
            }
            if (!validJava) {
                log.warn("The layout-component name '", name, "' is not a valid Java identifier. ", "While this may work, it can cause bugs that are difficult to track down. Please ", "consider using valid Java identifiers for component names (no hyphens, no spaces, etc.)");
            }
        }
        this.name = name;
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public int doStartTag() throws JspException {
        this.definitionTag = this.getParentTag(LayoutDefinitionTag.class);
        this.renderTag = this.getParentTag(LayoutRenderTag.class);
        if (this.renderTag != null) {
            return 2;
        }
        if (this.definitionTag.permissionToRender(this.name)) {
            return 1;
        }
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.renderTag != null && this.bodyContent != null) {
            this.renderTag.addComponent(this.name, this.bodyContent.getString());
        }
        this.definitionTag = null;
        this.renderTag = null;
        return 6;
    }
}

