/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;

public class LayoutWriter
extends Writer {
    private static final Log log = Log.getInstance(LayoutWriter.class);
    private static final char TOGGLE = '\u0000';
    private LinkedList<Writer> writers = new LinkedList();
    private boolean silent;
    private boolean silentState;

    public LayoutWriter(JspWriter out) {
        log.debug("Create layout writer wrapped around ", out);
        this.writers.addFirst((Writer)out);
    }

    protected Writer getOut() {
        return this.writers.peek();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent, PageContext pageContext) throws IOException {
        if (silent != this.silent) {
            pageContext.getOut().write(0);
            this.silent = silent;
            log.trace("Output is ", silent ? "DISABLED" : "ENABLED");
        }
    }

    public void openBuffer(PageContext pageContext) {
        log.trace("Open buffer");
        this.tryFlush(pageContext);
        this.writers.addFirst(new StringWriter(1024));
    }

    public String closeBuffer(PageContext pageContext) {
        if (this.getOut() instanceof StringWriter) {
            this.tryFlush(pageContext);
            String contents = ((StringWriter)this.writers.poll()).toString();
            log.trace("Closed buffer: \"", contents, "\"");
            return contents;
        }
        throw new StripesRuntimeException("Attempt to close a buffer without having first called openBuffer(..)!");
    }

    protected void tryFlush(PageContext pageContext) {
        try {
            if (pageContext != null) {
                pageContext.getOut().flush();
            }
        }
        catch (IOException e) {
            log.debug("Failed to flush buffer: ", e.getMessage());
        }
    }

    public void close() throws IOException {
        this.getOut().close();
    }

    public void flush() throws IOException {
        this.getOut().flush();
    }

    public void clear() throws IOException {
        Writer out = this.getOut();
        if (out instanceof JspWriter) {
            ((JspWriter)out).clear();
        } else if (out instanceof StringWriter) {
            ((StringWriter)out).getBuffer().setLength(0);
        } else {
            throw new StripesRuntimeException("How did I get a writer of type " + out.getClass().getName() + "??");
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int i;
        int mark = i = off;
        int n = i + len;
        while (i < n) {
            switch (cbuf[i]) {
                case '\u0000': {
                    if (this.silentState) {
                        mark = i + 1;
                    } else if (i > mark) {
                        this.getOut().write(cbuf, mark, i - mark);
                    }
                    this.silentState = !this.silentState;
                    break;
                }
                default: {
                    if (this.silentState) {
                        ++mark;
                        break;
                    }
                    if (i < mark || i != n - 1) break;
                    this.getOut().write(cbuf, mark, i - mark + 1);
                }
            }
            ++i;
        }
    }
}

