/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tag.layout.LayoutContext;
import net.sourceforge.stripes.tag.layout.LayoutTag;

public class LayoutDefinitionTag
extends LayoutTag {
    private LayoutContext context;
    private boolean renderPhase;
    private boolean silent;

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.context = LayoutContext.lookup(pageContext);
        if (this.context == null || this.getLayoutParent() != null) {
            throw new StripesRuntimeException("The JSP page " + this.getCurrentPagePath() + " contains a layout-definition tag and was invoked directly. " + "A layout-definition can only be invoked by a page that contains " + "a layout-render tag.");
        }
        this.renderPhase = this.context.isComponentRenderPhase();
        this.silent = this.context.getOut().isSilent();
    }

    public int doStartTag() throws JspException {
        try {
            this.context.setRendered(true);
            if (!this.renderPhase) {
                for (Map.Entry<String, Object> entry : this.context.getParameters().entrySet()) {
                    this.pageContext.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            this.exportComponentRenderers();
            this.context.getOut().setSilent(this.renderPhase, this.pageContext);
            return 1;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public int doEndTag() throws JspException {
        try {
            this.cleanUpComponentRenderers();
            this.context.getOut().setSilent(this.silent, this.pageContext);
            int n = 5;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.context = null;
            this.renderPhase = false;
            this.silent = false;
        }
    }
}

