/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.ParameterizableTag;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinkTagSupport
extends HtmlTagSupport
implements ParameterizableTag {
    private static final Log log = Log.getInstance(LinkTagSupport.class);
    private static final String VALUE_NOT_SET = "VALUE_NOT_SET";
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String event = "VALUE_NOT_SET";
    private Object beanclass;
    private String url;
    private String anchor;
    private boolean addSourcePage = false;
    private Boolean prependContext;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void addParameter(String name, Object valueOrValues) {
        this.parameters.put(name, valueOrValues);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEvent() {
        return this.event;
    }

    public void setBeanclass(Object beanclass) {
        this.beanclass = beanclass;
    }

    public Object getBeanclass() {
        return this.beanclass;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public boolean isAddSourcePage() {
        return this.addSourcePage;
    }

    public void setAddSourcePage(boolean addSourcePage) {
        this.addSourcePage = addSourcePage;
    }

    public Boolean isPrependContext() {
        return this.prependContext;
    }

    public void setPrependContext(Boolean prependContext) {
        this.prependContext = prependContext;
    }

    protected String getPreferredBaseUrl() throws StripesJspException {
        if (this.beanclass != null) {
            String beanHref = this.getActionBeanUrl(this.beanclass);
            if (beanHref == null) {
                throw new StripesJspException("The value supplied for the 'beanclass' attribute does not represent a valid ActionBean. The value supplied was '" + this.beanclass + "'. If you're prototyping, or your bean isn't ready yet " + "and you want this exception to go away, just use 'href' for now instead.");
            }
            return beanHref;
        }
        return this.getUrl();
    }

    protected String buildUrl() throws StripesJspException {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)this.getPageContext().getResponse();
        String base = this.getPreferredBaseUrl();
        UrlBuilder builder = new UrlBuilder(this.pageContext.getRequest().getLocale(), base, false);
        if (this.event != VALUE_NOT_SET) {
            builder.setEvent(this.event == null || this.event.length() < 1 ? null : this.event);
        }
        if (this.addSourcePage) {
            builder.addParameter("_sourcePage", CryptoUtil.encrypt(request.getServletPath()));
        }
        if (this.anchor != null) {
            builder.setAnchor(this.anchor);
        }
        builder.addParameters(this.parameters);
        String url = builder.toString();
        String contextPath = request.getContextPath();
        if (contextPath.length() > 1) {
            boolean prepend;
            boolean bl = prepend = this.prependContext != null && this.prependContext != false || this.prependContext == null && this.beanclass != null || this.prependContext == null && url.startsWith("/") && !url.startsWith(contextPath);
            if (prepend) {
                if (url.startsWith("/")) {
                    url = contextPath + url;
                } else {
                    log.warn("Use of prependContext=\"true\" is only valid with a URL that starts with \"/\"");
                }
            }
        }
        return response.encodeURL(url);
    }
}

