/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.InputOptionTag;
import net.sourceforge.stripes.util.CollectionUtil;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.util.bean.BeanComparator;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;

public class InputOptionsCollectionTag
extends HtmlTagSupport {
    private final HtmlTagSupport optgroupSupport = new HtmlTagSupport(){

        public int doStartTag() throws JspException {
            return 0;
        }

        public int doEndTag() throws JspException {
            return 0;
        }
    };
    private Collection<? extends Object> collection;
    private String value;
    private String label;
    private String sort;
    private String group;
    private List<Entry> entries = new LinkedList<Entry>();

    public void setCollection(Object in) {
        if (in == null) {
            this.collection = null;
        } else if (in instanceof Collection) {
            this.collection = (Collection)in;
        } else if (in instanceof Iterable) {
            this.collection = CollectionUtil.asList((Iterable)in);
        } else if (in.getClass().isArray()) {
            this.collection = CollectionUtil.asList(in);
        } else {
            throw new IllegalArgumentException("A 'collection' was supplied that is not of a supported type: " + in.getClass());
        }
    }

    public Object getCollection() {
        return this.collection;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getSort() {
        return this.sort;
    }

    protected void addEntry(Object item, Object label, Object value) {
        this.entries.add(new Entry(item, label, value, null));
    }

    protected void addEntry(Object item, Object label, Object value, Object group) {
        this.entries.add(new Entry(item, label, value, group));
    }

    public int doStartTag() throws JspException {
        if (this.collection == null) {
            return 0;
        }
        String labelProperty = this.getLabel();
        String valueProperty = this.getValue();
        String groupProperty = this.getGroup();
        try {
            Locale locale = this.getPageContext().getRequest().getLocale();
            for (Object object : this.collection) {
                String localizedGroup;
                Class<?> clazz = object.getClass();
                Object label = labelProperty == null ? object : BeanUtil.getPropertyValue(labelProperty, object);
                Object value = valueProperty == null ? object : BeanUtil.getPropertyValue(valueProperty, object);
                Object group = groupProperty == null ? null : BeanUtil.getPropertyValue(groupProperty, object);
                String packageName = clazz.getPackage() == null ? "" : clazz.getPackage().getName();
                String simpleName = LocalizationUtility.getSimpleName(clazz);
                String localizedLabel = null;
                if (label != null) {
                    localizedLabel = LocalizationUtility.getLocalizedFieldName(simpleName + "." + label, packageName, null, locale);
                }
                if (localizedLabel == null && value != null) {
                    localizedLabel = LocalizationUtility.getLocalizedFieldName(simpleName + "." + value, packageName, null, locale);
                }
                if (localizedLabel != null) {
                    label = localizedLabel;
                }
                if (group != null && (localizedGroup = LocalizationUtility.getLocalizedFieldName(simpleName + "." + group, packageName, null, locale)) != null) {
                    group = localizedGroup;
                }
                this.addEntry(object, label, value, group);
            }
        }
        catch (ExpressionException ee) {
            throw new StripesJspException("A problem occurred generating an options-collection. Most likely either [" + labelProperty + "] or [" + valueProperty + "] is not a " + "valid property of the beans in the collection: " + this.collection, ee);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        LinkedList<Entry> sortedEntries = new LinkedList<Entry>(this.entries);
        if (this.sort != null) {
            String[] props = StringUtil.standardSplit(this.sort);
            for (int i = 0; i < props.length; ++i) {
                if (props[i].equals("label") || props[i].equals("value")) continue;
                props[i] = "bean." + props[i];
            }
            Collections.sort(sortedEntries, new BeanComparator(this.getPageContext().getRequest().getLocale(), props));
        }
        InputOptionTag tag = new InputOptionTag();
        tag.setParent(this);
        tag.setPageContext(this.getPageContext());
        Object lastGroup = null;
        JspWriter out = this.getPageContext().getOut();
        for (Entry entry : sortedEntries) {
            tag.getAttributes().putAll(this.getAttributes());
            tag.setLabel(entry.label == null ? null : entry.label.toString());
            tag.setValue(entry.value);
            try {
                if (entry.group != null && !entry.group.equals(lastGroup)) {
                    if (lastGroup != null) {
                        this.optgroupSupport.writeCloseTag(out, "optgroup");
                    }
                    this.optgroupSupport.set("label", String.valueOf(entry.group));
                    this.optgroupSupport.writeOpenTag(out, "optgroup");
                    lastGroup = entry.group;
                }
                tag.doStartTag();
                tag.doInitBody();
                tag.doAfterBody();
                tag.doEndTag();
            }
            catch (Throwable t) {
                try {
                    tag.doCatch(t);
                }
                catch (Throwable t2) {
                    if (t2 instanceof JspException) {
                        throw (JspException)t2;
                    }
                    if (t2 instanceof RuntimeException) {
                        throw (RuntimeException)t2;
                    }
                    throw new StripesJspException(t2);
                }
            }
            finally {
                tag.doFinally();
            }
        }
        if (lastGroup != null) {
            this.optgroupSupport.writeCloseTag(out, "optgroup");
        }
        this.entries.clear();
        return 6;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public static class Entry {
        public Object bean;
        public Object label;
        public Object value;
        public Object group;

        Entry(Object bean, Object label, Object value, Object group) {
            this.bean = bean;
            this.label = label;
            this.value = value;
            this.group = group;
        }
    }
}

