/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.Wizard;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.InputCheckBoxTag;
import net.sourceforge.stripes.tag.InputHiddenTag;
import net.sourceforge.stripes.tag.InputSelectTag;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.tag.ParameterizableTag;
import net.sourceforge.stripes.tag.WizardFieldsTag;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.util.UrlBuilder;
import net.sourceforge.stripes.validation.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTag
extends HtmlTagSupport
implements BodyTag,
TryCatchFinally,
ParameterizableTag {
    private static final Log log = Log.getInstance(FormTag.class);
    private String focus;
    private boolean focusSet = false;
    private boolean partial = false;
    private String enctype = null;
    private String method = null;
    private String actionWithoutContext;
    private Object beanclass;
    private Class<? extends ActionBean> actionBeanClass;
    private UrlBuilder urlBuilder;
    private Map<String, Class<?>> fieldsPresent = new HashMap();

    public void setAction(String action) {
        this.actionWithoutContext = action;
    }

    public String getAction() {
        return this.actionWithoutContext;
    }

    protected String getActionBeanUrlBinding() {
        ActionResolver resolver = StripesFilter.getConfiguration().getActionResolver();
        if (this.actionBeanClass == null) {
            String path = StringUtil.trimFragment(this.actionWithoutContext);
            String binding = resolver.getUrlBindingFromPath(path);
            if (binding == null) {
                binding = path;
            }
            return binding;
        }
        return resolver.getUrlBinding(this.actionBeanClass);
    }

    protected Class<? extends ActionBean> getActionBeanClass() {
        if (this.actionBeanClass == null) {
            ActionResolver resolver = StripesFilter.getConfiguration().getActionResolver();
            this.actionBeanClass = resolver.getActionBeanType(this.getActionBeanUrlBinding());
        }
        return this.actionBeanClass;
    }

    public void setBeanclass(Object beanclass) throws StripesJspException {
        this.beanclass = beanclass;
        String url = this.getActionBeanUrl(beanclass);
        if (url == null) {
            throw new StripesJspException("Could not determine action from 'beanclass' supplied. The value supplied was '" + beanclass + "'. Please ensure that this bean type " + "exists and is in the classpath. If you are developing a page and the ActionBean " + "does not yet exist, consider using the 'action' attribute instead for now.");
        }
        this.setAction(url);
    }

    public Object getBeanclass() {
        return null;
    }

    public void setFocus(String focus) {
        this.focus = focus;
    }

    public String getFocus() {
        return this.focus;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setAccept(String accept) {
        this.set("accept", accept);
    }

    public String getAccept() {
        return this.get("accept");
    }

    public void setAcceptcharset(String acceptCharset) {
        this.set("accept-charset", acceptCharset);
    }

    public String getAcceptcharset() {
        return this.get("accept-charset");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        return this.get("name");
    }

    public void setTarget(String target) {
        this.set("target", target);
    }

    public String getTarget() {
        return this.get("target");
    }

    public void setOnreset(String onreset) {
        this.set("onreset", onreset);
    }

    public String getOnreset() {
        return this.get("onreset");
    }

    public void setOnsubmit(String onsubmit) {
        this.set("onsubmit", onsubmit);
    }

    public String getOnsubmit() {
        return this.get("onsubmit");
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.actionWithoutContext == null) {
            throw new StripesJspException("The form tag attributes 'beanClass' and 'action' are both null. One of the two must be supplied to determine which action bean should handle the form submission.");
        }
        this.getTagStack().push(this);
        this.urlBuilder = new UrlBuilder(this.pageContext.getRequest().getLocale(), this.getAction(), false).setEvent(null);
        return 2;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            if (this.getMethod() == null) {
                this.setMethod("post");
            }
            this.set("method", this.getMethod());
            this.set("enctype", this.getEnctype());
            this.set("action", this.buildAction());
            JspWriter out = this.getPageContext().getOut();
            if (!this.isPartial()) {
                this.writeOpenTag(out, "form");
            }
            if (this.getBodyContent() != null) {
                this.getBodyContent().writeOut((Writer)this.getPageContext().getOut());
            }
            if (!this.isPartial()) {
                this.writeHiddenTags(out);
                this.writeCloseTag(this.getPageContext().getOut(), "form");
            }
            if (this.focus != null && !this.focusSet) {
                log.error("Form with action [", this.getAction(), "] has 'focus' set to '", this.focus, "', but did not find a field with matching name to set focus on.");
            }
            this.actionBeanClass = null;
            this.fieldsPresent.clear();
            this.focusSet = false;
            this.urlBuilder = null;
        }
        catch (IOException ioe) {
            throw new StripesJspException("IOException in FormTag.doEndTag().", ioe);
        }
        return 6;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        try {
            this.getTagStack().pop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void writeHiddenTags(JspWriter out) throws IOException, JspException {
        out.write("<div style=\"display: none;\">");
        this.writeSourcePageHiddenField(out);
        if (this.isWizard()) {
            this.writeWizardFields();
        }
        this.writeFieldsPresentHiddenField(out);
        out.write("</div>");
    }

    protected void writeSourcePageHiddenField(JspWriter out) throws IOException {
        out.write("<input type=\"hidden\" name=\"");
        out.write("_sourcePage");
        out.write("\" value=\"");
        out.write(this.getSourcePageValue());
        out.write(this.isXmlTags() ? "\" />" : "\">");
    }

    protected String getSourcePageValue() {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        return CryptoUtil.encrypt(request.getServletPath());
    }

    protected void writeFieldsPresentHiddenField(JspWriter out) throws IOException {
        out.write("<input type=\"hidden\" name=\"");
        out.write("__fp");
        out.write("\" value=\"");
        out.write(this.getFieldsPresentValue());
        out.write(this.isXmlTags() ? "\" />" : "\">");
    }

    protected String getFieldsPresentValue() {
        HashSet<String> namesToInclude = new HashSet<String>();
        if (this.isWizard()) {
            namesToInclude.addAll(this.fieldsPresent.keySet());
        } else {
            for (Map.Entry<String, Class<?>> entry : this.fieldsPresent.entrySet()) {
                Class<?> fieldClass = entry.getValue();
                if (!InputSelectTag.class.isAssignableFrom(fieldClass) && !InputCheckBoxTag.class.isAssignableFrom(fieldClass)) continue;
                namesToInclude.add(entry.getKey());
            }
        }
        String hiddenFieldValue = HtmlUtil.combineValues(namesToInclude);
        return CryptoUtil.encrypt(hiddenFieldValue);
    }

    protected ActionBean getActionBean() {
        HttpSession session;
        String binding = this.getActionBeanUrlBinding();
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        ActionBean bean = (ActionBean)request.getAttribute(binding);
        if (bean == null && (session = request.getSession(false)) != null) {
            bean = (ActionBean)session.getAttribute(binding);
        }
        return bean;
    }

    protected boolean isWizard() {
        ActionBean bean = this.getActionBean();
        Class<ActionBean> clazz = null;
        if (bean == null) {
            clazz = this.getActionBeanClass();
            if (clazz == null) {
                log.error("Could not locate an ActionBean that was bound to the URL [", this.actionWithoutContext, "]. Without an ActionBean class Stripes ", "cannot determine whether the ActionBean is a wizard or not. ", "As a result wizard behaviour will be disabled.");
                return false;
            }
        } else {
            clazz = bean.getClass();
        }
        return clazz.getAnnotation(Wizard.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeWizardFields() throws JspException {
        WizardFieldsTag tag = new WizardFieldsTag();
        tag.setPageContext(this.getPageContext());
        tag.setParent(this);
        try {
            tag.doStartTag();
            tag.doEndTag();
        }
        finally {
            tag.doFinally();
            tag.release();
        }
    }

    public void registerField(InputTagSupport tag) {
        this.fieldsPresent.put(tag.getName(), tag.getClass());
        this.setFocusOnFieldIfRequired(tag);
    }

    protected void setFocusOnFieldIfRequired(InputTagSupport tag) {
        if (this.focus != null && !this.focusSet) {
            ValidationErrors errors;
            ActionBean bean = this.getActionBean();
            ValidationErrors validationErrors = errors = bean == null ? null : bean.getContext().getValidationErrors();
            if (errors != null && errors.hasFieldErrors()) {
                List fieldErrors = (List)errors.get(tag.getName());
                if (fieldErrors != null && fieldErrors.size() > 0) {
                    tag.setFocus(true);
                    this.focusSet = true;
                }
            } else if (this.focus.equals(tag.getName())) {
                tag.setFocus(true);
                this.focusSet = true;
            } else if (("".equals(this.focus) || "first".equalsIgnoreCase(this.focus)) && !(tag instanceof InputHiddenTag)) {
                tag.setFocus(true);
                this.focusSet = true;
            }
        }
    }

    public Set<String> getRegisteredFields() {
        return this.fieldsPresent.keySet();
    }

    @Override
    public void addParameter(String name, Object valueOrValues) {
        this.urlBuilder.addParameter(name, valueOrValues);
    }

    protected String buildAction() {
        HttpServletRequest request;
        String contextPath;
        String action = this.urlBuilder.toString();
        if (action.startsWith("/") && (contextPath = (request = (HttpServletRequest)this.getPageContext().getRequest()).getContextPath()).length() > 1 && (this.beanclass != null || !action.startsWith(contextPath + '/'))) {
            action = contextPath + action;
        }
        HttpServletResponse response = (HttpServletResponse)this.getPageContext().getResponse();
        return response.encodeURL(action);
    }
}

