/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DontBind;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.CollectionUtil;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherHelper {
    private static final Log log = Log.getInstance(DispatcherHelper.class);
    private static final Map<Class<?>, WeakReference<Method[]>> customValidations = Collections.synchronizedMap(new WeakHashMap());
    private static ThreadLocal<PageContext> pageContextStash = new ThreadLocal();

    public static void setPageContext(PageContext ctx) {
        if (ctx == null) {
            pageContextStash.remove();
        } else {
            pageContextStash.set(ctx);
        }
    }

    public static PageContext getPageContext() {
        return pageContextStash.get();
    }

    public static Resolution resolveActionBean(ExecutionContext ctx) throws Exception {
        Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.ActionBeanResolution);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.ActionBeanResolution));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                ActionBeanContext context = ctx.getActionBeanContext();
                ActionBean bean = StripesFilter.getConfiguration().getActionResolver().getActionBean(context);
                ctx.setActionBean(bean);
                if (context != bean.getContext()) {
                    ActionBeanContext other = bean.getContext();
                    other.setEventName(context.getEventName());
                    other.setRequest(context.getRequest());
                    other.setResponse(context.getResponse());
                    context = other;
                    ctx.setActionBeanContext(context);
                }
                HttpServletRequest request = context.getRequest();
                request.setAttribute("actionBean", (Object)bean);
                return null;
            }
        });
    }

    public static Resolution resolveHandler(ExecutionContext ctx) throws Exception {
        final Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.HandlerResolution);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.HandlerResolution));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                Method handler;
                ActionBean bean = ctx.getActionBean();
                ActionBeanContext context = ctx.getActionBeanContext();
                ActionResolver resolver = config.getActionResolver();
                String eventName = resolver.getEventName(bean.getClass(), context);
                context.setEventName(eventName);
                if (eventName != null) {
                    handler = resolver.getHandler(bean.getClass(), eventName);
                } else {
                    handler = resolver.getDefaultHandler(bean.getClass());
                    if (handler != null) {
                        context.setEventName(resolver.getHandledEvent(handler));
                    }
                }
                if (handler == null) {
                    throw new StripesServletException("No handler method found for request with  ActionBean [" + bean.getClass().getName() + "] and eventName [ " + eventName + "]");
                }
                log.debug("Resolved event: ", context.getEventName(), "; will invoke: ", bean.getClass().getSimpleName(), ".", handler.getName(), "()");
                ctx.setHandler(handler);
                return null;
            }
        });
    }

    public static Resolution doBindingAndValidation(ExecutionContext ctx, boolean validate) throws Exception {
        Method handler = ctx.getHandler();
        final boolean doBind = handler == null || handler.getAnnotation(DontBind.class) == null;
        final boolean doValidate = doBind && validate && (handler == null || handler.getAnnotation(DontValidate.class) == null);
        final Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.BindingAndValidation);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.BindingAndValidation));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                if (doBind) {
                    ActionBeanPropertyBinder binder = config.getActionBeanPropertyBinder();
                    binder.bind(ctx.getActionBean(), ctx.getActionBeanContext(), doValidate);
                    DispatcherHelper.fillInValidationErrors(ctx);
                }
                return null;
            }
        });
    }

    public static Resolution doCustomValidation(final ExecutionContext ctx, final boolean alwaysInvokeValidate) throws Exception {
        final ValidationErrors errors = ctx.getActionBeanContext().getValidationErrors();
        final ActionBean bean = ctx.getActionBean();
        Method handler = ctx.getHandler();
        boolean doBind = handler != null && handler.getAnnotation(DontBind.class) == null;
        boolean doValidate = doBind && handler.getAnnotation(DontValidate.class) == null;
        Configuration config = StripesFilter.getConfiguration();
        if (doValidate) {
            ctx.setLifecycleStage(LifecycleStage.CustomValidation);
            ctx.setInterceptors(config.getInterceptors(LifecycleStage.CustomValidation));
            return ctx.wrap(new Interceptor(){

                public Resolution intercept(ExecutionContext context) throws Exception {
                    Method[] validations;
                    for (Method validation : validations = DispatcherHelper.findCustomValidationMethods(bean.getClass())) {
                        boolean run;
                        ValidationMethod ann = validation.getAnnotation(ValidationMethod.class);
                        boolean bl = run = ann.when() == ValidationState.ALWAYS || ann.when() == ValidationState.DEFAULT && alwaysInvokeValidate || errors.isEmpty();
                        if (!run || !DispatcherHelper.applies(ann, ctx.getActionBeanContext().getEventName())) continue;
                        Class<?>[] args = validation.getParameterTypes();
                        if (args.length == 1 && args[0].equals(ValidationErrors.class)) {
                            validation.invoke((Object)bean, errors);
                            continue;
                        }
                        validation.invoke((Object)bean, new Object[0]);
                    }
                    DispatcherHelper.fillInValidationErrors(ctx);
                    return null;
                }
            });
        }
        return null;
    }

    public static boolean applies(ValidationMethod info, String event) {
        return CollectionUtil.applies(info.on(), event);
    }

    public static Method[] findCustomValidationMethods(Class<? extends ActionBean> type) throws Exception {
        Method[] validations = null;
        WeakReference<Method[]> ref = customValidations.get(type);
        if (ref != null) {
            validations = (Method[])ref.get();
        }
        if (validations == null) {
            TreeSet<Method> validationMethods = new TreeSet<Method>(new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    if (o1.getName().equals(o2.getName()) && Arrays.equals(o1.getParameterTypes(), o2.getParameterTypes())) {
                        return 0;
                    }
                    ValidationMethod ann1 = o1.getAnnotation(ValidationMethod.class);
                    ValidationMethod ann2 = o2.getAnnotation(ValidationMethod.class);
                    int returnValue = new Integer(ann1.priority()).compareTo(ann2.priority());
                    if (returnValue == 0) {
                        returnValue = o1.getName().compareTo(o2.getName());
                    }
                    return returnValue;
                }
            });
            for (Class<? extends ActionBean> temp = type; temp != null; temp = temp.getSuperclass()) {
                for (Method method : temp.getDeclaredMethods()) {
                    Class<?>[] args = method.getParameterTypes();
                    if (method.getAnnotation(ValidationMethod.class) == null || args.length != 0 && (args.length != 1 || !args[0].equals(ValidationErrors.class))) continue;
                    validationMethods.add(method);
                }
            }
            validations = validationMethods.toArray(new Method[validationMethods.size()]);
            customValidations.put(type, new WeakReference<Method[]>(validations));
        }
        return validations;
    }

    public static Resolution handleValidationErrors(ExecutionContext ctx) throws Exception {
        DontValidate annotation = ctx.getHandler().getAnnotation(DontValidate.class);
        boolean doValidate = annotation == null || !annotation.ignoreBindingErrors();
        DispatcherHelper.fillInValidationErrors(ctx);
        Resolution resolution = null;
        if (doValidate) {
            ActionBean bean = ctx.getActionBean();
            ActionBeanContext context = ctx.getActionBeanContext();
            ValidationErrors errors = context.getValidationErrors();
            if (errors.size() > 0 && bean instanceof ValidationErrorHandler) {
                resolution = ((ValidationErrorHandler)((Object)bean)).handleValidationErrors(errors);
                DispatcherHelper.fillInValidationErrors(ctx);
            }
            if (errors.size() > 0 && resolution == null) {
                DispatcherHelper.logValidationErrors(context);
                resolution = context.getSourcePageResolution();
            }
        }
        return resolution;
    }

    public static void fillInValidationErrors(ExecutionContext ctx) {
        ActionBeanContext context = ctx.getActionBeanContext();
        ValidationErrors errors = context.getValidationErrors();
        if (errors.size() > 0) {
            String formAction = StripesFilter.getConfiguration().getActionResolver().getUrlBinding(ctx.getActionBean().getClass());
            HttpServletRequest request = ctx.getActionBeanContext().getRequest();
            for (Map.Entry entry : errors.entrySet()) {
                String parameterName = (String)entry.getKey();
                List listOfErrors = (List)entry.getValue();
                for (ValidationError error : listOfErrors) {
                    if (error.getActionPath() != null) continue;
                    error.setActionPath(formAction);
                    error.setBeanclass(ctx.getActionBean().getClass());
                    if (error.getFieldValue() == null) {
                        error.setFieldValue(HtmlUtil.encode(request.getParameter(parameterName)));
                        continue;
                    }
                    error.setFieldValue(HtmlUtil.encode(error.getFieldValue()));
                }
            }
        }
    }

    public static Resolution invokeEventHandler(ExecutionContext ctx) throws Exception {
        Configuration config = StripesFilter.getConfiguration();
        final Method handler = ctx.getHandler();
        final ActionBean bean = ctx.getActionBean();
        ctx.setLifecycleStage(LifecycleStage.EventHandling);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.EventHandling));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                Object returnValue = handler.invoke((Object)bean, new Object[0]);
                DispatcherHelper.fillInValidationErrors(ctx);
                if (returnValue != null && returnValue instanceof Resolution) {
                    ctx.setResolutionFromHandler(true);
                    return (Resolution)returnValue;
                }
                if (returnValue != null) {
                    log.warn("Expected handler method ", handler.getName(), " on class ", bean.getClass().getSimpleName(), " to return a Resolution. Instead it ", "returned: ", returnValue);
                }
                return null;
            }
        });
    }

    public static void executeResolution(ExecutionContext ctx, Resolution resolution) throws Exception {
        Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.ResolutionExecution);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.ResolutionExecution));
        ctx.setResolution(resolution);
        Resolution retval = ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext context) throws Exception {
                ActionBeanContext abc = context.getActionBeanContext();
                Resolution resolution = context.getResolution();
                if (resolution != null) {
                    resolution.execute(abc.getRequest(), abc.getResponse());
                }
                return null;
            }
        });
        if (retval != null) {
            log.warn("An interceptor wrapping LifecycleStage.ResolutionExecution returned ", "a Resolution. This almost certainly did NOT have the desired effect. ", "At this LifecycleStage interceptors are running *around* the actual ", "execution of the Resolution, and so returning an alternate Resolution ", "has the effect of stopping the original Resolution from being executed ", "while NOT causing the alternate Resolution to get executed. Interceptor ", "code running before the Resolution is executed (i.e. before calling ", "ExecutionContext.proceed()) can alter the Resolution by calling ", "ExecutionContext.setResolution() instead. Code running after the Resolution ", "has been executed can no longer alter what Resolution is executed for ", "what are hopefully obvious reasons!");
        }
    }

    public static final void logValidationErrors(ActionBeanContext context) {
        StringBuilder buf = new StringBuilder("The following validation errors need to be fixed:");
        for (List list : context.getValidationErrors().values()) {
            for (ValidationError error : list) {
                String message;
                String fieldName = error.getFieldName();
                if ("__stripes_global_error".equals(fieldName)) {
                    fieldName = "GLOBAL";
                }
                try {
                    message = error.getMessage(Locale.getDefault());
                }
                catch (MissingResourceException e) {
                    message = "(missing resource)";
                }
                buf.append("\n    -> [").append(fieldName).append("] ").append(message);
            }
        }
        log.debug(buf);
    }
}

