/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingResolution
implements Resolution {
    private static final String RFC_822_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final String MULTIPART_BOUNDARY = "BOUNDARY_F7C98B76AEF711DF86D1B4FCDFD72085";
    private static final Log log = Log.getInstance(StreamingResolution.class);
    private InputStream inputStream;
    private Reader reader;
    private String filename;
    private String contentType;
    private String characterEncoding;
    private long lastModified = -1L;
    private long length = -1L;
    private boolean attachment;
    private boolean rangeSupport = false;
    private List<Range<Long>> byteRanges;

    public StreamingResolution(String contentType) {
        this.contentType = contentType;
    }

    public StreamingResolution(String contentType, InputStream inputStream) {
        this.contentType = contentType;
        this.inputStream = inputStream;
    }

    public StreamingResolution(String contentType, Reader reader) {
        this.contentType = contentType;
        this.reader = reader;
    }

    public StreamingResolution(String contentType, String output) {
        this(contentType, new StringReader(output));
    }

    public StreamingResolution setFilename(String filename) {
        this.filename = filename;
        this.setAttachment(filename != null);
        return this;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public StreamingResolution setLastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public StreamingResolution setLength(long length) {
        this.length = length;
        return this;
    }

    public StreamingResolution setAttachment(boolean attachment) {
        this.attachment = attachment;
        return this;
    }

    public StreamingResolution setRangeSupport(boolean rangeSupport) {
        this.rangeSupport = rangeSupport;
        return this;
    }

    @Override
    public final void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.rangeSupport && this.length >= 0L && this.inputStream != null) {
            this.byteRanges = this.parseRangeHeader(request.getHeader("Range"));
        }
        this.applyHeaders(response);
        this.stream(response);
    }

    protected void applyHeaders(HttpServletResponse response) {
        if (this.byteRanges != null) {
            response.setStatus(206);
        }
        if (this.byteRanges == null || this.byteRanges.size() == 1) {
            response.setContentType(this.contentType);
        } else {
            response.setContentType("multipart/byteranges; boundary=BOUNDARY_F7C98B76AEF711DF86D1B4FCDFD72085");
        }
        if (this.characterEncoding != null) {
            response.setCharacterEncoding(this.characterEncoding);
        }
        if (this.length >= 0L) {
            if (this.byteRanges == null) {
                response.addHeader("Content-Length", Long.toString(this.length));
            } else if (this.byteRanges.size() == 1) {
                Range<Long> byteRange = this.byteRanges.get(0);
                response.setHeader("Content-Length", Long.toString(byteRange.getEnd() - byteRange.getStart() + 1L));
                response.setHeader("Content-Range", "bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + this.length);
            }
        }
        if (this.lastModified >= 0L) {
            response.setDateHeader("Last-Modified", this.lastModified);
        }
        if (this.attachment || this.filename != null) {
            String escaped = this.filename.replace("\"", "\\\"");
            StringBuilder header = new StringBuilder(this.attachment ? "attachment" : "inline").append(";filename=\"").append(escaped).append("\"");
            if (this.lastModified >= 0L) {
                SimpleDateFormat format = new SimpleDateFormat(RFC_822_DATE_FORMAT);
                String value = format.format(new Date(this.lastModified));
                header.append(";modification-date=\"").append(value).append("\"");
            }
            if (this.length >= 0L) {
                header.append(";size=").append(this.length);
            }
            response.setHeader("Content-Disposition", header.toString());
        }
    }

    protected List<Range<Long>> parseRangeHeader(String value) {
        long lastEnd = -1L;
        if (value == null) {
            return null;
        }
        ArrayList<Range<Long>> res = new ArrayList<Range<Long>>();
        String[] byteRangesSpecifier = value.split("=");
        if (byteRangesSpecifier.length != 2) {
            return null;
        }
        String bytesUnit = byteRangesSpecifier[0];
        String[] byteRangeSet = byteRangesSpecifier[1].split(",");
        if (!bytesUnit.equals("bytes")) {
            return null;
        }
        for (String byteRangeSpec : byteRangeSet) {
            Long firstBytePos = null;
            Long lastBytePos = null;
            String[] bytePos = byteRangeSpec.split("-", -1);
            try {
                if (bytePos[0].trim().length() > 0) {
                    firstBytePos = Long.valueOf(bytePos[0].trim());
                }
                if (bytePos[1].trim().length() > 0) {
                    lastBytePos = Long.valueOf(bytePos[1].trim());
                }
            }
            catch (NumberFormatException e) {
                log.warn("Unable to parse Range header", e);
            }
            if (firstBytePos == null && lastBytePos == null) {
                return null;
            }
            if (firstBytePos == null) {
                firstBytePos = this.length - lastBytePos;
                lastBytePos = this.length - 1L;
            } else if (lastBytePos == null) {
                lastBytePos = this.length - 1L;
            }
            if (firstBytePos > lastBytePos) {
                return null;
            }
            if (firstBytePos < 0L) {
                return null;
            }
            if (lastBytePos >= this.length) {
                return null;
            }
            res.add(new Range<Long>(firstBytePos, lastBytePos));
        }
        Collections.sort(res);
        ListIterator i = res.listIterator();
        while (i.hasNext()) {
            Range range = (Range)i.next();
            if (lastEnd >= (Long)range.getStart()) {
                range.setStart(lastEnd + 1L);
                if ((Long)range.getStart() >= this.length || (Long)range.getStart() > (Long)range.getEnd()) {
                    i.remove();
                    continue;
                }
                lastEnd = (Long)range.getEnd();
                continue;
            }
            lastEnd = (Long)range.getEnd();
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stream(HttpServletResponse response) throws Exception {
        block21: {
            block22: {
                block19: {
                    int length;
                    block20: {
                        length = 0;
                        if (this.reader == null) break block20;
                        char[] buffer = new char[512];
                        try {
                            PrintWriter out = response.getWriter();
                            while ((length = this.reader.read(buffer)) != -1) {
                                out.write(buffer, 0, length);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                this.reader.close();
                            }
                            catch (Exception e) {
                                log.warn("Error closing reader", e);
                            }
                            throw throwable;
                        }
                        try {
                            this.reader.close();
                        }
                        catch (Exception e) {
                            log.warn("Error closing reader", e);
                        }
                        break block21;
                    }
                    if (this.inputStream == null) break block22;
                    byte[] buffer = new byte[512];
                    long count = 0L;
                    try {
                        ServletOutputStream out = response.getOutputStream();
                        if (this.byteRanges == null) {
                            while ((length = this.inputStream.read(buffer)) != -1) {
                                out.write(buffer, 0, length);
                            }
                            break block19;
                        }
                        for (Range<Long> byteRange : this.byteRanges) {
                            if (this.byteRanges.size() > 1) {
                                out.print("--BOUNDARY_F7C98B76AEF711DF86D1B4FCDFD72085\r\n");
                                out.print("Content-Type: " + this.contentType + "\r\n");
                                out.print("Content-Range: bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + this.length + "\r\n");
                                out.print("\r\n");
                            }
                            if (count < byteRange.getStart()) {
                                long skip = byteRange.getStart() - count;
                                this.inputStream.skip(skip);
                                count += skip;
                            }
                            while ((length = this.inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, byteRange.getEnd() + 1L - count))) != -1) {
                                out.write(buffer, 0, length);
                                if (byteRange.getEnd() + 1L != (count += (long)length)) continue;
                            }
                            if (this.byteRanges.size() <= 1) continue;
                            out.print("\r\n");
                        }
                        if (this.byteRanges.size() <= 1) break block19;
                        out.print("--BOUNDARY_F7C98B76AEF711DF86D1B4FCDFD72085--\r\n");
                    }
                    catch (Throwable throwable) {
                        try {
                            this.inputStream.close();
                        }
                        catch (Exception e) {
                            log.warn("Error closing input stream", e);
                        }
                        throw throwable;
                    }
                }
                try {
                    this.inputStream.close();
                }
                catch (Exception e) {
                    log.warn("Error closing input stream", e);
                }
                break block21;
            }
            throw new StripesRuntimeException("A StreamingResolution was constructed without supplying a Reader or InputStream, but stream() was not overridden. Please either supply a source of streaming data, or override the stream() method.");
        }
    }
}

