/*
 * Decompiled with CFR 0.152.
 */
package mooBench.benchmark;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import mooBench.benchmark.BenchmarkingThread;
import mooBench.benchmark.BenchmarkingThreadNano;
import mooBench.monitoredApplication.MonitoredClass;
import mooBench.monitoredApplication.MonitoredClassThreaded;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class Benchmark {
    private static final String ENCODING = "UTF-8";
    private static PrintStream ps = null;
    private static String outputFn = null;
    private static int totalThreads = 0;
    private static int totalCalls = 0;
    private static long methodTime = 0L;
    private static int recursionDepth = 0;
    private static boolean quickstart = false;
    private static MonitoredClass mc = null;

    private Benchmark() {
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        Benchmark.parseAndInitializeArguments(args);
        System.out.println(" # Experiment run configuration:");
        System.out.println(" # 1. Output filename " + outputFn);
        System.out.println(" # 2. Recursion Depth " + recursionDepth);
        System.out.println(" # 3. Threads " + totalThreads);
        System.out.println(" # 4. Total-Calls " + totalCalls);
        System.out.println(" # 5. Method-Time " + methodTime);
        CountDownLatch doneSignal = new CountDownLatch(totalThreads);
        BenchmarkingThread[] benchmarkingThreads = new BenchmarkingThread[totalThreads];
        Thread[] threads = new Thread[totalThreads];
        for (int i2 = 0; i2 < totalThreads; ++i2) {
            benchmarkingThreads[i2] = new BenchmarkingThreadNano(mc, totalCalls, methodTime, recursionDepth, doneSignal);
            threads[i2] = new Thread((Runnable)benchmarkingThreads[i2], String.valueOf(i2 + 1));
        }
        if (!quickstart) {
            for (int l = 0; l < 4; ++l) {
                long freeMemChunks = Runtime.getRuntime().freeMemory() >> 27;
                int memSize = 0x1000000;
                int j = 0;
                while ((long)j < freeMemChunks) {
                    long[] grabMemory = new long[0x1000000];
                    for (i = 0; i < 0x1000000; ++i) {
                        grabMemory[i] = System.nanoTime();
                    }
                    ++j;
                }
                Thread.sleep(5000L);
            }
        }
        long startTime = System.currentTimeMillis();
        System.out.println(" # 6. Starting benchmark ...");
        for (int i3 = 0; i3 < totalThreads; ++i3) {
            threads[i3].start();
        }
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        System.out.println(" #    done (" + TimeUnit.MILLISECONDS.toSeconds(totalTime) + " s)");
        System.out.print(" # 7. Writing results ... ");
        for (int h = 0; h < totalThreads; ++h) {
            long[] timings = benchmarkingThreads[h].getTimings();
            for (i = 0; i < totalCalls; ++i) {
                ps.println(threads[h].getName() + ";" + timings[i]);
            }
        }
        ps.close();
        System.out.println("done");
        System.out.println(" # ");
        System.exit(0);
    }

    public static void parseAndInitializeArguments(String[] args) {
        Options cmdlOpts = new Options();
        OptionBuilder.withLongOpt("totalcalls");
        OptionBuilder.withArgName("calls");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("Number of total method calls performed.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("t"));
        OptionBuilder.withLongOpt("methodtime");
        OptionBuilder.withArgName("time");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("Time a method call takes.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("m"));
        OptionBuilder.withLongOpt("totalthreads");
        OptionBuilder.withArgName("threads");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("Number of threads started.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("recursiondepth");
        OptionBuilder.withArgName("depth");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("Depth of recursion performed.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("output-filename");
        OptionBuilder.withArgName("filename");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("Filename of results file. Output is appended if file exists.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("o"));
        OptionBuilder.withLongOpt("quickstart");
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Skips initial garbage collection.");
        cmdlOpts.addOption(OptionBuilder.create("q"));
        OptionBuilder.withLongOpt("runnable");
        OptionBuilder.withArgName("classname");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Class implementing the Runnable interface. run() method is executed before the benchmark starts.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("r"));
        OptionBuilder.withLongOpt("application");
        OptionBuilder.withArgName("classname");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Class implementing the MonitoredClass interface.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("a"));
        OptionBuilder.withLongOpt("benchmarkthread");
        OptionBuilder.withArgName("classname");
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Class implementing the BenchmarkingThread interface.");
        OptionBuilder.withValueSeparator('=');
        cmdlOpts.addOption(OptionBuilder.create("b"));
        try {
            CommandLine cmdl = null;
            BasicParser cmdlParser = new BasicParser();
            cmdl = cmdlParser.parse(cmdlOpts, args);
            outputFn = cmdl.getOptionValue("output-filename");
            totalCalls = Integer.parseInt(cmdl.getOptionValue("totalcalls"));
            methodTime = Integer.parseInt(cmdl.getOptionValue("methodtime"));
            totalThreads = Integer.parseInt(cmdl.getOptionValue("totalthreads"));
            recursionDepth = Integer.parseInt(cmdl.getOptionValue("recursiondepth"));
            quickstart = cmdl.hasOption("quickstart");
            ps = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFn, true), 65536), false, ENCODING);
            String application = cmdl.getOptionValue("application");
            mc = null != application ? (MonitoredClass)Class.forName(application).newInstance() : new MonitoredClassThreaded();
            String clazzname = cmdl.getOptionValue("runnable");
            if (null != clazzname) {
                ((Runnable)Class.forName(clazzname).newInstance()).run();
            }
        }
        catch (Exception ex) {
            new HelpFormatter().printHelp(Benchmark.class.getName(), cmdlOpts);
            System.out.println(ex.toString());
            System.exit(-1);
        }
    }
}

