/*
 * Decompiled with CFR 0.152.
 */
package kieker.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.util.registry.ILookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TCPStringReader
extends Thread {
    private static final int MESSAGE_BUFFER_SIZE = 65535;
    private static final Log LOG = LogFactory.getLog(TCPStringReader.class);
    private final int port;
    private final ILookup<String> stringRegistry;

    public TCPStringReader(int port, ILookup<String> stringRegistry) {
        this.port = port;
        this.stringRegistry = stringRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Listening on port " + this.port);
            }
            SocketChannel socketChannel = serversocket.accept();
            ByteBuffer buffer = ByteBuffer.allocateDirect(65535);
            while (socketChannel.read(buffer) != -1) {
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        buffer.mark();
                        RegistryRecord.registerRecordInRegistry((ByteBuffer)buffer, this.stringRegistry);
                    }
                    buffer.clear();
                }
                catch (BufferUnderflowException ex) {
                    buffer.reset();
                    buffer.compact();
                }
            }
            socketChannel.close();
        }
        catch (IOException ex) {
            LOG.error("Error while reading", (Throwable)ex);
        }
        finally {
            block18: {
                if (null != serversocket) {
                    try {
                        serversocket.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block18;
                        LOG.debug("Failed to close TCP connection!", (Throwable)e);
                    }
                }
            }
        }
    }
}

