/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ByteSequence;
import org.apache.bcel.util.Class2HTML;
import org.apache.bcel.util.ConstantHTML;

final class CodeHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String dir, String class_name, Method[] methods, ConstantPool constant_pool, ConstantHTML constant_html) throws IOException {
        this.class_name = class_name;
        this.constant_pool = constant_pool;
        this.constant_html = constant_html;
        this.file = new PrintWriter(new FileOutputStream(dir + class_name + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i = 0; i < methods.length; ++i) {
            this.writeMethod(methods[i], i);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence bytes, int method_number) throws IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer(256);
        buf.append("<TT>").append(OPCODE_NAMES[opcode]).append("</TT></TD><TD>");
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (i = 0; i < no_pad_bytes; ++i) {
                bytes.readByte();
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int i2;
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                int[] jump_table = new int[high - low + 1];
                for (i2 = 0; i2 < jump_table.length; ++i2) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("<TH>").append(low + i2).append("</TH>");
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                for (i2 = 0; i2 < jump_table.length; ++i2) {
                    buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(jump_table[i2]).append("\">").append(jump_table[i2]).append("</A></TD>");
                }
                buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(default_offset).append("\">").append(default_offset).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] jump_table = new int[npairs];
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                for (i = 0; i < npairs; ++i) {
                    int match = bytes.readInt();
                    jump_table[i] = offset + bytes.readInt();
                    buf.append("<TH>").append(match).append("</TH>");
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                for (i = 0; i < npairs; ++i) {
                    buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(jump_table[i]).append("\">").append(jump_table[i]).append("</A></TD>");
                }
                buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(default_offset).append("\">").append(default_offset).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int index = bytes.getIndex() + bytes.readShort() - 1;
                buf.append("<A HREF=\"#code").append(method_number).append("@").append(index).append("\">").append(index).append("</A>");
                break;
            }
            case 200: 
            case 201: {
                int windex = bytes.getIndex() + bytes.readInt() - 1;
                buf.append("<A HREF=\"#code").append(method_number).append("@").append(windex).append("\">").append(windex).append("</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("(wide)");
                break;
            }
            case 188: {
                buf.append("<FONT COLOR=\"#00FF00\">").append(TYPE_NAMES[bytes.readByte()]).append("</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readShort();
                ConstantFieldref c1 = (ConstantFieldref)this.constant_pool.getConstant(index, (byte)9);
                int class_index = c1.getClassIndex();
                String name = this.constant_pool.getConstantString(class_index, (byte)7);
                name = Utility.compactClassName(name, false);
                index = c1.getNameAndTypeIndex();
                String field_name = this.constant_pool.constantToString(index, (byte)12);
                if (name.equals(this.class_name)) {
                    buf.append("<A HREF=\"").append(this.class_name).append("_methods.html#field").append(field_name).append("\" TARGET=Methods>").append(field_name).append("</A>\n");
                    break;
                }
                buf.append(this.constant_html.referenceConstant(class_index)).append(".").append(field_name);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short index = bytes.readShort();
                buf.append(this.constant_html.referenceConstant(index));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int index;
                String str;
                int class_index;
                ConstantCP c;
                short m_index = bytes.readShort();
                if (opcode == 185) {
                    bytes.readUnsignedByte();
                    bytes.readUnsignedByte();
                    c = (ConstantInterfaceMethodref)this.constant_pool.getConstant(m_index, (byte)11);
                    class_index = c.getClassIndex();
                    str = this.constant_pool.constantToString(c);
                    index = c.getNameAndTypeIndex();
                } else {
                    c = (ConstantMethodref)this.constant_pool.getConstant(m_index, (byte)10);
                    class_index = c.getClassIndex();
                    str = this.constant_pool.constantToString(c);
                    index = c.getNameAndTypeIndex();
                }
                String name = Class2HTML.referenceClass(class_index);
                str = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(index, (byte)12)));
                ConstantNameAndType c2 = (ConstantNameAndType)this.constant_pool.getConstant(index, (byte)12);
                String signature = this.constant_pool.constantToString(c2.getSignatureIndex(), (byte)1);
                String[] args = Utility.methodSignatureArgumentTypes(signature, false);
                String type = Utility.methodSignatureReturnType(signature, false);
                buf.append(name).append(".<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(m_index).append("\" TARGET=ConstantPool>").append(str).append("</A>").append("(");
                for (int i3 = 0; i3 < args.length; ++i3) {
                    buf.append(Class2HTML.referenceType(args[i3]));
                    if (i3 >= args.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("):").append(Class2HTML.referenceType(type));
                break;
            }
            case 19: 
            case 20: {
                short index = bytes.readShort();
                buf.append("<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(index).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constant_pool.constantToString(index, this.constant_pool.getConstant(index).getTag()))).append("</a>");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(index).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constant_pool.constantToString(index, this.constant_pool.getConstant(index).getTag()))).append("</a>");
                break;
            }
            case 189: {
                short index = bytes.readShort();
                buf.append(this.constant_html.referenceConstant(index));
                break;
            }
            case 197: {
                short index = bytes.readShort();
                byte dimensions = bytes.readByte();
                buf.append(this.constant_html.referenceConstant(index)).append(":").append(dimensions).append("-dimensional");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("%").append(vindex).append(" ").append(constant);
                break;
            }
            default: {
                if (NO_OF_OPERANDS[opcode] <= 0) break;
                for (int i4 = 0; i4 < TYPE_OF_OPERANDS[opcode].length; ++i4) {
                    switch (TYPE_OF_OPERANDS[opcode][i4]) {
                        case 8: {
                            buf.append(bytes.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    buf.append("&nbsp;");
                }
            }
        }
        buf.append("</TD>");
        return buf.toString();
    }

    private final void findGotos(ByteSequence bytes, Method method, Code code) throws IOException {
        int j;
        this.goto_set = new BitSet(bytes.available());
        if (code != null) {
            CodeException[] ce = code.getExceptionTable();
            int len = ce.length;
            for (int i = 0; i < len; ++i) {
                this.goto_set.set(ce[i].getStartPC());
                this.goto_set.set(ce[i].getEndPC());
                this.goto_set.set(ce[i].getHandlerPC());
            }
            Attribute[] attributes = code.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].getTag() != 5) continue;
                LocalVariable[] vars = ((LocalVariableTable)attributes[i]).getLocalVariableTable();
                for (j = 0; j < vars.length; ++j) {
                    int start = vars[j].getStartPC();
                    int end = start + vars[j].getLength();
                    this.goto_set.set(start);
                    this.goto_set.set(end);
                }
                break;
            }
        }
        int i = 0;
        while (bytes.available() > 0) {
            int opcode = bytes.readUnsignedByte();
            switch (opcode) {
                case 170: 
                case 171: {
                    int index;
                    int remainder = bytes.getIndex() % 4;
                    int no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
                    for (j = 0; j < no_pad_bytes; ++j) {
                        bytes.readByte();
                    }
                    int default_offset = bytes.readInt();
                    if (opcode == 170) {
                        int low = bytes.readInt();
                        int high = bytes.readInt();
                        int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        for (int j2 = 0; j2 < high - low + 1; ++j2) {
                            index = offset + bytes.readInt();
                            this.goto_set.set(index);
                        }
                    } else {
                        int npairs = bytes.readInt();
                        int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        for (int j3 = 0; j3 < npairs; ++j3) {
                            bytes.readInt();
                            index = offset + bytes.readInt();
                            this.goto_set.set(index);
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int index = bytes.getIndex() + bytes.readShort() - 1;
                    this.goto_set.set(index);
                    break;
                }
                case 200: 
                case 201: {
                    int index = bytes.getIndex() + bytes.readInt() - 1;
                    this.goto_set.set(index);
                    break;
                }
                default: {
                    bytes.unreadByte();
                    this.codeToHTML(bytes, 0);
                }
            }
            ++i;
        }
    }

    private void writeMethod(Method method, int method_number) throws IOException {
        String signature = method.getSignature();
        String[] args = Utility.methodSignatureArgumentTypes(signature, false);
        String type = Utility.methodSignatureReturnType(signature, false);
        String name = method.getName();
        String html_name = Class2HTML.toHTML(name);
        String access = Utility.accessToString(method.getAccessFlags());
        access = Utility.replace(access, " ", "&nbsp;");
        Attribute[] attributes = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + access + "</FONT>&nbsp;" + "<A NAME=method" + method_number + ">" + Class2HTML.referenceType(type) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + method_number + "\" TARGET=Methods>" + html_name + "</A>(");
        for (int i = 0; i < args.length; ++i) {
            this.file.print(Class2HTML.referenceType(args[i]));
            if (i >= args.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code c = null;
        byte[] code = null;
        if (attributes.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i = 0; i < attributes.length; ++i) {
                byte tag = attributes[i].getTag();
                if (tag != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + method_number + "@" + i + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[tag] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributes[i] + "</LI>");
                }
                if (tag != 2) continue;
                c = (Code)attributes[i];
                Attribute[] attributes2 = c.getAttributes();
                code = c.getCode();
                this.file.print("<UL>");
                for (int j = 0; j < attributes2.length; ++j) {
                    tag = attributes2[j].getTag();
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + method_number + "@" + i + "@" + j + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[tag] + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (code != null) {
            ByteSequence stream = new ByteSequence(code);
            stream.mark(stream.available());
            this.findGotos(stream, method, c);
            stream.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            int i = 0;
            while (stream.available() > 0) {
                int offset = stream.getIndex();
                String str = this.codeToHTML(stream, method_number);
                String anchor = "";
                if (this.goto_set.get(offset)) {
                    anchor = "<A NAME=code" + method_number + "@" + offset + "></A>";
                }
                String anchor2 = stream.getIndex() == code.length ? "<A NAME=code" + method_number + "@" + code.length + ">" + offset + "</A>" : "" + offset;
                this.file.println("<TR VALIGN=TOP><TD>" + anchor2 + "</TD><TD>" + anchor + str + "</TR>");
                ++i;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

