/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.util.StringCache;

public class ObjectType
extends ReferenceType {
    private static final int MAX_CACHE_ENTRIES = 500;
    private final String class_name;

    public static synchronized ObjectType getInstance(String class_name) {
        if (StringCache.BCEL_DONT_CACHE) {
            return new ObjectType(class_name);
        }
        ObjectType result = (ObjectType)Cache.cache.get(class_name);
        if (result != null) {
            return result;
        }
        result = new ObjectType(class_name);
        Cache.cache.put(class_name, result);
        return result;
    }

    public ObjectType(String class_name) {
        super((byte)14, StringCache.cache("L" + class_name.replace('.', '/') + ";"));
        this.class_name = StringCache.cache(class_name.replace('/', '.'));
    }

    public String getClassName() {
        return this.class_name;
    }

    public int hashCode() {
        return this.class_name.hashCode();
    }

    public boolean equals(Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    public boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return jc.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return !jc.isClass();
    }

    public boolean subclassOf(ObjectType superclass) throws ClassNotFoundException {
        if (this.referencesInterface() || superclass.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public boolean accessibleTo(ObjectType accessor) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }

    static class Cache {
        private static final LinkedHashMap cache = new LinkedHashMap(666, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 500;
            }
        };

        Cache() {
        }
    }
}

