/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.SwingUtilities;

public class mxSelectionCellsHandler
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -882368002120921842L;
    public static int DEFAULT_MAX_HANDLERS = 100;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected Rectangle bounds = null;
    protected int maxHandlers = DEFAULT_MAX_HANDLERS;
    protected transient LinkedHashMap<Object, mxCellHandler> handlers = new LinkedHashMap();
    protected transient mxEventSource.mxIEventListener refreshHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (mxSelectionCellsHandler.this.isEnabled()) {
                mxSelectionCellsHandler.this.refresh();
            }
        }
    };
    protected transient PropertyChangeListener labelMoveHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("vertexLabelsMovable") || propertyChangeEvent.getPropertyName().equals("edgeLabelsMovable")) {
                mxSelectionCellsHandler.this.refresh();
            }
        }
    };

    public mxSelectionCellsHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        this.addGraphListeners(mxGraphComponent2.getGraph());
        mxGraphComponent2.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("graph")) {
                    mxSelectionCellsHandler.this.removeGraphListeners((mxGraph)propertyChangeEvent.getOldValue());
                    mxSelectionCellsHandler.this.addGraphListeners((mxGraph)propertyChangeEvent.getNewValue());
                }
            }
        });
        mxGraphComponent2.addListener("paint", new mxEventSource.mxIEventListener(){

            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxSelectionCellsHandler.this.paintHandles(graphics);
            }
        });
    }

    protected void addGraphListeners(mxGraph mxGraph2) {
        if (mxGraph2 != null) {
            mxGraph2.getSelectionModel().addListener("change", this.refreshHandler);
            mxGraph2.getModel().addListener("change", this.refreshHandler);
            mxGraph2.getView().addListener("scale", this.refreshHandler);
            mxGraph2.getView().addListener("translate", this.refreshHandler);
            mxGraph2.getView().addListener("scaleAndTranslate", this.refreshHandler);
            mxGraph2.getView().addListener("down", this.refreshHandler);
            mxGraph2.getView().addListener("up", this.refreshHandler);
            mxGraph2.addPropertyChangeListener(this.labelMoveHandler);
        }
    }

    protected void removeGraphListeners(mxGraph mxGraph2) {
        if (mxGraph2 != null) {
            mxGraph2.getSelectionModel().removeListener(this.refreshHandler, "change");
            mxGraph2.getModel().removeListener(this.refreshHandler, "change");
            mxGraph2.getView().removeListener(this.refreshHandler, "scale");
            mxGraph2.getView().removeListener(this.refreshHandler, "translate");
            mxGraph2.getView().removeListener(this.refreshHandler, "scaleAndTranslate");
            mxGraph2.getView().removeListener(this.refreshHandler, "down");
            mxGraph2.getView().removeListener(this.refreshHandler, "up");
            mxGraph2.removePropertyChangeListener(this.labelMoveHandler);
        }
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getMaxHandlers() {
        return this.maxHandlers;
    }

    public void setMaxHandlers(int n) {
        this.maxHandlers = n;
    }

    public mxCellHandler getHandler(Object object) {
        return this.handlers.get(object);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && !this.graphComponent.isForceMarqueeEvent(mouseEvent) && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mousePressed(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseMoved(mouseEvent);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseDragged(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseReleased(mouseEvent);
            }
        }
        this.reset();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.graphComponent.getGraphControl());
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        String string = null;
        while (iterator.hasNext() && string == null) {
            string = iterator.next().getToolTipText(mouseEvent2);
        }
        return string;
    }

    public void reset() {
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    public void refresh() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        LinkedHashMap<Object, mxCellHandler> linkedHashMap = this.handlers;
        this.handlers = new LinkedHashMap();
        Object[] objectArray = mxGraph2.getSelectionCells();
        boolean bl = objectArray.length <= this.getMaxHandlers();
        Rectangle rectangle = null;
        for (int i = 0; i < objectArray.length; ++i) {
            mxCellState object = mxGraph2.getView().getState(objectArray[i]);
            if (object == null || object.getCell() == mxGraph2.getView().getCurrentRoot()) continue;
            mxCellHandler mxCellHandler2 = (mxCellHandler)linkedHashMap.remove(objectArray[i]);
            if (mxCellHandler2 != null) {
                mxCellHandler2.refresh(object);
            } else {
                mxCellHandler2 = this.graphComponent.createHandler(object);
            }
            if (mxCellHandler2 == null) continue;
            mxCellHandler2.setHandlesVisible(bl);
            this.handlers.put(objectArray[i], mxCellHandler2);
            Rectangle rectangle2 = mxCellHandler2.getBounds();
            Stroke stroke = mxCellHandler2.getSelectionStroke();
            if (stroke != null) {
                rectangle2 = stroke.createStrokedShape(rectangle2).getBounds();
            }
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        for (mxCellHandler mxCellHandler3 : linkedHashMap.values()) {
            mxCellHandler3.destroy();
        }
        Object object = this.bounds;
        if (rectangle != null) {
            if (object != null) {
                ((Rectangle)object).add(rectangle);
            } else {
                object = rectangle;
            }
        }
        if (object != null) {
            this.graphComponent.getGraphControl().repaint((Rectangle)object);
        }
        this.bounds = rectangle;
    }

    public void paintHandles(Graphics graphics) {
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(graphics);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

