/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxICanvas2D;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;

public class mxGraphicsCanvas2D
implements mxICanvas2D {
    public static int IMAGE_SCALING = 4;
    public static int COLOR_CACHE_SIZE = 100;
    protected Graphics2D graphics;
    protected boolean textEnabled = true;
    protected transient CanvasState state = new CanvasState();
    protected transient Stack<CanvasState> stack = new Stack();
    protected transient GeneralPath currentPath;
    protected CellRendererPane rendererPane;
    protected transient Font lastFont = null;
    protected transient int lastFontStyle = 0;
    protected transient int lastFontSize = 0;
    protected transient String lastFontFamily = "";
    protected transient Stroke lastStroke = null;
    protected transient float lastStrokeWidth = 0.0f;
    protected transient int lastCap = 0;
    protected transient int lastJoin = 0;
    protected transient float lastMiterLimit = 0.0f;
    protected transient boolean lastDashed = false;
    protected transient Object lastDashPattern = "";
    protected transient LinkedHashMap<String, Color> colorCache = new LinkedHashMap<String, Color>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Color> entry) {
            return this.size() > COLOR_CACHE_SIZE;
        }
    };

    public mxGraphicsCanvas2D(Graphics2D graphics2D) {
        this.setGraphics(graphics2D);
        this.state.g = graphics2D;
        try {
            this.rendererPane = new CellRendererPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public boolean isTextEnabled() {
        return this.textEnabled;
    }

    public void setTextEnabled(boolean bl) {
        this.textEnabled = bl;
    }

    public void save() {
        this.stack.push(this.state);
        this.state = this.cloneState(this.state);
        this.state.g = (Graphics2D)this.state.g.create();
    }

    public void restore() {
        this.state = this.stack.pop();
    }

    protected CanvasState cloneState(CanvasState canvasState) {
        try {
            return (CanvasState)canvasState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void scale(double d) {
        this.state.scale *= d;
    }

    public void translate(double d, double d2) {
        this.state.dx += d;
        this.state.dy += d2;
    }

    public void rotate(double d, boolean bl, boolean bl2, double d2, double d3) {
        d2 += this.state.dx;
        d3 += this.state.dy;
        this.state.g.rotate(Math.toRadians(d), d2 *= this.state.scale, d3 *= this.state.scale);
        if (bl && bl2) {
            d += 180.0;
        } else if (bl ^ bl2) {
            double d4 = bl ? d2 : 0.0;
            int n = bl ? -1 : 1;
            double d5 = bl2 ? d3 : 0.0;
            int n2 = bl2 ? -1 : 1;
            this.state.g.translate(d4, d5);
            this.state.g.scale(n, n2);
            this.state.g.translate(-d4, -d5);
        }
        this.state.theta = d;
        this.state.rotationCx = d2;
        this.state.rotationCy = d3;
        this.state.flipH = bl;
        this.state.flipV = bl2;
    }

    public void setStrokeWidth(double d) {
        if (d != this.state.strokeWidth) {
            this.state.strokeWidth = d;
        }
    }

    public void setStrokeColor(String string) {
        if (this.state.strokeColorValue == null || !this.state.strokeColorValue.equals(string)) {
            this.state.strokeColorValue = string;
            this.state.strokeColor = null;
        }
    }

    public void setDashed(boolean bl) {
        if (bl != this.state.dashed) {
            this.state.dashed = bl;
        }
    }

    public void setDashPattern(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(" ");
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            this.state.dashPattern = fArray;
        }
    }

    public void setLineCap(String string) {
        if (!this.state.lineCap.equals(string)) {
            this.state.lineCap = string;
        }
    }

    public void setLineJoin(String string) {
        if (!this.state.lineJoin.equals(string)) {
            this.state.lineJoin = string;
        }
    }

    public void setMiterLimit(double d) {
        if (d != this.state.miterLimit) {
            this.state.miterLimit = d;
        }
    }

    public void setFontSize(double d) {
        if (d != this.state.fontSize) {
            this.state.fontSize = d;
        }
    }

    public void setFontColor(String string) {
        if (this.state.fontColorValue == null || !this.state.fontColorValue.equals(string)) {
            this.state.fontColorValue = string;
            this.state.fontColor = null;
        }
    }

    public void setFontBackgroundColor(String string) {
        if (this.state.fontBackgroundColorValue == null || !this.state.fontBackgroundColorValue.equals(string)) {
            this.state.fontBackgroundColorValue = string;
            this.state.fontBackgroundColor = null;
        }
    }

    public void setFontBorderColor(String string) {
        if (this.state.fontBorderColorValue == null || !this.state.fontBorderColorValue.equals(string)) {
            this.state.fontBorderColorValue = string;
            this.state.fontBorderColor = null;
        }
    }

    public void setFontFamily(String string) {
        if (!this.state.fontFamily.equals(string)) {
            this.state.fontFamily = string;
        }
    }

    public void setFontStyle(int n) {
        if (n != this.state.fontStyle) {
            this.state.fontStyle = n;
        }
    }

    public void setAlpha(double d) {
        if (this.state.alpha != d) {
            this.state.g.setComposite(AlphaComposite.getInstance(3, (float)d));
            this.state.alpha = d;
        }
    }

    public void setFillColor(String string) {
        if (this.state.fillColorValue == null || !this.state.fillColorValue.equals(string)) {
            this.state.fillColorValue = string;
            this.state.fillColor = null;
            this.state.gradientPaint = null;
        }
    }

    public void setGradient(String string, String string2, double d, double d2, double d3, double d4, String string3, double d5, double d6) {
        float f = (float)((this.state.dx + d) * this.state.scale);
        float f2 = (float)((this.state.dy + d2) * this.state.scale);
        float f3 = f;
        float f4 = f2;
        d4 *= this.state.scale;
        d3 *= this.state.scale;
        if (string3 == null || string3.length() == 0 || string3.equals("south")) {
            f4 = (float)((double)f2 + d4);
        } else if (string3.equals("east")) {
            f3 = (float)((double)f + d3);
        } else if (string3.equals("north")) {
            f2 = (float)((double)f2 + d4);
        } else if (string3.equals("west")) {
            f = (float)((double)f + d3);
        }
        Color color = this.parseColor(string);
        if (d5 != 1.0) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(d5 * 255.0));
        }
        Color color2 = this.parseColor(string2);
        if (d6 != 1.0) {
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)(d6 * 255.0));
        }
        this.state.gradientPaint = new GradientPaint(f, f2, color, f3, f4, color2, true);
        this.state.fillColorValue = null;
    }

    protected Color parseColor(String string) {
        Color color = this.colorCache.get(string);
        if (color == null) {
            color = mxUtils.parseColor(string);
            this.colorCache.put(string, color);
        }
        return color;
    }

    public void rect(double d, double d2, double d3, double d4) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Rectangle2D.Double((this.state.dx + d) * this.state.scale, (this.state.dy + d2) * this.state.scale, d3 * this.state.scale, d4 * this.state.scale), false);
    }

    public void roundrect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.begin();
        this.moveTo(d + d5, d2);
        this.lineTo(d + d3 - d5, d2);
        this.quadTo(d + d3, d2, d + d3, d2 + d6);
        this.lineTo(d + d3, d2 + d4 - d6);
        this.quadTo(d + d3, d2 + d4, d + d3 - d5, d2 + d4);
        this.lineTo(d + d5, d2 + d4);
        this.quadTo(d, d2 + d4, d, d2 + d4 - d6);
        this.lineTo(d, d2 + d6);
        this.quadTo(d, d2, d + d5, d2);
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Ellipse2D.Double((this.state.dx + d) * this.state.scale, (this.state.dy + d2) * this.state.scale, d3 * this.state.scale, d4 * this.state.scale), false);
    }

    public void image(double d, double d2, double d3, double d4, String string, boolean bl, boolean bl2, boolean bl3) {
        Image image;
        if (string != null && d3 > 0.0 && d4 > 0.0 && (image = this.loadImage(string)) != null) {
            Rectangle rectangle = this.getImageBounds(image, d, d2, d3, d4, bl);
            if ((image = this.scaleImage(image, rectangle.width, rectangle.height)) != null) {
                this.drawImage(this.createImageGraphics(rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2, bl3), image, rectangle.x, rectangle.y);
            }
        }
    }

    protected void drawImage(Graphics2D graphics2D, Image image, int n, int n2) {
        graphics2D.drawImage(image, n, n2, null);
    }

    protected Image loadImage(String string) {
        return mxUtils.loadImage(string);
    }

    protected final Rectangle getImageBounds(Image image, double d, double d2, double d3, double d4, boolean bl) {
        d = (this.state.dx + d) * this.state.scale;
        d2 = (this.state.dy + d2) * this.state.scale;
        d3 *= this.state.scale;
        d4 *= this.state.scale;
        if (bl) {
            Dimension dimension = this.getImageSize(image);
            double d5 = Math.min(d3 / (double)dimension.width, d4 / (double)dimension.height);
            int n = (int)Math.round((double)dimension.width * d5);
            int n2 = (int)Math.round((double)dimension.height * d5);
            d += (d3 - (double)n) / 2.0;
            d2 += (d4 - (double)n2) / 2.0;
            d3 = n;
            d4 = n2;
        } else {
            d3 = Math.round(d3);
            d4 = Math.round(d4);
        }
        return new Rectangle((int)d, (int)d2, (int)d3, (int)d4);
    }

    protected Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    protected Image scaleImage(Image image, int n, int n2) {
        Dimension dimension = this.getImageSize(image);
        if (n == dimension.width && n2 == dimension.height) {
            return image;
        }
        return image.getScaledInstance(n, n2, IMAGE_SCALING);
    }

    protected final Graphics2D createImageGraphics(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        Graphics2D graphics2D = this.state.g;
        if (bl || bl2) {
            graphics2D = (Graphics2D)graphics2D.create();
            if (bl2 && bl) {
                graphics2D.rotate(Math.toRadians(180.0), d + d3 / 2.0, d2 + d4 / 2.0);
            } else {
                int n = 1;
                int n2 = 1;
                int n3 = 0;
                int n4 = 0;
                if (bl) {
                    n = -1;
                    n3 = (int)(-d3 - 2.0 * d);
                }
                if (bl2) {
                    n2 = -1;
                    n4 = (int)(-d4 - 2.0 * d2);
                }
                graphics2D.scale(n, n2);
                graphics2D.translate(n3, n4);
            }
        }
        return graphics2D;
    }

    protected String createHtmlDocument(String string, String string2, String string3, int n, int n2, boolean bl, String string4, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("display:inline;");
        stringBuffer.append("font-family:" + this.state.fontFamily + ";");
        stringBuffer.append("font-size:" + Math.round(this.state.fontSize) + " pt;");
        stringBuffer.append("color:" + this.state.fontColorValue + ";");
        stringBuffer.append("line-height:" + Math.round(this.state.fontSize * (double)mxConstants.LINE_HEIGHT) + " px;");
        boolean bl3 = false;
        if ((this.state.fontStyle & 1) == 1) {
            stringBuffer.append("font-weight:bold;");
        }
        if ((this.state.fontStyle & 2) == 2) {
            stringBuffer.append("font-style:italic;");
        }
        if ((this.state.fontStyle & 4) == 4) {
            stringBuffer.append("text-decoration:underline;");
        }
        if (string2 != null) {
            if (string2.equals("center")) {
                stringBuffer.append("text-align:center;");
            } else if (string2.equals("right")) {
                stringBuffer.append("text-align:right;");
            }
        }
        if (this.state.fontBackgroundColorValue != null) {
            stringBuffer.append("background-color:" + this.state.fontBackgroundColorValue + ";");
        }
        if (this.state.fontBorderColorValue != null) {
            stringBuffer.append("border:1px solid " + this.state.fontBorderColorValue + ";");
        }
        if (bl2) {
            stringBuffer.append("overflow:hidden;");
            bl3 = true;
        } else if (string4 != null) {
            if (string4.equals("fill")) {
                stringBuffer.append("height:" + Math.round(n2) + "px;");
                bl3 = true;
            } else if (string4.equals("width")) {
                bl3 = true;
                if (n2 > 0) {
                    stringBuffer.append("height:" + Math.round(n2) + "px;");
                }
            }
        }
        if (bl) {
            if (!bl2) {
                bl3 = true;
            }
            stringBuffer.append("white-space:normal;");
        } else {
            stringBuffer.append("white-space:nowrap;");
        }
        if (bl3 && n > 0) {
            stringBuffer.append("width:" + Math.round(n) + "px;");
        }
        return "<html><div style=\"" + stringBuffer.toString() + "\">" + string + "</div></html>";
    }

    protected JLabel getTextRenderer() {
        return mxLightweightLabel.getSharedInstance();
    }

    protected Point2D getMargin(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        if (string != null) {
            if (string.equals("center")) {
                d = -0.5;
            } else if (string.equals("right")) {
                d = -1.0;
            }
        }
        if (string2 != null) {
            if (string2.equals("middle")) {
                d2 = -0.5;
            } else if (string2.equals("bottom")) {
                d2 = -1.0;
            }
        }
        return new Point2D.Double(d, d2);
    }

    protected void htmlText(double d, double d2, double d3, double d4, String string, String string2, String string3, boolean bl, String string4, String string5, boolean bl2, double d5) {
        d += this.state.dx;
        d2 += this.state.dy;
        JLabel jLabel = this.getTextRenderer();
        if (jLabel != null && this.rendererPane != null) {
            AffineTransform affineTransform = this.state.g.getTransform();
            this.state.g.scale(this.state.scale, this.state.scale);
            double d6 = d5 * (Math.PI / 180);
            this.state.g.rotate(d6, d, d2);
            boolean bl3 = false;
            boolean bl4 = false;
            String string6 = string;
            if (string5 != null) {
                bl3 = string5.equals("width");
                bl4 = string5.equals("fill");
            }
            string = this.createHtmlDocument(string, string2, string3, bl3 || bl4 ? (int)Math.round(d3 * mxConstants.PX_PER_PIXEL) : 0, bl4 ? (int)Math.round(d4 * mxConstants.PX_PER_PIXEL) : 0, bl, string5, bl2);
            jLabel.setText(string);
            Dimension dimension = jLabel.getPreferredSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if ((bl2 || bl) && (double)n > d3 && d3 > 0.0 || bl2 && (double)n2 > d4 && d4 > 0.0) {
                int n3 = (int)Math.round(d3 * mxConstants.PX_PER_PIXEL + (double)(bl ? 2 : 0));
                int n4 = (int)Math.round(d4 * mxConstants.PX_PER_PIXEL);
                string = this.createHtmlDocument(string6, string2, string3, n3, n4, bl, string5, bl2);
                jLabel.setText(string);
                dimension = jLabel.getPreferredSize();
                n = dimension.width;
                n2 = dimension.height + 2;
            }
            if (bl2 && d3 > 0.0 && d4 > 0.0) {
                n = Math.min(dimension.width, (int)d3);
                n2 = Math.min(n2, (int)d4);
                d4 = n2;
            } else if (!bl2 && bl && d3 > 0.0 && d4 > 0.0) {
                n = Math.min(dimension.width, (int)d3);
                d3 = n;
                d4 = n2;
                n2 = Math.max(n2, (int)d4);
            } else if (!bl2 && !bl) {
                if (d3 > 0.0 && d3 < (double)n) {
                    d3 = n;
                }
                if (d4 > 0.0 && d4 < (double)n2) {
                    d4 = n2;
                }
            }
            Point2D point2D = this.getMargin(string2, string3);
            d += point2D.getX() * (double)n;
            d2 += point2D.getY() * (double)n2;
            if (d3 == 0.0) {
                d3 = n;
            }
            if (d4 == 0.0) {
                d4 = n2;
            }
            this.rendererPane.paintComponent(this.state.g, jLabel, this.rendererPane, (int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4), true);
            this.state.g.setTransform(affineTransform);
        }
    }

    public void text(double d, double d2, double d3, double d4, String string, String string2, String string3, boolean bl, String string4, String string5, boolean bl2, double d5) {
        if (string4 != null && string4.equals("html")) {
            this.htmlText(d, d2, d3, d4, string, string2, string3, bl, string4, string5, bl2, d5);
        } else {
            this.plainText(d, d2, d3, d4, string, string2, string3, bl, string4, string5, bl2, d5);
        }
    }

    public void plainText(double d, double d2, double d3, double d4, String string, String string2, String string3, boolean bl, String string4, String string5, boolean bl2, double d5) {
        if (this.state.fontColor == null) {
            this.state.fontColor = this.parseColor(this.state.fontColorValue);
        }
        if (this.state.fontColor != null) {
            int n;
            d = (this.state.dx + d) * this.state.scale;
            d2 = (this.state.dy + d2) * this.state.scale;
            Graphics2D graphics2D = this.createTextGraphics(d, d2, d3 *= this.state.scale, d4 *= this.state.scale, d5, bl2, string2, string3);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = string.split("\n");
            int[] nArray = new int[stringArray.length];
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                nArray[n] = fontMetrics.stringWidth(stringArray[n]);
                n2 = Math.max(n2, nArray[n]);
            }
            n = Math.round((float)stringArray.length * ((float)fontMetrics.getFont().getSize() * mxConstants.LINE_HEIGHT));
            if (bl2 && (double)n > d4 && d4 > 0.0) {
                n = (int)d4;
            }
            Point2D point2D = this.getMargin(string2, string3);
            d += point2D.getX() * (double)n2;
            d2 += point2D.getY() * (double)n;
            if (this.state.fontBackgroundColorValue != null) {
                if (this.state.fontBackgroundColor == null) {
                    this.state.fontBackgroundColor = this.parseColor(this.state.fontBackgroundColorValue);
                }
                if (this.state.fontBackgroundColor != null) {
                    graphics2D.setColor(this.state.fontBackgroundColor);
                    graphics2D.fillRect((int)Math.round(d), (int)Math.round(d2 - 1.0), n2 + 1, n + 2);
                }
            }
            if (this.state.fontBorderColorValue != null) {
                if (this.state.fontBorderColor == null) {
                    this.state.fontBorderColor = this.parseColor(this.state.fontBorderColorValue);
                }
                if (this.state.fontBorderColor != null) {
                    graphics2D.setColor(this.state.fontBorderColor);
                    graphics2D.drawRect((int)Math.round(d), (int)Math.round(d2 - 1.0), n2 + 1, n + 2);
                }
            }
            graphics2D.setColor(this.state.fontColor);
            d2 += (double)(fontMetrics.getHeight() - fontMetrics.getDescent()) - (point2D.getY() + 0.5);
            for (int i = 0; i < stringArray.length; ++i) {
                double d6 = 0.0;
                if (string2 != null) {
                    if (string2.equals("center")) {
                        d6 = (n2 - nArray[i]) / 2;
                    } else if (string2.equals("right")) {
                        d6 = n2 - nArray[i];
                    }
                }
                if (stringArray[i].length() != 0) {
                    if ((this.state.fontStyle & 4) == 4) {
                        AttributedString attributedString = new AttributedString(stringArray[i]);
                        attributedString.addAttribute(TextAttribute.FONT, graphics2D.getFont());
                        attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        graphics2D.drawString(attributedString.getIterator(), (int)Math.round(d + d6), (int)Math.round(d2));
                    } else {
                        graphics2D.drawString(stringArray[i], (int)Math.round(d + d6), (int)Math.round(d2));
                    }
                }
                d2 += (double)Math.round((float)fontMetrics.getFont().getSize() * mxConstants.LINE_HEIGHT);
            }
        }
    }

    protected final Graphics2D createTextGraphics(double d, double d2, double d3, double d4, double d5, boolean bl, String string, String string2) {
        Graphics2D graphics2D = this.state.g;
        this.updateFont();
        if (d5 != 0.0) {
            graphics2D = (Graphics2D)this.state.g.create();
            double d6 = d5 * (Math.PI / 180);
            graphics2D.rotate(d6, d, d2);
        }
        if (bl && d3 > 0.0 && d4 > 0.0) {
            if (graphics2D == this.state.g) {
                graphics2D = (Graphics2D)this.state.g.create();
            }
            Point2D point2D = this.getMargin(string, string2);
            graphics2D.clip(new Rectangle2D.Double(d += point2D.getX() * d3, d2 += point2D.getY() * d4, d3, d4));
        }
        return graphics2D;
    }

    public void begin() {
        this.currentPath = new GeneralPath();
    }

    public void moveTo(double d, double d2) {
        if (this.currentPath != null) {
            this.currentPath.moveTo((float)((this.state.dx + d) * this.state.scale), (float)((this.state.dy + d2) * this.state.scale));
        }
    }

    public void lineTo(double d, double d2) {
        if (this.currentPath != null) {
            this.currentPath.lineTo((float)((this.state.dx + d) * this.state.scale), (float)((this.state.dy + d2) * this.state.scale));
        }
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        if (this.currentPath != null) {
            this.currentPath.quadTo((float)((this.state.dx + d) * this.state.scale), (float)((this.state.dy + d2) * this.state.scale), (float)((this.state.dx + d3) * this.state.scale), (float)((this.state.dy + d4) * this.state.scale));
        }
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.currentPath != null) {
            this.currentPath.curveTo((float)((this.state.dx + d) * this.state.scale), (float)((this.state.dy + d2) * this.state.scale), (float)((this.state.dx + d3) * this.state.scale), (float)((this.state.dy + d4) * this.state.scale), (float)((this.state.dx + d5) * this.state.scale), (float)((this.state.dy + d6) * this.state.scale));
        }
    }

    public void close() {
        if (this.currentPath != null) {
            this.currentPath.closePath();
        }
    }

    public void stroke() {
        this.paintCurrentPath(false, true);
    }

    public void fill() {
        this.paintCurrentPath(true, false);
    }

    public void fillAndStroke() {
        this.paintCurrentPath(true, true);
    }

    protected void paintCurrentPath(boolean bl, boolean bl2) {
        if (this.currentPath != null) {
            if (bl2) {
                if (this.state.strokeColor == null) {
                    this.state.strokeColor = this.parseColor(this.state.strokeColorValue);
                }
                if (this.state.strokeColor != null) {
                    this.updateStroke();
                }
            }
            if (bl && this.state.gradientPaint == null && this.state.fillColor == null) {
                this.state.fillColor = this.parseColor(this.state.fillColorValue);
            }
            if (this.state.shadow) {
                this.paintShadow(bl, bl2);
            }
            if (bl) {
                if (this.state.gradientPaint != null) {
                    this.state.g.setPaint(this.state.gradientPaint);
                    this.state.g.fill(this.currentPath);
                } else {
                    if (this.state.fillColor == null) {
                        this.state.fillColor = this.parseColor(this.state.fillColorValue);
                    }
                    if (this.state.fillColor != null) {
                        this.state.g.setColor(this.state.fillColor);
                        this.state.g.setPaint(null);
                        this.state.g.fill(this.currentPath);
                    }
                }
            }
            if (bl2 && this.state.strokeColor != null) {
                this.state.g.setColor(this.state.strokeColor);
                this.state.g.draw(this.currentPath);
            }
        }
    }

    protected void paintShadow(boolean bl, boolean bl2) {
        if (this.state.shadowColor == null) {
            this.state.shadowColor = this.parseColor(this.state.shadowColorValue);
        }
        if (this.state.shadowColor != null) {
            double d = -this.state.theta * (Math.PI / 180);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = this.state.shadowOffsetX * this.state.scale;
            double d5 = this.state.shadowOffsetY * this.state.scale;
            if (this.state.flipH) {
                d4 *= -1.0;
            }
            if (this.state.flipV) {
                d5 *= -1.0;
            }
            double d6 = d4 * d2 - d5 * d3;
            double d7 = d4 * d3 + d5 * d2;
            this.state.g.setColor(this.state.shadowColor);
            this.state.g.translate(d6, d7);
            double d8 = this.state.alpha * this.state.shadowAlpha;
            Composite composite = this.state.g.getComposite();
            this.state.g.setComposite(AlphaComposite.getInstance(3, (float)d8));
            if (bl && (this.state.gradientPaint != null || this.state.fillColor != null)) {
                this.state.g.fill(this.currentPath);
            }
            if (bl2 && this.state.strokeColor != null) {
                this.state.g.draw(this.currentPath);
            }
            this.state.g.translate(-d6, -d7);
            this.state.g.setComposite(composite);
        }
    }

    public void setShadow(boolean bl) {
        this.state.shadow = bl;
    }

    public void setShadowColor(String string) {
        this.state.shadowColorValue = string;
    }

    public void setShadowAlpha(double d) {
        this.state.shadowAlpha = d;
    }

    public void setShadowOffset(double d, double d2) {
        this.state.shadowOffsetX = d;
        this.state.shadowOffsetY = d2;
    }

    protected void updateFont() {
        int n = (int)Math.round(this.state.fontSize * this.state.scale);
        int n2 = (this.state.fontStyle & 1) == 1 ? 1 : 0;
        if (this.lastFont == null || !this.lastFontFamily.equals(this.state.fontFamily) || n != this.lastFontSize || (n2 += (this.state.fontStyle & 2) == 2 ? 2 : 0) != this.lastFontStyle) {
            this.lastFont = this.createFont(this.state.fontFamily, n2, n);
            this.lastFontFamily = this.state.fontFamily;
            this.lastFontStyle = n2;
            this.lastFontSize = n;
        }
        this.state.g.setFont(this.lastFont);
    }

    protected Font createFont(String string, int n, int n2) {
        return new Font(this.getFontName(string), n, n2);
    }

    protected String getFontName(String string) {
        int n;
        if (string != null && (n = string.indexOf(44)) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected void updateStroke() {
        float f = (float)Math.max(1.0, this.state.strokeWidth * this.state.scale);
        int n = 0;
        if (this.state.lineCap.equals("round")) {
            n = 1;
        } else if (this.state.lineCap.equals("square")) {
            n = 2;
        }
        int n2 = 0;
        if (this.state.lineJoin.equals("round")) {
            n2 = 1;
        } else if (this.state.lineJoin.equals("bevel")) {
            n2 = 2;
        }
        float f2 = (float)this.state.miterLimit;
        if (this.lastStroke == null || this.lastStrokeWidth != f || this.lastCap != n || this.lastJoin != n2 || this.lastMiterLimit != f2 || this.lastDashed != this.state.dashed || this.state.dashed && this.lastDashPattern != this.state.dashPattern) {
            float[] fArray = null;
            if (this.state.dashed) {
                fArray = new float[this.state.dashPattern.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.state.dashPattern[i] * f;
                }
            }
            this.lastStroke = new BasicStroke(f, n, n2, f2, fArray, 0.0f);
            this.lastStrokeWidth = f;
            this.lastCap = n;
            this.lastJoin = n2;
            this.lastMiterLimit = f2;
            this.lastDashed = this.state.dashed;
            this.lastDashPattern = this.state.dashPattern;
        }
        this.state.g.setStroke(this.lastStroke);
    }

    protected class CanvasState
    implements Cloneable {
        protected double alpha = 1.0;
        protected double scale = 1.0;
        protected double dx = 0.0;
        protected double dy = 0.0;
        protected double theta = 0.0;
        protected double rotationCx = 0.0;
        protected double rotationCy = 0.0;
        protected boolean flipV = false;
        protected boolean flipH = false;
        protected double miterLimit = 10.0;
        protected int fontStyle = 0;
        protected double fontSize = mxConstants.DEFAULT_FONTSIZE;
        protected String fontFamily = mxConstants.DEFAULT_FONTFAMILIES;
        protected String fontColorValue = "#000000";
        protected Color fontColor;
        protected String fontBackgroundColorValue;
        protected Color fontBackgroundColor;
        protected String fontBorderColorValue;
        protected Color fontBorderColor;
        protected String lineCap = "flat";
        protected String lineJoin = "miter";
        protected double strokeWidth = 1.0;
        protected String strokeColorValue;
        protected Color strokeColor;
        protected String fillColorValue;
        protected Color fillColor;
        protected Paint gradientPaint;
        protected boolean dashed = false;
        protected float[] dashPattern = new float[]{3.0f, 3.0f};
        protected boolean shadow = false;
        protected String shadowColorValue = mxConstants.W3C_SHADOWCOLOR;
        protected Color shadowColor;
        protected double shadowAlpha = 1.0;
        protected double shadowOffsetX = mxConstants.SHADOW_OFFSETX;
        protected double shadowOffsetY = mxConstants.SHADOW_OFFSETY;
        protected transient Graphics2D g;

        protected CanvasState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

