/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.shape.mxActorShape;
import com.mxgraph.shape.mxArrowShape;
import com.mxgraph.shape.mxCloudShape;
import com.mxgraph.shape.mxConnectorShape;
import com.mxgraph.shape.mxCurveShape;
import com.mxgraph.shape.mxCylinderShape;
import com.mxgraph.shape.mxDefaultTextShape;
import com.mxgraph.shape.mxDoubleEllipseShape;
import com.mxgraph.shape.mxEllipseShape;
import com.mxgraph.shape.mxHexagonShape;
import com.mxgraph.shape.mxHtmlTextShape;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.shape.mxImageShape;
import com.mxgraph.shape.mxLabelShape;
import com.mxgraph.shape.mxLineShape;
import com.mxgraph.shape.mxRectangleShape;
import com.mxgraph.shape.mxRhombusShape;
import com.mxgraph.shape.mxStencilRegistry;
import com.mxgraph.shape.mxSwimlaneShape;
import com.mxgraph.shape.mxTriangleShape;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphics2DCanvas
extends mxBasicCanvas {
    public static final String TEXT_SHAPE_DEFAULT = "default";
    public static final String TEXT_SHAPE_HTML = "html";
    public static int IMAGE_SCALING = 4;
    protected static Map<String, mxIShape> shapes = new HashMap<String, mxIShape>();
    protected static Map<String, mxITextShape> textShapes = new HashMap<String, mxITextShape>();
    protected CellRendererPane rendererPane;
    protected Graphics2D g;

    public mxGraphics2DCanvas() {
        this(null);
    }

    public mxGraphics2DCanvas(Graphics2D graphics2D) {
        this.g = graphics2D;
        try {
            this.rendererPane = new CellRendererPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putShape(String string, mxIShape mxIShape2) {
        shapes.put(string, mxIShape2);
    }

    public mxIShape getShape(Map<String, Object> map) {
        String string = mxUtils.getString(map, mxConstants.STYLE_SHAPE, null);
        mxIShape mxIShape2 = shapes.get(string);
        if (mxIShape2 == null && string != null) {
            mxIShape2 = mxStencilRegistry.getStencil(string);
        }
        return mxIShape2;
    }

    public static void putTextShape(String string, mxITextShape mxITextShape2) {
        textShapes.put(string, mxITextShape2);
    }

    public mxITextShape getTextShape(Map<String, Object> map, boolean bl) {
        String string = bl ? TEXT_SHAPE_HTML : TEXT_SHAPE_DEFAULT;
        return textShapes.get(string);
    }

    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    @Override
    public Object drawCell(mxCellState mxCellState2) {
        Map<String, Object> map = mxCellState2.getStyle();
        mxIShape mxIShape2 = this.getShape(map);
        if (this.g != null && mxIShape2 != null) {
            float f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
            Graphics2D graphics2D = this.g;
            this.g = this.createTemporaryGraphics(map, f, mxCellState2);
            mxIShape2.paintShape(this, mxCellState2);
            this.g.dispose();
            this.g = graphics2D;
        }
        return mxIShape2;
    }

    @Override
    public Object drawLabel(String string, mxCellState mxCellState2, boolean bl) {
        Map<String, Object> map = mxCellState2.getStyle();
        mxITextShape mxITextShape2 = this.getTextShape(map, bl);
        if (this.g != null && mxITextShape2 != null && this.drawLabels && string != null && string.length() > 0) {
            float f = mxUtils.getFloat(map, mxConstants.STYLE_TEXT_OPACITY, 100.0f);
            Graphics2D graphics2D = this.g;
            this.g = this.createTemporaryGraphics(map, f, null);
            Color color = mxUtils.getColor(map, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            Color color2 = mxUtils.getColor(map, mxConstants.STYLE_LABEL_BORDERCOLOR);
            this.paintRectangle(mxCellState2.getLabelBounds().getRectangle(), color, color2);
            mxITextShape2.paintShape(this, string, mxCellState2, map);
            this.g.dispose();
            this.g = graphics2D;
        }
        return mxITextShape2;
    }

    public void drawImage(Rectangle rectangle, String string) {
        this.drawImage(rectangle, string, PRESERVE_IMAGE_ASPECT, false, false);
    }

    public void drawImage(Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3) {
        BufferedImage bufferedImage;
        if (string != null && rectangle.getWidth() > 0.0 && rectangle.getHeight() > 0.0 && (bufferedImage = this.loadImage(string)) != null) {
            Image image;
            int n;
            int n2;
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            Dimension dimension = this.getImageSize(bufferedImage);
            if (bl) {
                double d = Math.min((double)rectangle.width / (double)dimension.width, (double)rectangle.height / (double)dimension.height);
                n2 = (int)((double)dimension.width * d);
                n = (int)((double)dimension.height * d);
                n3 += (rectangle.width - n2) / 2;
                n4 += (rectangle.height - n) / 2;
            } else {
                n2 = rectangle.width;
                n = rectangle.height;
            }
            Image image2 = image = n2 == dimension.width && n == dimension.height ? bufferedImage : bufferedImage.getScaledInstance(n2, n, IMAGE_SCALING);
            if (image != null) {
                AffineTransform affineTransform = null;
                if (bl2 || bl3) {
                    affineTransform = this.g.getTransform();
                    int n5 = 1;
                    int n6 = 1;
                    int n7 = 0;
                    int n8 = 0;
                    if (bl2) {
                        n5 = -1;
                        n7 = -n2 - 2 * n3;
                    }
                    if (bl3) {
                        n6 = -1;
                        n8 = -n - 2 * n4;
                    }
                    this.g.scale(n5, n6);
                    this.g.translate(n7, n8);
                }
                this.drawImageImpl(image, n3, n4);
                if (affineTransform != null) {
                    this.g.setTransform(affineTransform);
                }
            }
        }
    }

    protected void drawImageImpl(Image image, int n, int n2) {
        this.g.drawImage(image, n, n2, null);
    }

    protected Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public void paintPolyline(mxPoint[] mxPointArray, boolean bl) {
        if (mxPointArray != null && mxPointArray.length > 1) {
            mxPoint mxPoint2 = mxPointArray[0];
            mxPoint mxPoint3 = mxPointArray[mxPointArray.length - 1];
            double d = mxConstants.LINE_ARCSIZE * this.scale;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)mxPoint2.getX(), (float)mxPoint2.getY());
            for (int i = 1; i < mxPointArray.length - 1; ++i) {
                mxPoint mxPoint4 = mxPointArray[i];
                double d2 = mxPoint2.getX() - mxPoint4.getX();
                double d3 = mxPoint2.getY() - mxPoint4.getY();
                if (bl && i < mxPointArray.length - 1 && (d2 != 0.0 || d3 != 0.0)) {
                    double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                    double d5 = d2 * Math.min(d, d4 / 2.0) / d4;
                    double d6 = d3 * Math.min(d, d4 / 2.0) / d4;
                    double d7 = mxPoint4.getX() + d5;
                    double d8 = mxPoint4.getY() + d6;
                    generalPath.lineTo((float)d7, (float)d8);
                    mxPoint mxPoint5 = mxPointArray[i + 1];
                    d2 = mxPoint5.getX() - mxPoint4.getX();
                    d3 = mxPoint5.getY() - mxPoint4.getY();
                    d4 = Math.max(1.0, Math.sqrt(d2 * d2 + d3 * d3));
                    double d9 = d2 * Math.min(d, d4 / 2.0) / d4;
                    double d10 = d3 * Math.min(d, d4 / 2.0) / d4;
                    double d11 = mxPoint4.getX() + d9;
                    double d12 = mxPoint4.getY() + d10;
                    generalPath.quadTo((float)mxPoint4.getX(), (float)mxPoint4.getY(), (float)d11, (float)d12);
                    mxPoint4 = new mxPoint(d11, d12);
                } else {
                    generalPath.lineTo((float)mxPoint4.getX(), (float)mxPoint4.getY());
                }
                mxPoint2 = mxPoint4;
            }
            generalPath.lineTo((float)mxPoint3.getX(), (float)mxPoint3.getY());
            this.g.draw(generalPath);
        }
    }

    public void paintRectangle(Rectangle rectangle, Color color, Color color2) {
        if (color != null) {
            this.g.setColor(color);
            this.fillShape(rectangle);
        }
        if (color2 != null) {
            this.g.setColor(color2);
            this.g.draw(rectangle);
        }
    }

    public void fillShape(Shape shape) {
        this.fillShape(shape, false);
    }

    public void fillShape(Shape shape, boolean bl) {
        int n;
        int n2 = bl ? mxConstants.SHADOW_OFFSETX : 0;
        int n3 = n = bl ? mxConstants.SHADOW_OFFSETY : 0;
        if (bl) {
            Paint paint = this.g.getPaint();
            Color color = this.g.getColor();
            this.g.setColor(mxSwingConstants.SHADOW_COLOR);
            this.g.translate(n2, n);
            this.fillShape(shape, false);
            this.g.translate(-n2, -n);
            this.g.setColor(color);
            this.g.setPaint(paint);
        }
        this.g.fill(shape);
    }

    public Stroke createStroke(Map<String, Object> map) {
        double d = (double)mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale;
        boolean bl = mxUtils.isTrue(map, mxConstants.STYLE_DASHED);
        if (bl) {
            float[] fArray = mxUtils.getFloatArray(map, mxConstants.STYLE_DASH_PATTERN, mxConstants.DEFAULT_DASHED_PATTERN, " ");
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray2[i] = (float)((double)fArray[i] * this.scale * d);
            }
            return new BasicStroke((float)d, 0, 0, 10.0f, fArray2, 0.0f);
        }
        return new BasicStroke((float)d);
    }

    public Paint createFillPaint(mxRectangle mxRectangle2, Map<String, Object> map) {
        Color color;
        Color color2 = mxUtils.getColor(map, mxConstants.STYLE_FILLCOLOR);
        GradientPaint gradientPaint = null;
        if (color2 != null && (color = mxUtils.getColor(map, mxConstants.STYLE_GRADIENTCOLOR)) != null) {
            String string = mxUtils.getString(map, mxConstants.STYLE_GRADIENT_DIRECTION);
            float f = (float)mxRectangle2.getX();
            float f2 = (float)mxRectangle2.getY();
            float f3 = (float)mxRectangle2.getX();
            float f4 = (float)mxRectangle2.getY();
            if (string == null || string.equals("south")) {
                f4 = (float)(mxRectangle2.getY() + mxRectangle2.getHeight());
            } else if (string.equals("east")) {
                f3 = (float)(mxRectangle2.getX() + mxRectangle2.getWidth());
            } else if (string.equals("north")) {
                f2 = (float)(mxRectangle2.getY() + mxRectangle2.getHeight());
            } else if (string.equals("west")) {
                f = (float)(mxRectangle2.getX() + mxRectangle2.getWidth());
            }
            gradientPaint = new GradientPaint(f, f2, color2, f3, f4, color, true);
        }
        return gradientPaint;
    }

    public Graphics2D createTemporaryGraphics(Map<String, Object> map, float f, mxRectangle mxRectangle2) {
        double d;
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        graphics2D.translate(this.translate.x, this.translate.y);
        if (mxRectangle2 != null && (d = mxUtils.getDouble(map, mxConstants.STYLE_ROTATION, 0.0)) != 0.0) {
            graphics2D.rotate(Math.toRadians(d), mxRectangle2.getCenterX(), mxRectangle2.getCenterY());
        }
        if (f != 100.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f / 100.0f));
        }
        return graphics2D;
    }

    static {
        mxGraphics2DCanvas.putShape("actor", new mxActorShape());
        mxGraphics2DCanvas.putShape("arrow", new mxArrowShape());
        mxGraphics2DCanvas.putShape("cloud", new mxCloudShape());
        mxGraphics2DCanvas.putShape("connector", new mxConnectorShape());
        mxGraphics2DCanvas.putShape("cylinder", new mxCylinderShape());
        mxGraphics2DCanvas.putShape("curve", new mxCurveShape());
        mxGraphics2DCanvas.putShape("doubleEllipse", new mxDoubleEllipseShape());
        mxGraphics2DCanvas.putShape("ellipse", new mxEllipseShape());
        mxGraphics2DCanvas.putShape("hexagon", new mxHexagonShape());
        mxGraphics2DCanvas.putShape("image", new mxImageShape());
        mxGraphics2DCanvas.putShape("label", new mxLabelShape());
        mxGraphics2DCanvas.putShape("line", new mxLineShape());
        mxGraphics2DCanvas.putShape("rectangle", new mxRectangleShape());
        mxGraphics2DCanvas.putShape("rhombus", new mxRhombusShape());
        mxGraphics2DCanvas.putShape("swimlane", new mxSwimlaneShape());
        mxGraphics2DCanvas.putShape("triangle", new mxTriangleShape());
        mxGraphics2DCanvas.putTextShape(TEXT_SHAPE_DEFAULT, new mxDefaultTextShape());
        mxGraphics2DCanvas.putTextShape(TEXT_SHAPE_HTML, new mxHtmlTextShape());
    }
}

