/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.costfunction.mxDoubleValCostFunction;
import com.mxgraph.generatorfunction.mxGeneratorFunction;
import com.mxgraph.generatorfunction.mxGeneratorRandomFunction;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphGenerator {
    private mxGeneratorFunction generatorFunction = null;
    private mxCostFunction costFunction = null;

    public mxGraphGenerator(mxGeneratorFunction mxGeneratorFunction2, mxCostFunction mxCostFunction2) {
        if (mxGeneratorFunction2 != null) {
            this.generatorFunction = mxGeneratorFunction2;
        }
        this.costFunction = mxCostFunction2 != null ? mxCostFunction2 : new mxDoubleValCostFunction();
    }

    public void getNullGraph(mxAnalysisGraph mxAnalysisGraph2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        for (int i = 0; i < n; ++i) {
            mxGraph2.insertVertex(object, null, new Integer(i).toString(), i * 50, 0.0, 25.0, 25.0);
        }
    }

    public void getCompleteGraph(mxAnalysisGraph mxAnalysisGraph2, int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = mxGraph2.insertVertex(object, null, new Integer(n2).toString(), n2 * 50, 0.0, 25.0, 25.0);
        }
        for (n2 = 0; n2 < n; ++n2) {
            Object object2 = objectArray[n2];
            for (int i = 0; i < n; ++i) {
                Object object3 = objectArray[i];
                if (object2 == object3 || mxGraphStructure.areConnected(mxAnalysisGraph2, object2, object3)) continue;
                mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object2, object3);
            }
        }
    }

    public void getGridGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        int n4 = n * n2;
        Object[] objectArray = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray[n3] = mxGraph2.insertVertex(object, null, new Integer(n3).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object2 = objectArray[n3];
                if (j > 0) {
                    mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[n3 - 1], object2);
                }
                if (i > 0) {
                    mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[n3 - n], object2);
                }
                ++n3;
            }
        }
    }

    public void setGridGraphSpacing(mxAnalysisGraph mxAnalysisGraph2, double d, double d2, int n, int n2) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        if (d < 0.0 || d2 < 0.0 || n < 1 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object2 = objectArray[i * n + j];
                mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object2);
                mxGeometry2.setX((double)j * d);
                mxGeometry2.setY((double)i * d2);
            }
        }
    }

    public void getBipartiteGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        Object object;
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = n + n2;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object2 = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray[n3] = mxGraph2.insertVertex(object2, null, new Integer(n3).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (n3 = 0; n3 < n; ++n3) {
            object = objectArray[n3];
            Object object3 = objectArray[this.getRandomInt(n, n4 - 1)];
            mxGraph2.insertEdge(object2, null, this.getNewEdgeValue(mxAnalysisGraph2), object, object3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            object = objectArray[n + n3];
            int n5 = mxAnalysisGraph2.getOpposites(mxAnalysisGraph2.getEdges(object, null, true, true, false, true), object, true, true).length;
            if (n5 != 0) continue;
            Object object4 = objectArray[this.getRandomInt(0, n - 1)];
            mxGraph2.insertEdge(object2, null, this.getNewEdgeValue(mxAnalysisGraph2), object, object4);
        }
    }

    public void setBipartiteGraphSpacing(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, double d, double d2) {
        mxGeometry mxGeometry2;
        Object object;
        int n3;
        double d3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        double d4 = 0.0;
        double d5 = 0.0;
        Object object2 = mxGraph2.getDefaultParent();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        if (n < n2) {
            d3 = (double)n2 * d;
            d4 = (d3 - (double)n * d) / 2.0;
        } else {
            d3 = (double)n * d;
            d5 = (d3 - (double)n2 * d) / 2.0;
        }
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object2);
        for (n3 = 0; n3 < n; ++n3) {
            object = objectArray[n3];
            mxGeometry2 = mxIGraphModel2.getGeometry(object);
            mxGeometry2.setX(0.0);
            mxGeometry2.setY(d4 + (double)n3 * d);
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            object = objectArray[n3];
            mxGeometry2 = mxIGraphModel2.getGeometry(object);
            mxGeometry2.setX(d2);
            mxGeometry2.setY(d5 + (double)(n3 - n) * d);
        }
    }

    public void getCompleteBipartiteGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = n + n2;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray[n3] = mxGraph2.insertVertex(object, null, new Integer(n3).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = n; i < n4; ++i) {
                Object object2 = objectArray[n3];
                Object object3 = objectArray[i];
                mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object2, object3);
            }
        }
    }

    public void getKnightGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        if (n < 3 || n2 < 3) {
            throw new IllegalArgumentException();
        }
        int n3 = n * n2;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray[i] = mxGraph2.insertVertex(object, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int[] nArray = new int[2];
        for (int i = 0; i < n * n2; ++i) {
            nArray = this.getVertexGridCoords(n, n2, i);
            Object[] objectArray2 = this.getKnightMoveVertexes(mxAnalysisGraph2, n, n2, nArray[0], nArray[1]);
            for (int j = 0; j < objectArray2.length; ++j) {
                if (mxGraphStructure.areConnected(mxAnalysisGraph2, objectArray[i], objectArray2[j])) continue;
                mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[i], objectArray2[j]);
            }
        }
    }

    public Object[] getKnightMoveVertexes(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, int n3, int n4) {
        Object object;
        if (n3 > n || n4 > n2 || n < 1 || n2 < 1 || n3 < 1 || n4 < 1) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxGraph2.getDefaultParent());
        int n5 = n3 + 1;
        int n6 = n4 - 2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 + 2;
        n6 = n4 - 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 + 2;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 + 1;
        n6 = n4 + 2;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 1;
        n6 = n4 + 2;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 2;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 2;
        n6 = n4 - 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 1;
        n6 = n4 - 2;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public int[] getVertexGridCoords(int n, int n2, int n3) {
        if (n3 > n2 * n - 1 || n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = (int)Math.floor(n3 / n);
        int n5 = n3 - n4 * n + 1;
        int[] nArray = new int[]{n5, ++n4};
        return nArray;
    }

    private Object getVertexFromGrid(Object[] objectArray, int n, int n2, int n3, int n4) {
        if (n3 > n || n4 > n2 || n < 1 || n2 < 1 || n3 < 1 || n4 < 1) {
            throw new IllegalArgumentException();
        }
        int n5 = (n4 - 1) * n + n3 - 1;
        return objectArray[n5];
    }

    public void getKingGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException();
        }
        int n3 = n * n2;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray[i] = mxGraph2.insertVertex(object, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int[] nArray = new int[2];
        for (int i = 0; i < n * n2; ++i) {
            nArray = this.getVertexGridCoords(n, n2, i);
            Object[] objectArray2 = this.getKingMoveVertexes(mxAnalysisGraph2, n, n2, nArray[0], nArray[1]);
            for (int j = 0; j < objectArray2.length; ++j) {
                if (mxGraphStructure.areConnected(mxAnalysisGraph2, objectArray[i], objectArray2[j])) continue;
                mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[i], objectArray2[j]);
            }
        }
    }

    public Object[] getKingMoveVertexes(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, int n3, int n4) {
        Object object;
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxGraph2.getDefaultParent());
        int n5 = n3 + 1;
        int n6 = n4 - 1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 + 1;
        n6 = n4;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 + 1;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 1;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 1;
        n6 = n4;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3 - 1;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        n5 = n3;
        n6 = n4 - 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2) {
            object = this.getVertexFromGrid(objectArray, n, n2, n5, n6);
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public void getPetersenGraph(mxAnalysisGraph mxAnalysisGraph2) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[10];
        for (int i = 0; i < 10; ++i) {
            objectArray[i] = mxGraph2.insertVertex(object, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[0], objectArray[2]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[0], objectArray[8]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[0], objectArray[9]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[1], objectArray[2]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[1], objectArray[5]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[1], objectArray[7]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[2], objectArray[4]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[3], objectArray[4]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[3], objectArray[7]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[3], objectArray[9]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[4], objectArray[6]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[5], objectArray[6]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[5], objectArray[9]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[6], objectArray[8]);
        mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[7], objectArray[8]);
    }

    public void getPathGraph(mxAnalysisGraph mxAnalysisGraph2, int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = mxGraph2.insertVertex(object, null, new Integer(n2).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[n2], objectArray[n2 + 1]);
        }
    }

    public void setPathGraphSpacing(mxAnalysisGraph mxAnalysisGraph2, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object2);
            mxGeometry2.setX(0.0);
            mxGeometry2.setY((double)i * d);
        }
    }

    public void getStarGraph(mxAnalysisGraph mxAnalysisGraph2, int n) {
        int n2;
        if (n < 4) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = mxGraph2.insertVertex(object, null, new Integer(n2).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[n2], objectArray[i]);
        }
    }

    public void setStarGraphLayout(mxAnalysisGraph mxAnalysisGraph2, double d) {
        double d2;
        if (d < 4.0) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        int n = objectArray.length;
        double d3 = d2 = d / 2.0;
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = (double)i / (double)n2;
            d6 *= 2.0;
            d4 = Math.round(d2 + (double)Math.round(d * Math.sin(d6 *= Math.PI) / 2.0));
            d5 = Math.round(d3 - (double)Math.round(d * Math.cos(d6) / 2.0));
            Object object2 = objectArray[i];
            mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object2);
            mxGeometry2.setX(d4);
            mxGeometry2.setY(d5);
        }
        mxGeometry mxGeometry3 = mxIGraphModel2.getGeometry(objectArray[n - 1]);
        mxGeometry3.setX(d2);
        mxGeometry3.setY(d3);
    }

    public void getWheelGraph(mxAnalysisGraph mxAnalysisGraph2, int n) {
        int n2;
        if (n < 4) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = mxGraph2.insertVertex(object, null, new Integer(n2).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[n2], objectArray[i]);
            if (i < n2 - 1) {
                mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[i], objectArray[i + 1]);
                continue;
            }
            mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), objectArray[i], objectArray[0]);
        }
    }

    public void getFriendshipWindmillGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        int n3;
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        int n4 = n * n2 + 1;
        Object[] objectArray = new Object[n4];
        int n5 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                objectArray[n5] = mxGraph2.insertVertex(object, null, new Integer(n5).toString(), 0.0, 0.0, 25.0, 25.0);
                ++n5;
            }
        }
        objectArray[n4 - 1] = mxGraph2.insertVertex(object, null, new Integer(n4 - 1).toString(), 0.0, 0.0, 25.0, 25.0);
        for (n3 = 0; n3 < n; ++n3) {
            Object object2 = objectArray[n4 - 1];
            for (int i = 0; i < n2; ++i) {
                Object object3 = objectArray[n3 * n2 + i];
                mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object2, object3);
                object2 = object3;
            }
            Object object4 = objectArray[n4 - 1];
            mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object2, object4);
        }
    }

    public void getWindmillGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2) {
        int n3;
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        int n4 = n * n2 + 1;
        Object[] objectArray = new Object[n4];
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n5] = mxGraph2.insertVertex(object, null, new Integer(n5).toString(), 0.0, 0.0, 25.0, 25.0);
                ++n5;
            }
        }
        objectArray[n4 - 1] = mxGraph2.insertVertex(object, null, new Integer(n4 - 1).toString(), 0.0, 0.0, 25.0, 25.0);
        Object object2 = objectArray[n4 - 1];
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                Object object3 = objectArray[n3 * n2 + i];
                if (!mxGraphStructure.areConnected(mxAnalysisGraph2, object2, object3)) {
                    mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object2, object3);
                }
                for (int j = 0; j < n2; ++j) {
                    Object object4 = objectArray[n3 * n2 + j];
                    if (i == j || mxGraphStructure.areConnected(mxAnalysisGraph2, object3, object4)) continue;
                    mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object3, object4);
                }
            }
        }
    }

    public void setWindmillGraphLayout(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, double d) {
        double d2;
        if (d < 0.0 || n < 2 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        int n3 = objectArray.length;
        double d3 = d2 = d / 2.0;
        boolean bl = n2 % 2 == 0;
        int n4 = (int)Math.ceil((float)n2 / 2.0f);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d4 = this.getRingSize(j + 1, n2, d);
                double d5 = 0.0;
                double d6 = 0.0;
                int n5 = 0;
                double d7 = 0.0;
                n5 = n;
                d7 = bl && j == n4 - 1 ? ((double)i - (double)5.0E-4f * d / Math.pow(n2, 1.0)) / (double)n5 : (bl && j == n4 ? ((double)i + (double)5.0E-4f * d / Math.pow(n2, 1.0)) / (double)n5 : (!bl && d4 == d ? (double)i / (double)n5 : (j + 1 < n4 ? ((double)i - 1.0 / Math.pow(d4, 0.25) + (double)1.5E-13f * Math.pow(d4, 4.0)) / (double)n5 : ((double)i + 1.0 / Math.pow(d4, 0.25) - (double)1.5E-13f * Math.pow(d4, 4.0)) / (double)n5)));
                d7 *= 2.0;
                d5 = Math.round(d2 + (double)Math.round(d4 * Math.sin(d7 *= Math.PI) / 2.0));
                d6 = Math.round(d3 - (double)Math.round(d4 * Math.cos(d7) / 2.0));
                int n6 = i * n2 + j;
                Object object2 = objectArray[n6];
                mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object2);
                mxGeometry2.setX(d5);
                mxGeometry2.setY(d6);
            }
        }
        Object object3 = objectArray[n3 - 1];
        mxGeometry mxGeometry3 = mxIGraphModel2.getGeometry(object3);
        mxGeometry3.setX(d2);
        mxGeometry3.setY(d3);
    }

    private double getRingSize(int n, int n2, double d) {
        if (n < 1 || n > n2 || n2 < 1 || d < 0.0) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        boolean bl = n2 % 2 == 0;
        n3 = (int)Math.ceil((float)n2 / 2.0f);
        if (n == n3 || bl && n == n3 + 1) {
            return d;
        }
        if (n >= n3) {
            n = n2 - n + 1;
        }
        return (double)((float)Math.pow(n, 0.75) / (float)Math.pow(n3, 0.75)) * d;
    }

    public void getSimpleRandomGraph(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = new Object[n];
        for (n3 = 0; n3 < n; ++n3) {
            objectArray[n3] = mxGraph2.insertVertex(object, null, new Integer(n3).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            Object object2;
            Object object3;
            boolean bl4 = true;
            do {
                bl4 = true;
                object3 = objectArray[(int)Math.round(Math.random() * (double)(objectArray.length - 1))];
                object2 = objectArray[(int)Math.round(Math.random() * (double)(objectArray.length - 1))];
                if (!bl && object3.equals(object2)) {
                    bl4 = false;
                    continue;
                }
                if (bl2 || !mxGraphStructure.areConnected(mxAnalysisGraph2, object3, object2)) continue;
                bl4 = false;
            } while (!bl4);
            mxGraph2.insertEdge(object, null, this.getNewEdgeValue(mxAnalysisGraph2), object3, object2);
        }
        if (bl3) {
            mxGraphStructure.makeConnected(mxAnalysisGraph2);
        }
    }

    public void getSimpleRandomTree(mxAnalysisGraph mxAnalysisGraph2, int n) {
        int n2 = Math.round(n * 2);
        this.getSimpleRandomGraph(mxAnalysisGraph2, n, n2, false, false, true);
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        try {
            this.oneSpanningTree(mxAnalysisGraph2, true, true);
        }
        catch (StructuralException structuralException) {
            System.out.println(structuralException);
        }
        try {
            mxGraphStructure.makeTreeDirected(mxAnalysisGraph2, objectArray[(int)Math.round(Math.random() * (double)(objectArray.length - 1))]);
        }
        catch (StructuralException structuralException) {
            System.out.println(structuralException);
        }
    }

    public Double getNewEdgeValue(mxAnalysisGraph mxAnalysisGraph2) {
        if (this.getGeneratorFunction() != null) {
            mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
            return this.getGeneratorFunction().getCost(mxGraph2.getView().getState(mxGraph2.getDefaultParent()));
        }
        return null;
    }

    public static mxGeneratorFunction getGeneratorFunction(mxGraph mxGraph2, boolean bl, double d, double d2) {
        if (bl) {
            return new mxGeneratorRandomFunction(d, d2, 2);
        }
        return null;
    }

    public mxGeneratorFunction getGeneratorFunction() {
        return this.generatorFunction;
    }

    public int getRandomInt(int n, int n2) {
        int n3;
        if (n == n2) {
            return n;
        }
        if (n > n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        n3 = 0;
        n3 = n + (int)Math.round(Math.random() * (double)(n2 - n));
        return n3;
    }

    public void oneSpanningTree(mxAnalysisGraph mxAnalysisGraph2, boolean bl, boolean bl2) throws StructuralException {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        boolean bl3 = mxGraphStructure.isSimple(mxAnalysisGraph2);
        boolean bl4 = mxGraphStructure.isConnected(mxAnalysisGraph2);
        if (!bl3) {
            if (bl2) {
                mxGraphStructure.makeSimple(mxAnalysisGraph2);
            } else {
                throw new StructuralException("Graph is not simple.");
            }
        }
        if (!bl4) {
            if (bl) {
                mxGraphStructure.makeConnected(mxAnalysisGraph2);
            } else {
                throw new StructuralException("Graph is not connected.");
            }
        }
        for (Object object : mxAnalysisGraph2.getChildEdges(mxGraph2.getDefaultParent())) {
            mxGraph2.removeCells(new Object[]{object});
            if (mxGraphStructure.isConnected(mxAnalysisGraph2)) continue;
            mxGraph2.addCell(object);
        }
    }

    public void getKnightTour(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, int n3) throws StructuralException {
        if (n < 5 || n2 < 5) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n4 = n * n2;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            mxGraph2.insertVertex(object, null, new Integer(n5).toString(), 0.0, 0.0, 25.0, 25.0);
            ++n5;
        }
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        int n6 = n3;
        int[] nArray = new int[2];
        Object object2 = objectArray[n3];
        nArray = this.getVertexGridCoords(n, n2, n3);
        arrayList.add(object2);
        Object object3 = this.getNextKnightMove(mxAnalysisGraph2, n, n2, nArray[0], nArray[1], arrayList);
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxGraph2.getView();
        while (object3 != null) {
            mxGraph2.insertEdge(object, null, null, object2, object3);
            arrayList.add(object3);
            n6 = (int)mxCostFunction2.getCost(new mxCellState(mxGraphView2, object3, null));
            nArray = this.getVertexGridCoords(n, n2, n6);
            object2 = object3;
            object3 = this.getNextKnightMove(mxAnalysisGraph2, n, n2, nArray[0], nArray[1], arrayList);
        }
        if (arrayList.size() < n4) {
            throw new StructuralException("Could not generate a correct Knight tour with size " + n + " x " + n2 + ".");
        }
    }

    private Object getNextKnightMove(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, int n3, int n4, ArrayList<Object> arrayList) {
        Object[] objectArray = this.getKnightMoveVertexes(mxAnalysisGraph2, n, n2, n3, n4);
        int n5 = 9;
        float f = 0.0f;
        Object object = null;
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxAnalysisGraph2.getGraph().getView();
        for (int i = 0; i < objectArray.length; ++i) {
            int n6 = (int)mxCostFunction2.getCost(new mxCellState(mxGraphView2, objectArray[i], null));
            int[] nArray = this.getVertexGridCoords(n, n2, n6);
            int n7 = this.getPossibleKnightMoveCount(mxAnalysisGraph2, n, n2, nArray[0], nArray[1]);
            float f2 = this.getDistanceFromGridCenter(n, n2, n6);
            if (n7 >= n5 && (n7 != n5 || !(f2 > f)) || arrayList.contains(objectArray[i])) continue;
            f = f2;
            n5 = n7;
            object = objectArray[i];
        }
        return object;
    }

    private int getPossibleKnightMoveCount(mxAnalysisGraph mxAnalysisGraph2, int n, int n2, int n3, int n4) {
        int n5 = n3 + 1;
        int n6 = n4 - 2;
        int n7 = 0;
        Object object = mxAnalysisGraph2.getGraph().getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 + 2;
        n6 = n4 - 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 + 2;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 + 1;
        n6 = n4 + 2;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 - 1;
        n6 = n4 + 2;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 - 2;
        n6 = n4 + 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 - 2;
        n6 = n4 - 1;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        n5 = n3 - 1;
        n6 = n4 - 2;
        if (n5 > 0 && n5 <= n && n6 > 0 && n6 <= n2 && mxAnalysisGraph2.getEdges(this.getVertexFromGrid(objectArray, n, n2, n5, n6), object, false, true).length == 0) {
            ++n7;
        }
        return n7;
    }

    private float getDistanceFromGridCenter(int n, int n2, int n3) {
        float f = (float)(n + 1) / 2.0f;
        float f2 = (float)(n2 + 1) / 2.0f;
        int[] nArray = this.getVertexGridCoords(n, n2, n3);
        float f3 = Math.abs(f - (float)nArray[0]);
        float f4 = Math.abs(f2 - (float)nArray[1]);
        return (float)Math.sqrt(f3 * f3 + f4 * f4);
    }

    public mxCostFunction getCostFunction() {
        return this.costFunction;
    }

    public void setCostFunction(mxCostFunction mxCostFunction2) {
        this.costFunction = mxCostFunction2;
    }
}

