/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import javax.swing.JEditorPane;
import javax.swing.text.ComponentView;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;

public class RenderAsHTML
extends SamplerResultTab
implements ResultRenderer {
    private static final String TEXT_HTML = "text/html";
    private static final EditorKit customisedEditor = new LocalHTMLEditorKit();
    private static final EditorKit defaultHtmlEditor = JEditorPane.createEditorKitForContentType("text/html");

    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.showRenderedResponse(response, sampleResult);
    }

    protected void showRenderedResponse(String response, SampleResult res) {
        this.showRenderedResponse(response, res, false);
    }

    protected void showRenderedResponse(String response, SampleResult res, boolean embedded) {
        if (response == null) {
            this.results.setText("");
            return;
        }
        int htmlIndex = response.indexOf("<HTML");
        if (htmlIndex < 0) {
            htmlIndex = response.indexOf("<html");
        }
        if (htmlIndex < 0) {
            htmlIndex = 0;
        }
        String html = response.substring(htmlIndex);
        this.results.setEditorKitForContentType(TEXT_HTML, embedded ? defaultHtmlEditor : customisedEditor);
        this.results.setContentType(TEXT_HTML);
        if (embedded) {
            this.results.getDocument().putProperty("stream", res.getURL());
        }
        this.results.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.results.setText(html);
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
    }

    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_html");
    }

    private static class LocalHTMLEditorKit
    extends HTMLEditorKit {
        private static final long serialVersionUID = -3399554318202905392L;
        private static final ViewFactory defaultFactory = new LocalHTMLFactory();

        private LocalHTMLEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return defaultFactory;
        }

        private static class LocalHTMLFactory
        extends HTMLEditorKit.HTMLFactory {
            private LocalHTMLFactory() {
            }

            public View create(Element elem) {
                Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (o instanceof HTML.Tag) {
                    HTML.Tag kind = (HTML.Tag)o;
                    if (kind == HTML.Tag.FRAME) {
                        return new ComponentView(elem);
                    }
                    if (kind == HTML.Tag.IMG) {
                        return new ComponentView(elem);
                    }
                }
                return super.create(elem);
            }
        }
    }
}

