/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.BeanShellAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;

public class BeanShellAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox resetInterpreter;
    private JTextField filename;
    private JTextField parameters;
    private JTextArea scriptField;

    public BeanShellAssertionGui() {
        this.init();
    }

    public void configure(TestElement element) {
        this.scriptField.setText(element.getPropertyAsString("BeanShellAssertion.query"));
        this.filename.setText(element.getPropertyAsString("BeanShellAssertion.filename"));
        this.parameters.setText(element.getPropertyAsString("BeanShellAssertion.parameters"));
        this.resetInterpreter.setSelected(element.getPropertyAsBoolean("BeanShellAssertion.resetInterpreter"));
        super.configure(element);
    }

    public TestElement createTestElement() {
        BeanShellAssertion sampler = new BeanShellAssertion();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        te.clear();
        this.configureTestElement(te);
        te.setProperty("BeanShellAssertion.query", this.scriptField.getText());
        te.setProperty("BeanShellAssertion.filename", this.filename.getText());
        te.setProperty("BeanShellAssertion.parameters", this.parameters.getText());
        te.setProperty((JMeterProperty)new BooleanProperty("BeanShellAssertion.resetInterpreter", this.resetInterpreter.isSelected()));
    }

    public String getLabelResource() {
        return "bsh_assertion_title";
    }

    private JPanel createFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script_file"));
        this.filename = new JTextField(10);
        this.filename.setName("BeanShellAssertion.filename");
        label.setLabelFor(this.filename);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private JPanel createResetPanel() {
        this.resetInterpreter = new JCheckBox(JMeterUtils.getResString((String)"bsh_script_reset_interpreter"));
        this.resetInterpreter.setName("BeanShellAssertion.parameters");
        JPanel resetInterpreterPanel = new JPanel(new BorderLayout());
        resetInterpreterPanel.add((Component)this.resetInterpreter, "West");
        return resetInterpreterPanel;
    }

    private JPanel createParameterPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script_parameters"));
        this.parameters = new JTextField(10);
        this.parameters.setName("BeanShellAssertion.parameters");
        label.setLabelFor(this.parameters);
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add((Component)this.parameters, "Center");
        return parameterPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createResetPanel());
        box.add(this.createParameterPanel());
        box.add(this.createFilenamePanel());
        this.add(box, "North");
        JPanel panel = this.createScriptPanel();
        this.add(panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createScriptPanel() {
        this.scriptField = new JTextArea();
        this.scriptField.setRows(4);
        this.scriptField.setLineWrap(true);
        this.scriptField.setWrapStyleWord(true);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_assertion_script"));
        label.setLabelFor(this.scriptField);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)new JScrollPane(this.scriptField), "Center");
        JTextArea explain = new JTextArea(JMeterUtils.getResString((String)"bsh_assertion_script_variables"));
        explain.setLineWrap(true);
        explain.setEditable(false);
        explain.setBackground(this.getBackground());
        panel.add((Component)explain, "South");
        return panel;
    }

    public void clearGui() {
        super.clearGui();
        this.filename.setText("");
        this.parameters.setText("");
        this.scriptField.setText("");
        this.resetInterpreter.setSelected(false);
    }
}

