/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.SMIMEAssertionTestElement;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SMIMEAssertion {
    private static final Logger log = LoggingManager.getLoggerForShortName((String)SMIMEAssertionTestElement.class.getName());

    SMIMEAssertion() {
    }

    public static AssertionResult getResult(SMIMEAssertionTestElement testElement, SampleResult response, String name) {
        SMIMEAssertion.checkForBouncycastle();
        AssertionResult res = new AssertionResult(name);
        try {
            MimeMessage msg = null;
            int msgPos = testElement.getSpecificMessagePositionAsInt();
            if (msgPos < 0) {
                SampleResult[] subResults = response.getSubResults();
                int pos = subResults.length + msgPos;
                log.debug("Getting message number: " + pos + " of " + subResults.length);
                msg = SMIMEAssertion.getMessageFromResponse(response, pos);
            } else {
                log.debug("Getting message number: " + msgPos);
                msg = SMIMEAssertion.getMessageFromResponse(response, msgPos);
            }
            SMIMESignedParser s = null;
            if (log.isDebugEnabled()) {
                log.debug("Content-type: " + msg.getContentType());
            }
            if (msg.isMimeType("multipart/signed")) {
                MimeMultipart multipart = (MimeMultipart)msg.getContent();
                s = new SMIMESignedParser(multipart);
            } else if (msg.isMimeType("application/pkcs7-mime") || msg.isMimeType("application/x-pkcs7-mime")) {
                s = new SMIMESignedParser((Part)msg);
            }
            if (null != s) {
                log.debug("Found signature");
                if (testElement.isNotSigned()) {
                    res.setFailure(true);
                    res.setFailureMessage("Mime message is signed");
                } else if (testElement.isVerifySignature() || !testElement.isSignerNoCheck()) {
                    res = SMIMEAssertion.verifySignature(testElement, s, name);
                }
            } else {
                log.debug("Did not find signature");
                if (!testElement.isNotSigned()) {
                    res.setFailure(true);
                    res.setFailureMessage("Mime message is not signed");
                }
            }
        }
        catch (MessagingException e) {
            String msg = "Cannot parse mime msg: " + e.getMessage();
            log.warn(msg, (Throwable)e);
            res.setFailure(true);
            res.setFailureMessage(msg);
        }
        catch (CMSException e) {
            res.setFailure(true);
            res.setFailureMessage("Error reading the signature: " + e.getMessage());
        }
        catch (SMIMEException e) {
            res.setFailure(true);
            res.setFailureMessage("Cannot extract signed body part from signature: " + e.getMessage());
        }
        catch (IOException e) {
            log.error("Cannot read mime message content: " + e.getMessage(), (Throwable)e);
            res.setError(true);
            res.setFailureMessage(e.getMessage());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AssertionResult verifySignature(SMIMEAssertionTestElement testElement, SMIMESignedParser s, String name) throws CMSException {
        AssertionResult res = new AssertionResult(name);
        try {
            Iterator signerIt;
            block16: {
                block17: {
                    X509Certificate certFromFile;
                    CertStore certs = s.getCertificatesAndCRLs("Collection", "BC");
                    SignerInformationStore signers = s.getSignerInfos();
                    signerIt = signers.getSigners().iterator();
                    if (!signerIt.hasNext()) break block16;
                    SignerInformation signer = (SignerInformation)signerIt.next();
                    Iterator<? extends Certificate> certIt = certs.getCertificates((CertSelector)signer.getSID()).iterator();
                    if (!certIt.hasNext()) break block17;
                    X509Certificate cert = (X509Certificate)certIt.next();
                    if (testElement.isVerifySignature() && !signer.verify(cert.getPublicKey(), "BC")) {
                        res.setFailure(true);
                        res.setFailureMessage("Signature is invalid");
                    }
                    if (testElement.isSignerCheckConstraints()) {
                        String issuer;
                        String subject;
                        List<String> emailfromCert;
                        String email;
                        BigInteger serialNbr;
                        StringBuilder failureMessage = new StringBuilder();
                        String serial = testElement.getSignerSerial();
                        if (!JOrphanUtils.isBlank((String)serial) && !(serialNbr = SMIMEAssertion.readSerialNumber(serial)).equals(cert.getSerialNumber())) {
                            res.setFailure(true);
                            failureMessage.append("Serial number ").append(serialNbr).append(" does not match serial from signer certificate: ").append(cert.getSerialNumber()).append("\n");
                        }
                        if (!JOrphanUtils.isBlank((String)(email = testElement.getSignerEmail())) && !(emailfromCert = SMIMEAssertion.getEmailFromCert(cert)).contains(email)) {
                            res.setFailure(true);
                            failureMessage.append("Email address \"").append(email).append("\" not present in signer certificate\n");
                        }
                        if ((subject = testElement.getSignerDn()).length() > 0) {
                            X500Principal certPrincipal = cert.getSubjectX500Principal();
                            log.debug(certPrincipal.getName("CANONICAL"));
                            X500Principal principal = new X500Principal(subject);
                            log.debug(principal.getName("CANONICAL"));
                            if (!principal.equals(certPrincipal)) {
                                res.setFailure(true);
                                failureMessage.append("Distinguished name of signer certificate does not match \"").append(subject).append("\"\n");
                            }
                        }
                        if ((issuer = testElement.getIssuerDn()).length() > 0) {
                            X500Principal issuerX500Principal = cert.getIssuerX500Principal();
                            log.debug(issuerX500Principal.getName("CANONICAL"));
                            X500Principal principal = new X500Principal(issuer);
                            log.debug(principal.getName("CANONICAL"));
                            if (!principal.equals(issuerX500Principal)) {
                                res.setFailure(true);
                                failureMessage.append("Issuer distinguished name of signer certificate does not match \"").append(subject).append("\"\n");
                            }
                        }
                        if (failureMessage.length() > 0) {
                            res.setFailureMessage(failureMessage.toString());
                        }
                    }
                    if (!testElement.isSignerCheckByFile()) break block16;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    BufferedInputStream inStream = null;
                    try {
                        inStream = new BufferedInputStream(new FileInputStream(testElement.getSignerCertFile()));
                        certFromFile = (X509Certificate)cf.generateCertificate(inStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inStream);
                    if (!certFromFile.equals(cert)) {
                        res.setFailure(true);
                        res.setFailureMessage("Signer certificate does not match certificate " + testElement.getSignerCertFile());
                    }
                    break block16;
                }
                res.setFailure(true);
                res.setFailureMessage("No signer certificate found in signature");
            }
            if (signerIt.hasNext()) {
                log.warn("SMIME message contains multiple signers! Checking multiple signers is not supported.");
            }
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage(), (Throwable)e);
            res.setError(true);
            res.setFailureMessage(e.getMessage());
        }
        catch (FileNotFoundException e) {
            res.setFailure(true);
            res.setFailureMessage("certificate file not found: " + e.getMessage());
        }
        return res;
    }

    private static MimeMessage getMessageFromResponse(SampleResult response, int messageNumber) throws MessagingException {
        SampleResult[] subResults = response.getSubResults();
        if (messageNumber >= subResults.length || messageNumber < 0) {
            throw new MessagingException("Message number not present in results: " + messageNumber);
        }
        SampleResult sampleResult = subResults[messageNumber];
        if (log.isDebugEnabled()) {
            log.debug("Bytes: " + sampleResult.getBytes() + " CT: " + sampleResult.getContentType());
        }
        byte[] data = sampleResult.getResponseData();
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage msg = new MimeMessage(session, (InputStream)new ByteArrayInputStream(data));
        log.debug("msg.getSize() = " + msg.getSize());
        return msg;
    }

    private static BigInteger readSerialNumber(String serialString) {
        if (serialString.startsWith("0x") || serialString.startsWith("0X")) {
            return new BigInteger(serialString.substring(2), 16);
        }
        return new BigInteger(serialString);
    }

    private static List<String> getEmailFromCert(X509Certificate cert) throws CertificateException {
        ArrayList<String> res = new ArrayList<String>();
        X509Principal subject = PrincipalUtil.getSubjectX509Principal((X509Certificate)cert);
        for (String address : subject.getValues(X509Name.EmailAddress)) {
            res.add(address);
        }
        for (List altName : X509ExtensionUtil.getSubjectAlternativeNames((X509Certificate)cert)) {
            int type = (Integer)altName.get(0);
            if (type != 1) continue;
            String address = (String)altName.get(1);
            res.add(address);
        }
        return res;
    }

    private static void checkForBouncycastle() {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

