/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.xml.XMLUtil;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public abstract class XPathFind {
    private Document document;

    public XPathFind(Document document) {
        this.document = document;
    }

    public void find(String xpath) {
        List<Node> nodes = XMLUtil.selectNodes(this.document, xpath);
        for (Node node : nodes) {
            this.match(node);
        }
    }

    protected abstract void match(Node var1);

    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("Usage: " + XPathFind.class.getName() + ": <filename> <xpath expression>");
            System.exit(1);
        }
        String fileName = argv[0];
        String xpath = argv[1];
        SAXReader reader = new SAXReader();
        Document document = reader.read(fileName);
        XPathFind finder = new XPathFind(document){

            protected void match(Node node) {
                if (node instanceof Element) {
                    Element element = (Element)node;
                    System.out.println("Element: " + element.getQualifiedName());
                    System.out.println("\tText: " + element.getText());
                    System.out.println("\tAttributes:");
                    Iterator i = element.attributeIterator();
                    while (i.hasNext()) {
                        Attribute attribute = (Attribute)i.next();
                        System.out.println("\t\t" + attribute.getName() + "=" + attribute.getValue());
                    }
                } else if (node instanceof Attribute) {
                    Attribute attribute = (Attribute)node;
                    System.out.println("Attribute: " + attribute.getName() + "=" + attribute.getValue());
                }
            }
        };
        finder.find(xpath);
    }
}

