/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class SourceSearcher {
    final HashSet<String> sourceFound = new HashSet();
    final HashSet<String> sourceNotFound = new HashSet();
    private final SourceFinder sourceFinder;

    public SourceSearcher(Project project) {
        this.sourceFinder = new SourceFinder(project);
    }

    public boolean findSource(SourceLineAnnotation srcLine) {
        if (srcLine == null) {
            return false;
        }
        String cName = srcLine.getClassName();
        if (this.sourceFound.contains(cName)) {
            return true;
        }
        if (this.sourceNotFound.contains(cName)) {
            return false;
        }
        boolean result = this.sourceFinder.hasSourceFile(srcLine);
        return result;
    }

    public boolean findSource0(SourceLineAnnotation srcLine) {
        if (srcLine == null) {
            return false;
        }
        String cName = srcLine.getClassName();
        if (this.sourceFound.contains(cName)) {
            return true;
        }
        if (this.sourceNotFound.contains(cName)) {
            return false;
        }
        try {
            InputStream in = this.sourceFinder.openSource(srcLine);
            in.close();
            this.sourceFound.add(cName);
            return true;
        }
        catch (IOException e1) {
            this.sourceNotFound.add(cName);
            return false;
        }
    }
}

