/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SortedBugCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class RebornIssues {
    BugCollection bugCollection;

    public RebornIssues() {
    }

    public RebornIssues(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setBugCollection(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public RebornIssues execute() {
        HashMap<String, LinkedList<BugInstance>> map = new HashMap<String, LinkedList<BugInstance>>();
        for (BugInstance b : this.bugCollection.getCollection()) {
            if (b.getFirstVersion() == 0L && b.getLastVersion() == -1L) continue;
            LinkedList<BugInstance> lst = (LinkedList<BugInstance>)map.get(b.getInstanceHash());
            if (lst == null) {
                lst = new LinkedList<BugInstance>();
                map.put(b.getInstanceHash(), lst);
            }
            lst.add(b);
        }
        block1: for (List lst : map.values()) {
            if (lst.size() <= 1) continue;
            TreeSet<Long> removalTimes = new TreeSet<Long>();
            TreeSet<Long> additionTimes = new TreeSet<Long>();
            String bugPattern = "XXX";
            for (BugInstance b : lst) {
                bugPattern = b.getBugPattern().getType();
                if (b.getFirstVersion() > 0L) {
                    additionTimes.add(b.getFirstVersion());
                }
                if (b.getLastVersion() == -1L) continue;
                removalTimes.add(b.getLastVersion());
            }
            Iterator aI = additionTimes.iterator();
            if (!aI.hasNext()) continue;
            long a = (Long)aI.next();
            for (Long removed : removalTimes) {
                while (a <= removed) {
                    if (!aI.hasNext()) continue block1;
                    a = (Long)aI.next();
                }
                System.out.printf("%5d %5d %s%n", removed, a, bugPattern);
            }
        }
        return this;
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        RebornIssues reborn = new RebornIssues();
        CommandLine commandLine = new CommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + RebornIssues.class.getName() + " [options] [<xml results> [<history]] ");
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        reborn.setBugCollection(bugCollection);
        reborn.execute();
    }

    static class CommandLine
    extends edu.umd.cs.findbugs.config.CommandLine {
        CommandLine() {
        }

        public void handleOption(String option, String optionalExtraPart) {
            throw new IllegalArgumentException("unknown option: " + option);
        }

        public void handleOptionWithArgument(String option, String argument) {
            throw new IllegalArgumentException("unknown option: " + option);
        }
    }
}

