/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.SimpleElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationVisitor
extends PreorderVisitor {
    private static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
    private static final String RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
    private static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    private static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
    static final boolean DEBUG = SystemProperties.getBoolean("annotation.visitor");

    public void visitAnnotation(@DottedClassName String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (DEBUG) {
            System.out.println("Annotation: " + annotationClass);
            for (Map.Entry<String, ElementValue> e : map.entrySet()) {
                System.out.println("    " + e.getKey());
                System.out.println(" -> " + e.getValue());
            }
        }
    }

    protected static String getAnnotationParameterAsString(Map<String, ElementValue> map, String parameter) {
        try {
            ElementValue ev = map.get(parameter);
            if (ev instanceof SimpleElementValue) {
                return ((SimpleElementValue)ev).getValueString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String[] getAnnotationParameterAsStringArray(Map<String, ElementValue> map, String parameter) {
        try {
            ElementValue e = map.get(parameter);
            ArrayElementValue a = (ArrayElementValue)e;
            int size = a.getElementValuesArraySize();
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = ((SimpleElementValue)a.getElementValuesArray()[i]).getValueString();
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void visitParameterAnnotation(int p, @DottedClassName String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
    }

    public void visitSyntheticParameterAnnotation(int p, boolean runtimeVisible) {
    }

    private Map<String, Object> readAnnotationValues(DataInputStream bytes, int numPairs) throws IOException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int j = 0; j < numPairs; ++j) {
            int memberNameIndex = bytes.readUnsignedShort();
            String memberName = ((ConstantUtf8)this.getConstantPool().getConstant(memberNameIndex)).getBytes();
            if (DEBUG) {
                System.out.println("memberName: " + memberName);
            }
            Object value = this.readAnnotationValue(bytes);
            if (DEBUG) {
                System.out.println(memberName + ":" + value);
            }
            values.put(memberName, value);
        }
        return values;
    }

    @DottedClassName
    private String getAnnotationName(DataInputStream bytes) throws IOException {
        int annotationNameIndex = bytes.readUnsignedShort();
        String annotationName = ((ConstantUtf8)this.getConstantPool().getConstant(annotationNameIndex)).getBytes().replace('/', '.');
        annotationName = annotationName.substring(1, annotationName.length() - 1);
        if (DEBUG) {
            System.out.println("Annotation name: " + annotationName);
        }
        return annotationName;
    }

    private Object readAnnotationValue(DataInputStream bytes) throws IOException {
        try {
            char tag = (char)bytes.readUnsignedByte();
            if (DEBUG) {
                System.out.println("tag: " + tag);
            }
            switch (tag) {
                case '[': {
                    int sz = bytes.readUnsignedShort();
                    if (DEBUG) {
                        System.out.println("Array of " + sz + " entries");
                    }
                    Object[] result = new Object[sz];
                    for (int i = 0; i < sz; ++i) {
                        result[i] = this.readAnnotationValue(bytes);
                    }
                    return result;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case 'c': 
                case 's': {
                    int cp_index = bytes.readUnsignedShort();
                    Constant c = this.getConstantPool().getConstant(cp_index);
                    switch (tag) {
                        case 'B': {
                            return (byte)((ConstantInteger)c).getBytes();
                        }
                        case 'C': {
                            return Character.valueOf((char)((ConstantInteger)c).getBytes());
                        }
                        case 'D': {
                            return new Double(((ConstantDouble)c).getBytes());
                        }
                        case 'F': {
                            return new Float(((ConstantFloat)c).getBytes());
                        }
                        case 'I': {
                            return ((ConstantInteger)c).getBytes();
                        }
                        case 'J': {
                            return ((ConstantLong)c).getBytes();
                        }
                        case 'S': {
                            return Character.valueOf((char)((ConstantInteger)c).getBytes());
                        }
                        case 'Z': {
                            return ((ConstantInteger)c).getBytes() != 0;
                        }
                        case 's': {
                            return ((ConstantUtf8)c).getBytes();
                        }
                        case 'c': {
                            String cName = ((ConstantUtf8)c).getBytes().replace('/', '.');
                            if (cName.startsWith("L") && cName.endsWith(";")) {
                                cName = cName.substring(1, cName.length() - 1);
                            }
                            if (DEBUG) {
                                System.out.println("cName: " + cName);
                            }
                            return cName;
                        }
                    }
                    if (DEBUG) {
                        System.out.println("Impossible");
                    }
                    throw new IllegalStateException("Impossible");
                }
                case '@': {
                    throw new IllegalArgumentException("Not ready to handle annotations as elements of annotations");
                }
                case 'e': {
                    int cp1 = bytes.readUnsignedShort();
                    ConstantUtf8 c1 = (ConstantUtf8)this.getConstantPool().getConstant(cp1);
                    String cName = c1.getBytes().replace('/', '.');
                    if (cName.startsWith("L") && cName.endsWith(";")) {
                        cName = cName.substring(1, cName.length() - 1);
                    }
                    int cp2 = bytes.readUnsignedShort();
                    ConstantUtf8 c2 = (ConstantUtf8)this.getConstantPool().getConstant(cp2);
                    String result = cName + "." + c2.getBytes();
                    return result;
                }
            }
            if (DEBUG) {
                System.out.println("Unexpected tag of " + tag);
            }
            throw new IllegalArgumentException("Unexpected tag of " + tag);
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                System.out.println("Problem processing annotation " + e.getMessage());
                e.printStackTrace();
            }
            throw e;
        }
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations arg0) {
        ParameterAnnotationEntry[] parameterAnnotationEntries = arg0.getParameterAnnotationEntries();
        int numParametersToMethod = this.getNumberMethodArguments();
        int offset = 0;
        if (numParametersToMethod > parameterAnnotationEntries.length) {
            offset = 1;
        }
        for (int i = 0; i < parameterAnnotationEntries.length; ++i) {
            ParameterAnnotationEntry e = parameterAnnotationEntries[i];
            for (AnnotationEntry ae : e.getAnnotationEntries()) {
                boolean runtimeVisible = ae.isRuntimeVisible();
                String name = ClassName.fromFieldSignature(ae.getAnnotationType());
                if (name == null) continue;
                name = ClassName.toDottedClassName(name);
                HashMap<String, ElementValue> map = new HashMap<String, ElementValue>();
                for (ElementValuePair ev : ae.getElementValuePairs()) {
                    map.put(ev.getNameString(), ev.getValue());
                }
                this.visitParameterAnnotation(offset + i, name, map, runtimeVisible);
            }
        }
    }

    @Override
    public void visitAnnotation(Annotations arg0) {
        for (AnnotationEntry ae : arg0.getAnnotationEntries()) {
            boolean runtimeVisible = ae.isRuntimeVisible();
            String name = ClassName.fromFieldSignature(ae.getAnnotationType());
            if (name == null) continue;
            name = ClassName.toDottedClassName(name);
            HashMap<String, ElementValue> map = new HashMap<String, ElementValue>();
            for (ElementValuePair ev : ae.getElementValuePairs()) {
                map.put(ev.getNameString(), ev.getValue());
            }
            this.visitAnnotation(name, map, runtimeVisible);
        }
    }
}

