/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.charsets.UTF8;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static Collection<Runnable> runAtShutdown;
    static final Pattern tag;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static Thread startDameonThread(Thread t) {
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static Thread runInDameonThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        return Util.startDameonThread(t);
    }

    public static Thread runInDameonThread(Runnable r) {
        Thread t = new Thread(r);
        return Util.startDameonThread(t);
    }

    public static int sign(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public static int compare(int x, int y) {
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static int compare(long x, long y) {
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static Iterable<Integer> setBitIteratable(final BitSet b) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Util.setBitIterator(b);
            }
        };
    }

    public static Iterator<Integer> setBitIterator(final BitSet b) {
        return new Iterator<Integer>(){
            int nextBit;
            {
                this.nextBit = b.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextBit >= 0;
            }

            @Override
            public Integer next() {
                int result = this.nextBit;
                this.nextBit = b.nextSetBit(this.nextBit + 1);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String repeat(String s, int number) {
        StringBuilder b = new StringBuilder(s.length() * number);
        for (int i = 0; i < number; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    public static String getNetworkErrorMessage(Throwable e) {
        if (e.getClass().getSimpleName().equals("InvalidProtocolBufferException")) {
            return "Your Internet provider may require you to log in via your web browser.";
        }
        if (e instanceof UnknownHostException) {
            return "You may not be connected to the Internet.";
        }
        return e.getClass().getSimpleName() + ": " + e.getMessage();
    }

    public static synchronized void runLogAtShutdown(Runnable r) {
        if (ShutdownLogging.LOGGING) {
            if (runAtShutdown == null) {
                runAtShutdown = new LinkedList<Runnable>();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        for (Runnable r : runAtShutdown) {
                            try {
                                r.run();
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            runAtShutdown.add(r);
        }
    }

    public static <T> Set<T> emptyOrNonnullSingleton(T t) {
        if (t == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(t);
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public static int nullSafeHashcode(@CheckForNull Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static <T> boolean nullSafeEquals(@CheckForNull T o1, @CheckForNull T o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static <T extends Comparable<? super T>> int nullSafeCompareTo(@CheckForNull T o1, @CheckForNull T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static Reader getReader(@WillCloseWhenClosed InputStream in) {
        return UTF8.reader(in);
    }

    public static Reader getFileReader(String filename) throws FileNotFoundException {
        return Util.getReader(new FileInputStream(filename));
    }

    public static Reader getFileReader(File filename) throws FileNotFoundException {
        return Util.getReader(new FileInputStream(filename));
    }

    public static Writer getWriter(@WillCloseWhenClosed OutputStream out) {
        return UTF8.writer(out);
    }

    public static Writer getFileWriter(String filename) throws FileNotFoundException {
        return Util.getWriter(new FileOutputStream(filename));
    }

    public static void closeSilently(@WillClose Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose PreparedStatement c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose ResultSet c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose Reader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose Closeable out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose ZipFile zip) {
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getXMLType(@WillNotClose InputStream in) throws IOException {
        String string;
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support mark");
        }
        in.mark(5000);
        BufferedReader r = null;
        try {
            String s;
            Matcher m;
            r = new BufferedReader(Util.getReader(in), 2000);
            int count = 0;
            do {
                if (count >= 4) throw new IOException("Didn't find xml tag");
                s = r.readLine();
                if (s != null) continue;
                throw new IOException("Didn't find xml tag");
            } while (!(m = tag.matcher(s)).find());
            string = m.group(1);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.reset();
            throw throwable;
        }
        in.reset();
        return string;
    }

    public static IOException makeIOException(String msg, Throwable cause) {
        IOException e = new IOException(msg);
        e.initCause(cause);
        return e;
    }

    private static String getFileExtension(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(lastDot + 1);
    }

    public static String getFileExtension(File f) {
        return Util.getFileExtension(f.getName().toLowerCase());
    }

    public static String getFileExtensionIgnoringGz(File f) {
        String name = f.getName().toLowerCase();
        if (name.endsWith(".gz")) {
            name = name.substring(0, name.length() - 3);
        }
        return Util.getFileExtension(name);
    }

    public static void throwIOException(String msg, Throwable cause) throws IOException {
        IOException e = new IOException(msg);
        e.initCause(cause);
        throw e;
    }

    public static <E> E first(Iterable<E> i) {
        Iterator<E> iterator = i.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("iterator has no elements");
        }
        return iterator.next();
    }

    public static String commonPrefix(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < minLength; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return s1.substring(0, i);
        }
        if (s1.length() == minLength) {
            return s1;
        }
        assert (s2.length() == minLength);
        return s2;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> m) {
        return new SetFromMap<E>(m);
    }

    public static <K, V> HashMap<K, V> makeSmallHashMap(Map<K, V> m) {
        HashMap<K, V> result = new HashMap<K, V>((int)((float)m.size() / 0.75f + 2.0f));
        result.putAll(m);
        return result;
    }

    public static <K> HashSet<K> makeSmallHashSet(Collection<K> m) {
        HashSet<K> result = new HashSet<K>((int)((float)m.size() / 0.75f + 2.0f));
        result.addAll(m);
        return result;
    }

    public static <K> ArrayList<K> makeSmallArrayList(List<K> m) {
        ArrayList<K> result = new ArrayList<K>(m.size() + 2);
        result.addAll(m);
        return result;
    }

    public static <K> Set<K> addTo(Set<K> s, K k) {
        if (s.isEmpty()) {
            return Collections.singleton(k);
        }
        if (s.contains(k)) {
            return s;
        }
        if (s instanceof HashSet) {
            s.add(k);
            return s;
        }
        HashSet<K> result = Util.makeSmallHashSet(s);
        result.add(k);
        return result;
    }

    public static <K> List<K> addTo(List<K> s, K k) {
        if (s.isEmpty()) {
            return Collections.singletonList(k);
        }
        if (!(s instanceof ArrayList)) {
            s = Util.makeSmallArrayList(s);
        }
        s.add(k);
        return s;
    }

    @Nonnull
    public static MessageDigest getMD5Digest() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Unable to get MD5 digest", e);
        }
    }

    public static boolean isPowerOfTwo(int i) {
        if (i <= 0) {
            return false;
        }
        return (i | i - 1) + 1 == 2 * i;
    }

    public static boolean isPowerOfTwo(long i) {
        if (i <= 0L) {
            return false;
        }
        return (i | i - 1L) + 1L == 2L * i;
    }

    static {
        tag = Pattern.compile("^\\s*<(\\w+)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E> {
        final Map<E, Boolean> m;
        final Set<E> s;

        SetFromMap(Map<E, Boolean> map) {
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.s.toArray(a);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this.s.equals(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.s.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.s.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.s.retainAll(c);
        }
    }

    static class ShutdownLogging {
        public static final boolean LOGGING = SystemProperties.getBoolean("findbugs.shutdownLogging");

        ShutdownLogging() {
        }
    }
}

