/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import javax.annotation.CheckForNull;
import javax.annotation.meta.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassName {
    public static boolean isMathClass(@SlashedClassName String className) {
        return className.equals("java/lang/Math") || className.equals("java/lang/StrictMath");
    }

    @DottedClassName
    public static String assertIsDotted(@DottedClassName String className) {
        assert (className.indexOf(47) == -1) : "Not dotted: " + className;
        return className;
    }

    @SlashedClassName
    public static String assertIsSlashed(@SlashedClassName String className) {
        assert (className.indexOf(46) == -1) : "Not slashed: " + className;
        return className;
    }

    public static String toSignature(@SlashedClassName String className) {
        if (className.length() == 0) {
            throw new IllegalArgumentException("classname can't be empty");
        }
        if (className.charAt(0) == '[' || className.endsWith(";")) {
            return className;
        }
        return "L" + className + ";";
    }

    @CheckForNull
    public static String getPrimitiveType(@SlashedClassName String cls) {
        if (!cls.startsWith("java/lang/")) {
            return null;
        }
        if ((cls = cls.substring(10)).equals("Integer")) {
            return "I";
        }
        if (cls.equals("Float")) {
            return "F";
        }
        if (cls.equals("Double")) {
            return "D";
        }
        if (cls.equals("Long")) {
            return "J";
        }
        if (cls.equals("Byte")) {
            return "B";
        }
        if (cls.equals("Character")) {
            return "C";
        }
        if (cls.equals("Short")) {
            return "S";
        }
        if (cls.equals("Boolean")) {
            return "Z";
        }
        return null;
    }

    @CheckForNull
    @SlashedClassName
    public static String fromFieldSignature(String signature) {
        if (signature.charAt(0) != 'L') {
            return null;
        }
        return signature.substring(1, signature.length() - 1);
    }

    @SlashedClassName
    public static String toSlashedClassName(@SlashedClassName(when=When.UNKNOWN) String className) {
        if (className.indexOf(46) >= 0) {
            return DescriptorFactory.canonicalizeString(className.replace('.', '/'));
        }
        return className;
    }

    @DottedClassName
    public static String toDottedClassName(@SlashedClassName(when=When.UNKNOWN) String className) {
        if (className.indexOf(47) >= 0) {
            return DescriptorFactory.canonicalizeString(className.replace('/', '.'));
        }
        return className;
    }

    @DottedClassName
    public static String extractPackageName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return className.substring(0, i);
    }

    public static String extractSimpleName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i > 0) {
            className = className.substring(i + 1);
        }
        className = className.replace('$', '.');
        return className;
    }

    public static boolean isValidClassName(String className) {
        return className.indexOf(40) < 0;
    }

    public static boolean isAnonymous(String className) {
        int i = className.lastIndexOf(36);
        if (i >= 0 && i + 1 < className.length()) {
            return Character.isDigit(className.charAt(i + 1));
        }
        return false;
    }

    @SlashedClassName
    public static String extractClassName(String originalName) {
        String name = originalName;
        if (name.charAt(0) != '[' && name.charAt(name.length() - 1) != ';') {
            return name;
        }
        while (name.charAt(0) == '[') {
            name = name.substring(1);
        }
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        if (name.charAt(0) == '[') {
            throw new IllegalArgumentException("Bad class name: " + originalName);
        }
        return name;
    }

    public static String extractPackagePrefix(String packageName, int count) {
        int prefixLength = 0;
        for (int dotsSeen = 0; dotsSeen < count; ++dotsSeen) {
            int p = packageName.indexOf(46, prefixLength);
            if (p < 0) {
                return packageName;
            }
            prefixLength = p + 1;
        }
        if (prefixLength == 0) {
            return "";
        }
        return packageName.substring(0, prefixLength - 1);
    }

    public static boolean matchedPrefixes(String[] classSearchStrings, @DottedClassName String className) {
        String[] pp = classSearchStrings;
        if (pp == null || pp.length == 0) {
            return true;
        }
        for (String p : pp) {
            if (p.length() <= 0 || className.indexOf(p) < 0) continue;
            return true;
        }
        return false;
    }

    @SlashedClassName
    public static String toSlashedClassName(Class<?> class1) {
        return ClassName.toSlashedClassName(class1.getName());
    }
}

