/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import edu.umd.cs.findbugs.gui2.MainFrame;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigableTextPane
extends JTextPane {
    public NavigableTextPane() {
    }

    public NavigableTextPane(StyledDocument doc) {
        super(doc);
    }

    private int parentHeight() {
        Container parent = this.getParent();
        if (parent != null) {
            return parent.getHeight();
        }
        return this.getHeight();
    }

    public int getLineOffset(int line) throws BadLocationException {
        return this.lineToOffset(line);
    }

    private int lineToOffset(int line) throws BadLocationException {
        Document d = this.getDocument();
        try {
            Element element = d.getDefaultRootElement().getElement(line - 1);
            if (element == null) {
                throw new BadLocationException("line " + line + " does not exist", -line);
            }
            return element.getStartOffset();
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            BadLocationException ble = new BadLocationException("line " + line + " does not exist", -line);
            ble.initCause(aioobe);
            throw ble;
        }
    }

    private int offsetToY(int offset) throws BadLocationException {
        Rectangle r = this.modelToView(offset);
        return r.y;
    }

    private int lineToY(int line) throws BadLocationException {
        return this.offsetToY(this.lineToOffset(line));
    }

    private void scrollYToVisibleImpl(int y, int margin) {
        final Rectangle r = new Rectangle(0, y - margin, 4, 2 * margin);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NavigableTextPane.this.scrollRectToVisible(r);
            }
        });
    }

    private void scrollLineToVisibleImpl(int line, int margin) {
        block2: {
            try {
                int y = this.lineToY(line);
                this.scrollYToVisibleImpl(y, margin);
            }
            catch (BadLocationException ble) {
                if (!MainFrame.GUI2_DEBUG) break block2;
                ble.printStackTrace();
            }
        }
    }

    public void scrollLineToVisible(int line, int margin) {
        int maxMargin = (this.parentHeight() - 20) / 2;
        if (margin > maxMargin) {
            margin = Math.max(0, maxMargin);
        }
        this.scrollLineToVisibleImpl(line, margin);
    }

    public void scrollLineToVisible(int line) {
        int margin = this.parentHeight() / 3;
        this.scrollLineToVisibleImpl(line, margin);
    }

    public void scrollLinesToVisible(int startLine, int endLine, Collection<Integer> otherLines) {
        int endY;
        int startY;
        try {
            startY = this.lineToY(startLine);
        }
        catch (BadLocationException ble) {
            if (MainFrame.GUI2_DEBUG) {
                ble.printStackTrace();
            }
            return;
        }
        try {
            endY = this.lineToY(endLine);
        }
        catch (BadLocationException ble) {
            endY = startY;
        }
        int max = this.parentHeight() - 0;
        if (endY - startY > max) {
            endY = startY + max;
        } else if (otherLines != null && otherLines.size() > 0) {
            int origin = startY + endY / 2;
            PriorityQueue<Integer> pq = new PriorityQueue<Integer>(otherLines.size(), new DistanceComparator(origin));
            for (int line : otherLines) {
                int otherY;
                try {
                    otherY = this.lineToY(line);
                }
                catch (BadLocationException ble) {
                    continue;
                }
                pq.add(otherY);
            }
            while (!pq.isEmpty()) {
                int y = (Integer)pq.remove();
                int lo = Math.min(startY, y);
                int hi = Math.max(endY, y);
                if (hi - lo > max) break;
                startY = lo;
                endY = hi;
            }
        }
        if (endY - startY > max) {
            endY = startY + max;
        }
        this.scrollYToVisibleImpl((startY + endY) / 2, max / 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DistanceComparator
    implements Comparator<Integer>,
    Serializable {
        private final int origin;

        public DistanceComparator(int origin) {
            this.origin = origin;
        }

        @Override
        public int compare(Integer a, Integer b) {
            return Math.abs(b - this.origin) - Math.abs(a - this.origin);
        }
    }
}

