/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SwitchHandler;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.visitclass.Util;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;

public class SwitchFallthrough
extends OpcodeStackDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("switchFallthrough.debug");
    private static final boolean LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT = SystemProperties.getBoolean("findbugs.sf.comment");
    private SwitchHandler switchHdlr;
    private boolean reachable;
    private final BugAccumulator bugAccumulator;
    private int lastPC;
    private int biggestJumpTarget;
    private final BitSet potentiallyDeadStores = new BitSet();
    private final Set<XField> potentiallyDeadFields = new HashSet<XField>();
    private BitSet potentiallyDeadStoresFromBeforeFallthrough = new BitSet();
    private Set<XField> potentiallyDeadFieldsFromBeforeFallthrough = new HashSet<XField>();
    private LocalVariableAnnotation deadStore = null;
    private int priority;
    private int fallthroughDistance;
    Collection<SourceLineAnnotation> found = new LinkedList<SourceLineAnnotation>();
    XClass enumType = null;
    boolean justSawHashcode;

    public SwitchFallthrough(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept(this);
    }

    public void visit(Code obj) {
        if (DEBUG) {
            System.out.printf("%nVisiting %s%n", this.getMethodDescriptor());
        }
        this.reachable = false;
        this.lastPC = 0;
        this.biggestJumpTarget = -1;
        this.found.clear();
        this.switchHdlr = new SwitchHandler();
        this.clearAllDeadStores();
        this.deadStore = null;
        this.priority = 2;
        this.fallthroughDistance = 1000;
        this.enumType = null;
        super.visit(obj);
        this.enumType = null;
        if (!this.found.isEmpty()) {
            if (this.found.size() >= 4 && this.priority == 2) {
                this.priority = 3;
            }
            for (SourceLineAnnotation s : this.found) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "SF_SWITCH_FALLTHROUGH", this.priority).addClassAndMethod(this), s);
            }
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private void foundSwitchNoDefault(SourceLineAnnotation s) {
        LineNumberTable table = this.getCode().getLineNumberTable();
        if (table != null) {
            int startLine = s.getStartLine();
            int prev = Integer.MIN_VALUE;
            for (LineNumber ln : table.getLineNumberTable()) {
                int thisLineNumber = ln.getLineNumber();
                if (thisLineNumber >= startLine || thisLineNumber <= prev || ln.getStartPC() >= s.getStartBytecode()) continue;
                prev = thisLineNumber;
            }
            int diff = startLine - prev;
            if (diff > 5) {
                return;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, "SF_SWITCH_NO_DEFAULT", 2).addClassAndMethod(this), s);
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item obj;
        boolean isDefaultOffset = this.switchHdlr.getDefaultOffset() == this.getPC();
        boolean isCaseOffset = this.switchHdlr.isOnSwitchOffset(this);
        if (DEBUG) {
            if (seen == 167) {
                System.out.printf("%4d: goto %-7d %s %s %s %d%n", this.getPC(), this.getBranchTarget(), this.reachable, isCaseOffset, isDefaultOffset, this.switchHdlr.stackSize());
            } else {
                System.out.printf("%4d: %-12s %s %s %s %d%n", this.getPC(), OPCODE_NAMES[seen], this.reachable, isCaseOffset, isDefaultOffset, this.switchHdlr.stackSize());
            }
        }
        if (this.reachable && (isDefaultOffset || isCaseOffset)) {
            if (DEBUG) {
                System.out.println("Fallthrough at : " + this.getPC() + ": " + OPCODE_NAMES[seen]);
            }
            this.fallthroughDistance = 0;
            this.potentiallyDeadStoresFromBeforeFallthrough = (BitSet)this.potentiallyDeadStores.clone();
            this.potentiallyDeadFieldsFromBeforeFallthrough = new HashSet<XField>(this.potentiallyDeadFields);
            if (!this.hasFallThruComment(this.lastPC + 1, this.getPC() - 1)) {
                SourceLineAnnotation sourceLineAnnotation;
                if (!isDefaultOffset) {
                    sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(this.getClassContext(), this, this.lastPC, this.getPC());
                    this.found.add(sourceLineAnnotation);
                } else if (this.getPC() >= this.biggestJumpTarget) {
                    sourceLineAnnotation = this.switchHdlr.getCurrentSwitchStatement(this);
                    if (DEBUG) {
                        System.out.printf("Found fallthrough to default offset at %d (BJT is %d)%n", this.getPC(), this.biggestJumpTarget);
                    }
                    this.foundSwitchNoDefault(sourceLineAnnotation);
                }
            }
        }
        if (SwitchFallthrough.isBranch(seen) || SwitchFallthrough.isSwitch(seen) || seen == 167 || seen == 176 || seen == 172 || seen == 177 || seen == 173 || seen == 175 || seen == 174) {
            this.clearAllDeadStores();
        }
        if (seen == 180 && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item top = this.stack.getStackItem(0);
            if (top.getRegisterNumber() == 0) {
                this.potentiallyDeadFields.remove(this.getXFieldOperand());
            }
        } else if (seen == 181 && this.stack.getStackDepth() >= 2 && (obj = this.stack.getStackItem(1)).getRegisterNumber() == 0) {
            XField f = this.getXFieldOperand();
            if (this.potentiallyDeadFields.contains(f) && this.potentiallyDeadFieldsFromBeforeFallthrough.contains(f)) {
                this.priority = 1;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "SF_DEAD_STORE_DUE_TO_SWITCH_FALLTHROUGH", this.priority).addClassAndMethod(this).addField(f), this);
            }
            this.potentiallyDeadFields.add(f);
        }
        if (seen == 191) {
            int sz = Util.getSizeOfSurroundingTryBlock(this.getMethod(), (String)null, this.getPC());
            if (sz == Integer.MAX_VALUE) {
                BitSet dead = new BitSet();
                dead.or(this.potentiallyDeadStores);
                dead.and(this.potentiallyDeadStoresFromBeforeFallthrough);
                if (dead.cardinality() > 0) {
                    int register = dead.nextSetBit(0);
                    this.priority = 1;
                    this.deadStore = LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), register, this.getPC() - 1, this.getPC());
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "SF_DEAD_STORE_DUE_TO_SWITCH_FALLTHROUGH_TO_THROW", this.priority).addClassAndMethod(this).add(this.deadStore), this);
                }
            }
            this.clearAllDeadStores();
        }
        if (this.isRegisterLoad()) {
            this.potentiallyDeadStores.clear(this.getRegisterOperand());
        } else if (this.isRegisterStore() && !this.atCatchBlock()) {
            int register = this.getRegisterOperand();
            if (this.potentiallyDeadStores.get(register) && this.potentiallyDeadStoresFromBeforeFallthrough.get(register)) {
                this.priority = 1;
                this.deadStore = LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), register, this.getPC() - 1, this.getPC());
                this.bugAccumulator.accumulateBug(new BugInstance(this, "SF_DEAD_STORE_DUE_TO_SWITCH_FALLTHROUGH", this.priority).addClassAndMethod(this).add(this.deadStore), this);
            }
            this.potentiallyDeadStores.set(register);
        }
        if (seen == 182 && this.getNameConstantOperand().equals("ordinal") && this.getSigConstantOperand().equals("()I")) {
            XClass c = this.getXClassOperand();
            if (c != null) {
                ClassDescriptor superclassDescriptor = c.getSuperclassDescriptor();
                if (superclassDescriptor != null && superclassDescriptor.getClassName().equals("java/lang/Enum")) {
                    this.enumType = c;
                }
                if (DEBUG) {
                    System.out.println("Saw " + this.enumType + ".ordinal()");
                }
            }
        } else if (seen != 170 && seen != 171 && seen != 46) {
            this.enumType = null;
        }
        switch (seen) {
            case 170: 
            case 171: {
                if (this.justSawHashcode) break;
                this.reachable = false;
                this.biggestJumpTarget = -1;
                this.switchHdlr.enterSwitch(this, this.enumType);
                if (!DEBUG) break;
                System.out.printf("  entered switch, default is %d%n", this.switchHdlr.getDefaultOffset());
                break;
            }
            case 167: 
            case 200: {
                if (this.biggestJumpTarget < this.getBranchTarget()) {
                    this.biggestJumpTarget = this.getBranchTarget();
                    if (DEBUG) {
                        System.out.printf("  Setting BJT to %d%n", this.biggestJumpTarget);
                    }
                }
                this.reachable = false;
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.reachable = false;
                break;
            }
            case 184: {
                this.reachable = !"exit".equals(this.getNameConstantOperand()) || !"java/lang/System".equals(this.getClassConstantOperand());
                break;
            }
            default: {
                this.reachable = true;
            }
        }
        this.justSawHashcode = seen == 182 && this.getNameConstantOperand().equals("hashCode") && this.getSigConstantOperand().equals("()I");
        this.lastPC = this.getPC();
        ++this.fallthroughDistance;
    }

    private void clearAllDeadStores() {
        this.potentiallyDeadStores.clear();
        this.potentiallyDeadStoresFromBeforeFallthrough.clear();
        this.potentiallyDeadFields.clear();
        this.potentiallyDeadFieldsFromBeforeFallthrough.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFallThruComment(int startPC, int endPC) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            if (SwitchFallthrough.LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT == false) return false;
                            r = null;
                            try {
                                try {
                                    srcLine = SourceLineAnnotation.fromVisitedInstructionRange(this, this.lastPC, this.getPC());
                                    sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
                                    sourceFile = sourceFinder.findSourceFile(srcLine.getPackageName(), srcLine.getSourceFile());
                                    startLine = srcLine.getStartLine();
                                    numLines = srcLine.getEndLine() - startLine - 1;
                                    if (numLines <= 0) {
                                        var9_10 = false;
                                        var13_12 = null;
                                        break block17;
                                    }
                                    r = UTF8.bufferedReader(sourceFile.getInputStream());
                                    for (i = 0; i < startLine; ++i) {
                                        line = r.readLine();
                                        if (line != null) continue;
                                        var11_27 = false;
                                        break block18;
                                    }
                                    for (i = 0; i < numLines; ++i) {
                                        line = r.readLine();
                                        if (line == null) {
                                            var11_28 = false;
                                            break block19;
                                        }
                                        if ((line = line.toLowerCase()).indexOf("fall") < 0 && line.indexOf("nobreak") < 0) continue;
                                        var11_29 = true;
                                        break block20;
                                    }
                                    break block21;
                                }
                                catch (IOException ioe) {
                                    var13_17 = null;
                                    try {
                                        if (r == null) return false;
                                        r.close();
                                        return false;
                                    }
                                    catch (IOException ioe) {
                                        return false;
                                    }
                                }
                            }
                            catch (Throwable var12_30) {
                                var13_18 = null;
                                ** try [egrp 2[TRYBLOCK] [12 : 221->232)] { 
lbl46:
                                // 1 sources

                                if (r == null) throw var12_30;
                                r.close();
                                throw var12_30;
lbl49:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                throw var12_30;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [12 : 221->232)] { 
lbl54:
                        // 1 sources

                        if (r == null) return var9_10;
                        r.close();
                        return var9_10;
lbl57:
                        // 1 sources

                        catch (IOException ioe) {
                            // empty catch block
                        }
                        return var9_10;
                    }
                    var13_13 = null;
                    ** try [egrp 2[TRYBLOCK] [12 : 221->232)] { 
lbl63:
                    // 1 sources

                    if (r == null) return var11_27;
                    r.close();
                    return var11_27;
lbl66:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var11_27;
                }
                var13_14 = null;
                ** try [egrp 2[TRYBLOCK] [12 : 221->232)] { 
lbl72:
                // 1 sources

                if (r == null) return var11_28;
                r.close();
                return var11_28;
lbl75:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return var11_28;
            }
            var13_15 = null;
            ** try [egrp 2[TRYBLOCK] [12 : 221->232)] { 
lbl81:
            // 1 sources

            if (r == null) return var11_29;
            r.close();
            return var11_29;
lbl84:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return var11_29;
        }
        var13_16 = null;
        try {}
        catch (IOException ioe) {}
        if (r == null) return false;
        r.close();
        return false;
        return false;
    }
}

