/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.type.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class SerializableIdiom
extends OpcodeStackDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("se.debug");
    static final boolean reportTransientFieldOfNonSerializableClass = SystemProperties.getBoolean("reportTransientFieldOfNonSerializableClass");
    boolean sawSerialVersionUID;
    boolean isSerializable;
    boolean implementsSerializableDirectly;
    boolean isExternalizable;
    boolean isGUIClass;
    boolean isEjbImplClass;
    boolean isJSPClass;
    boolean foundSynthetic;
    boolean seenTransientField;
    boolean foundSynchronizedMethods;
    boolean writeObjectIsSynchronized;
    private final BugReporter bugReporter;
    boolean isAbstract;
    private final List<BugInstance> fieldWarningList = new LinkedList<BugInstance>();
    private final HashMap<String, XField> fieldsThatMightBeAProblem = new HashMap();
    private final HashMap<XField, Integer> transientFieldsUpdates = new HashMap();
    private final HashSet<XField> transientFieldsSetInConstructor = new HashSet();
    private final HashSet<XField> transientFieldsSetToDefaultValueInConstructor = new HashSet();
    private boolean sawReadExternal;
    private boolean sawWriteExternal;
    private boolean sawReadObject;
    private boolean sawReadResolve;
    private boolean sawWriteObject;
    private boolean superClassImplementsSerializable;
    private boolean superClassHasReadObject;
    private boolean hasPublicVoidConstructor;
    private boolean superClassHasVoidConstructor;
    private boolean directlyImplementsExternalizable;
    static final Pattern anonymousInnerClassNamePattern = Pattern.compile(".+\\$\\d+");
    boolean isAnonymousInnerClass;
    boolean innerClassHasOuterInstance;
    private boolean isEnum;

    public SerializableIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept(this);
        this.flush();
    }

    private void flush() {
        if (!(this.isAbstract || this.sawReadExternal && this.sawWriteExternal || this.sawReadObject && this.sawWriteObject)) {
            for (BugInstance aFieldWarningList : this.fieldWarningList) {
                this.bugReporter.reportBug(aFieldWarningList);
            }
        }
        this.fieldWarningList.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void visit(JavaClass obj) {
        String[] interface_names;
        String superClassname = obj.getSuperclassName();
        this.isEnum = superClassname.equals("java.lang.Enum");
        if (this.isEnum) {
            return;
        }
        int flags = obj.getAccessFlags();
        this.isAbstract = (flags & 0x400) != 0 || (flags & 0x200) != 0;
        this.isAnonymousInnerClass = anonymousInnerClassNamePattern.matcher(this.getClassName()).matches();
        this.innerClassHasOuterInstance = false;
        for (Field f : obj.getFields()) {
            if (!f.getName().equals("this$0")) continue;
            this.innerClassHasOuterInstance = true;
            break;
        }
        this.sawSerialVersionUID = false;
        this.implementsSerializableDirectly = false;
        this.isSerializable = false;
        this.isExternalizable = false;
        this.directlyImplementsExternalizable = false;
        this.isGUIClass = false;
        this.isEjbImplClass = false;
        this.isJSPClass = false;
        this.seenTransientField = false;
        this.fieldsThatMightBeAProblem.clear();
        this.transientFieldsUpdates.clear();
        this.transientFieldsSetInConstructor.clear();
        this.transientFieldsSetToDefaultValueInConstructor.clear();
        for (String string : interface_names = obj.getInterfaceNames()) {
            if (string.equals("java.io.Externalizable")) {
                this.directlyImplementsExternalizable = true;
                this.isExternalizable = true;
                if (!DEBUG) continue;
                System.out.println("Directly implements Externalizable: " + this.getClassName());
                continue;
            }
            if (!string.equals("java.io.Serializable")) continue;
            this.implementsSerializableDirectly = true;
            this.isSerializable = true;
            if (!DEBUG) break;
            System.out.println("Directly implements Serializable: " + this.getClassName());
            break;
        }
        if (!this.isSerializable) {
            if (Subtypes2.instanceOf(obj, "java.io.Externalizable")) {
                this.isExternalizable = true;
                if (DEBUG) {
                    System.out.println("Indirectly implements Externalizable: " + this.getClassName());
                }
            }
            if (Subtypes2.instanceOf(obj, "java.io.Serializable")) {
                this.isSerializable = true;
                if (DEBUG) {
                    System.out.println("Indirectly implements Serializable: " + this.getClassName());
                }
            }
        }
        this.hasPublicVoidConstructor = false;
        this.superClassHasVoidConstructor = true;
        this.superClassHasReadObject = false;
        this.superClassImplementsSerializable = this.isSerializable && !this.implementsSerializableDirectly;
        ClassDescriptor superclassDescriptor = this.getXClass().getSuperclassDescriptor();
        if (superclassDescriptor != null) {
            try {
                XClass superXClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, superclassDescriptor);
                if (superXClass != null) {
                    this.superClassImplementsSerializable = AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(superXClass.getClassDescriptor(), DescriptorFactory.createClassDescriptor(Serializable.class));
                    this.superClassHasVoidConstructor = false;
                    for (XMethod xMethod : superXClass.getXMethods()) {
                        if (xMethod.getName().equals("<init>") && xMethod.getSignature().equals("()V") && !xMethod.isPrivate()) {
                            this.superClassHasVoidConstructor = true;
                        }
                        if (!xMethod.getName().equals("readObject") || !xMethod.getSignature().equals("(Ljava/io/ObjectInputStream;)V") || !xMethod.isPrivate()) continue;
                        this.superClassHasReadObject = true;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error while analyzing " + obj.getClassName(), e);
            }
        }
        this.isGUIClass = false;
        this.isEjbImplClass = false;
        this.isEjbImplClass = Subtypes2.instanceOf(obj, "javax.ejb.SessionBean");
        this.isJSPClass = Subtypes2.isJSP(obj);
        boolean bl = this.isGUIClass = Subtypes2.instanceOf(obj, "java.lang.Throwable") || Subtypes2.instanceOf(obj, "java.awt.Component") || Subtypes2.instanceOf(obj, "java.awt.Component$AccessibleAWTComponent") || Subtypes2.instanceOf(obj, "java.awt.event.ActionListener") || Subtypes2.instanceOf(obj, "java.util.EventListener");
        if (!this.isGUIClass) {
            for (JavaClass o = obj; o != null; o = o.getSuperClass()) {
                if (o.getClassName().startsWith("java.awt") || o.getClassName().startsWith("javax.swing")) {
                    this.isGUIClass = true;
                    break;
                }
                try {
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                    break;
                }
            }
        }
        this.foundSynthetic = false;
        this.foundSynchronizedMethods = false;
        this.writeObjectIsSynchronized = false;
        this.sawWriteObject = false;
        this.sawReadResolve = false;
        this.sawReadObject = false;
        this.sawWriteExternal = false;
        this.sawReadExternal = false;
        if (this.isSerializable) {
            void var8_24;
            void var8_22;
            FieldOrMethod[] arr$ = obj.getMethods();
            int len$ = arr$.length;
            boolean bl2 = false;
            while (var8_22 < len$) {
                Method method = arr$[var8_22];
                if (method.getName().equals("readObject") && method.getSignature().equals("(Ljava/io/ObjectInputStream;)V")) {
                    this.sawReadObject = true;
                } else if (method.getName().equals("readResolve") && method.getSignature().startsWith("()")) {
                    this.sawReadResolve = true;
                } else if (method.getName().equals("readObjectNoData") && method.getSignature().equals("()V")) {
                    this.sawReadObject = true;
                } else if (method.getName().equals("writeObject") && method.getSignature().equals("(Ljava/io/ObjectOutputStream;)V")) {
                    this.sawWriteObject = true;
                }
                ++var8_22;
            }
            arr$ = obj.getFields();
            len$ = arr$.length;
            boolean bl3 = false;
            while (var8_24 < len$) {
                FieldOrMethod fieldOrMethod = arr$[var8_24];
                if (fieldOrMethod.isTransient()) {
                    this.seenTransientField = true;
                }
                ++var8_24;
            }
        }
    }

    private boolean strongEvidenceForIntendedSerialization() {
        return this.implementsSerializableDirectly || this.sawReadObject || this.sawReadResolve || this.sawWriteObject || this.seenTransientField || AnalysisContext.currentAnalysisContext().getUnreadFieldsData().existsStrongEvidenceForIntendedSerialization(this.getClassDescriptor());
    }

    public void visitAfter(JavaClass obj) {
        int priority;
        if (this.isEnum) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.getDottedClassName());
            System.out.println("  hasPublicVoidConstructor: " + this.hasPublicVoidConstructor);
            System.out.println("  superClassHasVoidConstructor: " + this.superClassHasVoidConstructor);
            System.out.println("  isExternalizable: " + this.isExternalizable);
            System.out.println("  isSerializable: " + this.isSerializable);
            System.out.println("  isAbstract: " + this.isAbstract);
            System.out.println("  superClassImplementsSerializable: " + this.superClassImplementsSerializable);
            System.out.println("  isGUIClass: " + this.isGUIClass);
            System.out.println("  isEjbImplClass: " + this.isEjbImplClass);
            System.out.println("  isJSPClass: " + this.isJSPClass);
        }
        if (this.isSerializable && !this.sawReadObject && !this.sawReadResolve && this.seenTransientField && !this.superClassHasReadObject) {
            for (Map.Entry<XField, Integer> e : this.transientFieldsUpdates.entrySet()) {
                XField fieldX = e.getKey();
                int priority2 = 2;
                if (this.transientFieldsSetInConstructor.contains(e.getKey())) {
                    --priority2;
                }
                if (this.isGUIClass) {
                    ++priority2;
                }
                if (this.isEjbImplClass) {
                    ++priority2;
                }
                if (this.isJSPClass) {
                    ++priority2;
                }
                if (e.getValue() < 3) {
                    ++priority2;
                }
                if (this.transientFieldsSetToDefaultValueInConstructor.contains(e.getKey())) {
                    ++priority2;
                }
                if (obj.isAbstract() && ++priority2 < 3) {
                    priority2 = 3;
                }
                try {
                    double isSerializable = DeepSubtypeAnalysis.isDeepSerializable(fieldX.getSignature());
                    if (isSerializable < 0.6) {
                        ++priority2;
                    }
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
                this.bugReporter.reportBug(new BugInstance(this, "SE_TRANSIENT_FIELD_NOT_RESTORED", priority2).addClass(this.getThisClass()).addField(fieldX));
            }
        }
        if (this.isSerializable && !this.isExternalizable && !this.superClassHasVoidConstructor && !this.superClassImplementsSerializable) {
            int priority3;
            int n = this.implementsSerializableDirectly || this.seenTransientField ? 1 : (priority3 = this.sawSerialVersionUID ? 2 : 3);
            if (this.isGUIClass || this.isEjbImplClass || this.isJSPClass) {
                ++priority3;
            }
            this.bugReporter.reportBug(new BugInstance(this, "SE_NO_SUITABLE_CONSTRUCTOR", priority3).addClass(this.getThisClass().getClassName()));
        }
        int n = priority = this.isGUIClass || this.isEjbImplClass || this.isJSPClass ? 3 : 2;
        if (obj.getClassName().endsWith("_Stub")) {
            ++priority;
        }
        if (this.isExternalizable && !this.hasPublicVoidConstructor && !this.isAbstract) {
            this.bugReporter.reportBug(new BugInstance(this, "SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION", this.directlyImplementsExternalizable ? 1 : 2).addClass(this.getThisClass().getClassName()));
        }
        if (!this.foundSynthetic) {
            ++priority;
        }
        if (this.seenTransientField) {
            --priority;
        }
        if (!(this.isAnonymousInnerClass || this.isExternalizable || this.isGUIClass || obj.isAbstract() || !this.isSerializable || this.isAbstract || this.sawSerialVersionUID || this.isEjbImplClass || this.isJSPClass)) {
            this.bugReporter.reportBug(new BugInstance(this, "SE_NO_SERIALVERSIONID", priority).addClass(this));
        }
        if (this.writeObjectIsSynchronized && !this.foundSynchronizedMethods) {
            this.bugReporter.reportBug(new BugInstance(this, "WS_WRITEOBJECT_SYNC", 3).addClass(this));
        }
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int accessFlags = obj.getAccessFlags();
        boolean bl = isSynchronized = (accessFlags & 0x20) != 0;
        if (this.getMethodName().equals("<init>") && this.getMethodSig().equals("()V") && (accessFlags & 1) != 0) {
            this.hasPublicVoidConstructor = true;
        }
        if (!this.getMethodName().equals("<init>") && this.isSynthetic(obj)) {
            this.foundSynthetic = true;
        }
        if (this.getMethodName().equals("readExternal") && this.getMethodSig().equals("(Ljava/io/ObjectInput;)V")) {
            this.sawReadExternal = true;
            if (DEBUG && !obj.isPrivate()) {
                System.out.println("Non-private readExternal method in: " + this.getDottedClassName());
            }
        } else if (this.getMethodName().equals("writeExternal") && this.getMethodSig().equals("(Ljava/io/Objectoutput;)V")) {
            this.sawWriteExternal = true;
            if (DEBUG && !obj.isPrivate()) {
                System.out.println("Non-private writeExternal method in: " + this.getDottedClassName());
            }
        } else if (this.getMethodName().equals("readResolve") && this.getMethodSig().startsWith("()") && this.isSerializable) {
            this.sawReadResolve = true;
            if (!this.getMethodSig().equals("()Ljava/lang/Object;")) {
                this.bugReporter.reportBug(new BugInstance(this, "SE_READ_RESOLVE_MUST_RETURN_OBJECT", 1).addClassAndMethod(this));
            } else if (obj.isStatic()) {
                this.bugReporter.reportBug(new BugInstance(this, "SE_READ_RESOLVE_IS_STATIC", 1).addClassAndMethod(this));
            } else if (obj.isPrivate()) {
                try {
                    Set<ClassDescriptor> subtypes = AnalysisContext.currentAnalysisContext().getSubtypes2().getSubtypes(this.getClassDescriptor());
                    if (subtypes.size() > 1) {
                        BugInstance bug = new BugInstance(this, "SE_PRIVATE_READ_RESOLVE_NOT_INHERITED", 2).addClassAndMethod(this);
                        boolean nasty = false;
                        for (ClassDescriptor subclass : subtypes) {
                            XClass xSub;
                            if (subclass.equals(this.getClassDescriptor()) || (xSub = AnalysisContext.currentXFactory().getXClass(subclass)) == null || xSub.findMethod("readResolve", "()Ljava/lang/Object;", false) != null || xSub.findMethod("writeReplace", "()Ljava/lang/Object;", false) != null) continue;
                            bug.addClass(subclass).describe("CLASS_SUBCLASS");
                            nasty = true;
                        }
                        if (nasty) {
                            bug.setPriority(1);
                        } else if (!this.getThisClass().isPublic()) {
                            bug.setPriority(3);
                        }
                        this.bugReporter.reportBug(bug);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
            }
        } else if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance(this, "SE_METHOD_MUST_BE_PRIVATE", this.isExternalizable ? 2 : 1).addClassAndMethod(this));
            }
        } else if (this.getMethodName().equals("readObjectNoData") && this.getMethodSig().equals("()V") && this.isSerializable) {
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance(this, "SE_METHOD_MUST_BE_PRIVATE", this.isExternalizable ? 2 : 1).addClassAndMethod(this));
            }
        } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
            this.sawWriteObject = true;
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance(this, "SE_METHOD_MUST_BE_PRIVATE", this.isExternalizable ? 2 : 1).addClassAndMethod(this));
            }
        }
        if (isSynchronized) {
            if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
                this.bugReporter.reportBug(new BugInstance(this, "RS_READOBJECT_SYNC", this.isExternalizable ? 3 : 2).addClassAndMethod(this));
            } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
                this.writeObjectIsSynchronized = true;
            } else {
                this.foundSynchronizedMethods = true;
            }
        }
        super.visit(obj);
    }

    boolean isSynthetic(FieldOrMethod obj) {
        Attribute[] a;
        for (Attribute aA : a = obj.getAttributes()) {
            if (!(aA instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public void visit(Code obj) {
        if (this.isSerializable) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        XField xField;
        if (seen == 181 && (xField = this.getXFieldOperand()) != null && xField.getClassDescriptor().equals(this.getClassDescriptor())) {
            Object constant;
            OpcodeStack.Item first = this.stack.getStackItem(0);
            boolean isPutOfDefaultValue = first.isNull();
            if (!isPutOfDefaultValue && first.getConstant() != null && ((constant = first.getConstant()) instanceof Number && ((Number)constant).intValue() == 0 || constant.equals(Boolean.FALSE))) {
                isPutOfDefaultValue = true;
            }
            if (isPutOfDefaultValue) {
                if (this.getMethodName().equals("<init>")) {
                    this.transientFieldsSetToDefaultValueInConstructor.add(xField);
                }
            } else {
                String nameOfField = this.getNameConstantOperand();
                if (this.transientFieldsUpdates.containsKey(xField)) {
                    if (this.getMethodName().equals("<init>")) {
                        this.transientFieldsSetInConstructor.add(xField);
                    } else {
                        this.transientFieldsUpdates.put(xField, this.transientFieldsUpdates.get(xField) + 1);
                    }
                } else if (this.fieldsThatMightBeAProblem.containsKey(nameOfField)) {
                    try {
                        String genSig;
                        XField f;
                        String sig;
                        JavaClass classStored = first.getJavaClass();
                        if (classStored == null) {
                            return;
                        }
                        double isSerializable = DeepSubtypeAnalysis.isDeepSerializable(classStored);
                        if (isSerializable <= 0.2 && !(sig = (f = this.fieldsThatMightBeAProblem.get(nameOfField)).getSignature()).equals(genSig = "L" + classStored.getClassName().replace('.', '/') + ";")) {
                            double bias = 0.0;
                            if (!this.getMethodName().equals("<init>")) {
                                bias = 1.0;
                            }
                            int priority = this.computePriority(isSerializable, bias);
                            this.fieldWarningList.add(new BugInstance(this, "SE_BAD_FIELD_STORE", priority).addClass(this.getThisClass().getClassName()).addField(f).addType(genSig).describe("TYPE_FOUND").addSourceLine(this));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void visit(Field obj) {
        ClassDescriptor fieldType;
        int flags = obj.getAccessFlags();
        String genericSignature = obj.getGenericSignature();
        if (genericSignature != null && genericSignature.startsWith("T")) {
            return;
        }
        FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
        OpcodeStack.Item summary = fieldSummary.getSummary(this.getXField());
        String fieldSig = summary.getSignature();
        if (this.isEjbImplClass && (fieldType = DescriptorFactory.createClassDescriptorFromFieldSignature(fieldSig)) != null && (Subtypes2.instanceOf(fieldType, "javax.ejb.SessionContext") || Subtypes2.instanceOf(fieldType, "javax.transaction.UserTransaction") || Subtypes2.instanceOf(fieldType, "javax.ejb.EJBHome") || Subtypes2.instanceOf(fieldType, "javax.ejb.EJBObject") || Subtypes2.instanceOf(fieldType, "javax.naming.Context"))) {
            if (obj.isTransient()) {
                this.bugReporter.reportBug(new BugInstance(this, "TESTING", 2).addClass(this).addVisitedField(this).addString("EJB implementation classes should not have fields of this type"));
            }
            return;
        }
        if (obj.isTransient()) {
            if (this.isSerializable && !this.isExternalizable) {
                this.seenTransientField = true;
                this.transientFieldsUpdates.put(this.getXField(), 0);
            } else if (reportTransientFieldOfNonSerializableClass) {
                this.bugReporter.reportBug(new BugInstance(this, "SE_TRANSIENT_FIELD_OF_NONSERIALIZABLE_CLASS", 2).addClass(this).addVisitedField(this));
            }
        } else if (this.getClassName().indexOf("ObjectStreamClass") == -1 && this.isSerializable && !this.isExternalizable && fieldSig.indexOf("L") >= 0 && !obj.isTransient() && !obj.isStatic()) {
            XField xfield;
            Type type;
            if (DEBUG) {
                System.out.println("Examining non-transient field with name: " + this.getFieldName() + ", sig: " + fieldSig);
            }
            if ((type = TypeFrameModelingVisitor.getType(xfield = this.getXField())) instanceof ReferenceType) {
                try {
                    ReferenceType rtype = (ReferenceType)type;
                    double isSerializable = DeepSubtypeAnalysis.isDeepSerializable(rtype);
                    if (DEBUG) {
                        System.out.println("  isSerializable: " + isSerializable);
                    }
                    if (isSerializable < 1.0) {
                        this.fieldsThatMightBeAProblem.put(obj.getName(), xfield);
                    }
                    if (isSerializable < 0.9) {
                        ReferenceType problemType = DeepSubtypeAnalysis.getLeastSerializableTypeComponent(rtype);
                        int priority = this.computePriority(isSerializable, 0.0);
                        if (!this.strongEvidenceForIntendedSerialization()) {
                            if (obj.getName().startsWith("this$")) {
                                priority = Math.max(priority, 2);
                            }
                            if (this.innerClassHasOuterInstance) {
                                priority = this.isAnonymousInnerClass ? (priority += 2) : ++priority;
                            }
                            if (this.isGUIClass || this.isEjbImplClass || this.isJSPClass) {
                                ++priority;
                            }
                        } else if (this.isGUIClass || this.isEjbImplClass || this.isJSPClass) {
                            priority = Math.max(priority, 2);
                        }
                        if (DEBUG) {
                            System.out.println("SE_BAD_FIELD: " + this.getThisClass().getClassName() + " " + obj.getName() + " " + isSerializable + " " + this.implementsSerializableDirectly + " " + this.sawSerialVersionUID + " " + this.isGUIClass + " " + this.isEjbImplClass);
                        }
                        if (obj.getName().equals("this$0")) {
                            this.fieldWarningList.add(new BugInstance(this, "SE_BAD_FIELD_INNER_CLASS", priority).addClass(this.getThisClass().getClassName()));
                        } else if (isSerializable < 0.9) {
                            this.fieldWarningList.add(new BugInstance(this, "SE_BAD_FIELD", priority).addClass(this.getThisClass().getClassName()).addField(xfield).addType(problemType).describe("TYPE_FOUND"));
                        }
                    } else if (!this.isGUIClass && !this.isEjbImplClass && !this.isJSPClass && obj.getName().equals("this$0")) {
                        this.fieldWarningList.add(new BugInstance(this, "SE_INNER_CLASS", this.implementsSerializableDirectly ? 2 : 3).addClass(this.getThisClass().getClassName()));
                    }
                }
                catch (ClassNotFoundException e) {
                    if (DEBUG) {
                        System.out.println("Caught ClassNotFoundException");
                    }
                    this.bugReporter.reportMissingClass(e);
                }
            }
        }
        if (!this.getFieldName().startsWith("this") && this.isSynthetic(obj)) {
            this.foundSynthetic = true;
        }
        if (!this.getFieldName().equals("serialVersionUID")) {
            return;
        }
        int mask = 24;
        if (!fieldSig.equals("I") && !fieldSig.equals("J")) {
            return;
        }
        if ((flags & mask) == mask && fieldSig.equals("I")) {
            this.bugReporter.reportBug(new BugInstance(this, "SE_NONLONG_SERIALVERSIONID", 3).addClass(this).addVisitedField(this));
            this.sawSerialVersionUID = true;
            return;
        }
        if ((flags & 8) == 0) {
            this.bugReporter.reportBug(new BugInstance(this, "SE_NONSTATIC_SERIALVERSIONID", 2).addClass(this).addVisitedField(this));
            return;
        }
        if ((flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance(this, "SE_NONFINAL_SERIALVERSIONID", 2).addClass(this).addVisitedField(this));
            return;
        }
        this.sawSerialVersionUID = true;
    }

    private int computePriority(double isSerializable, double bias) {
        int priority = (int)(1.9 + isSerializable * 3.0 + bias);
        priority = this.strongEvidenceForIntendedSerialization() ? --priority : (this.sawSerialVersionUID && priority > 2 ? --priority : Math.max(priority, 2));
        return priority;
    }
}

