/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.UseAnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;

public class MethodReturnCheck
extends OpcodeStackDetector
implements UseAnnotationDatabase {
    private static final boolean DEBUG = SystemProperties.getBoolean("mrc.debug");
    private static final int SCAN = 0;
    private static final int SAW_INVOKE = 1;
    private static final BitSet INVOKE_OPCODE_SET = new BitSet();
    boolean previousOpcodeWasNEW;
    private final BugAccumulator bugAccumulator;
    private CheckReturnAnnotationDatabase checkReturnAnnotationDatabase;
    private XMethod callSeen;
    private int state;
    private int callPC;

    public MethodReturnCheck(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visitClassContext(ClassContext classContext) {
        this.checkReturnAnnotationDatabase = AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase();
        super.visitClassContext(classContext);
    }

    public void visitAfter(Code code) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private boolean badUseOfCompareResult(OpcodeStack.Item left, OpcodeStack.Item right) {
        XMethod m = left.getReturnValueOf();
        if (m == null) {
            return false;
        }
        String name = m.getName();
        if (!name.startsWith("compare")) {
            return false;
        }
        Object value = right.getConstant();
        if (!(value instanceof Integer) || (Integer)value == 0) {
            return false;
        }
        if (!m.isPublic() && m.isResolved()) {
            return false;
        }
        if ((m.isStatic() || !m.isResolved()) && name.equals("compare") && m.getClassName().startsWith("com.google.common.primitives.")) {
            return true;
        }
        if (!m.isStatic() || !m.isResolved()) {
            if (name.equals("compareTo") && m.getSignature().equals("(Ljava/lang/Object;)I")) {
                return true;
            }
            if (name.equals("compare") && m.getSignature().equals("(Ljava/lang/Object;Ljava/lang/Object;)I")) {
                return true;
            }
        }
        return false;
    }

    public void sawOpcode(int seen) {
        block19: {
            int arguments;
            OpcodeStack.Item invokedOn;
            if (DEBUG) {
                System.out.printf("%3d %10s %3s %s%n", this.getPC(), OPCODE_NAMES[seen], this.state, this.stack);
            }
            switch (seen) {
                case 159: 
                case 160: {
                    XMethod returnValueOf;
                    OpcodeStack.Item left = this.stack.getStackItem(1);
                    OpcodeStack.Item right = this.stack.getStackItem(0);
                    if (this.badUseOfCompareResult(left, right)) {
                        returnValueOf = left.getReturnValueOf();
                        assert (returnValueOf != null);
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_CHECK_COMPARETO_FOR_SPECIFIC_RETURN_VALUE", 2).addClassAndMethod(this).addMethod(returnValueOf).describe("METHOD_CALLED").addValueSource(right, this), this);
                        break;
                    }
                    if (!this.badUseOfCompareResult(right, left)) break;
                    returnValueOf = right.getReturnValueOf();
                    assert (returnValueOf != null);
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_CHECK_COMPARETO_FOR_SPECIFIC_RETURN_VALUE", 2).addClassAndMethod(this).addMethod(returnValueOf).describe("METHOD_CALLED").addValueSource(left, this), this);
                }
            }
            if (seen == 183 && this.getNameConstantOperand().equals("<init>") && (invokedOn = this.stack.getStackItem(arguments = PreorderVisitor.getNumberArguments(this.getSigConstantOperand()))).isNewlyAllocated() && (!this.getMethodName().equals("<init>") || invokedOn.getRegisterNumber() != 0)) {
                for (int i = arguments + 1; i < this.stack.getStackDepth(); ++i) {
                    OpcodeStack.Item item = this.stack.getStackItem(i);
                    if (!item.isNewlyAllocated() || !item.getSignature().equals(invokedOn.getSignature())) {
                        continue;
                    }
                    break block19;
                }
                this.callSeen = XFactory.createReferencedXMethod(this);
                this.callPC = this.getPC();
                this.sawMethodCallWithIgnoredReturnValue();
                this.state = 0;
                this.previousOpcodeWasNEW = false;
                return;
            }
        }
        if (this.state == 1 && this.isPop(seen)) {
            this.sawMethodCallWithIgnoredReturnValue();
        } else if (INVOKE_OPCODE_SET.get(seen)) {
            this.callPC = this.getPC();
            this.callSeen = XFactory.createReferencedXMethod(this);
            this.state = 1;
            if (DEBUG) {
                System.out.println("  invoking " + this.callSeen);
            }
        } else {
            this.state = 0;
        }
        if (seen == 187) {
            this.previousOpcodeWasNEW = true;
        } else {
            CheckReturnValueAnnotation annotation;
            if (seen == 183 && this.previousOpcodeWasNEW && (annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation(this.callSeen, false)) != null && annotation != CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE) {
                int priority = annotation.getPriority();
                if (!this.checkReturnAnnotationDatabase.annotationIsDirect(this.callSeen) && !this.callSeen.getSignature().endsWith(this.callSeen.getClassName().replace('.', '/') + ";")) {
                    ++priority;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, annotation.getPattern(), priority).addClassAndMethod(this).addCalledMethod(this), this);
            }
            this.previousOpcodeWasNEW = false;
        }
    }

    private void sawMethodCallWithIgnoredReturnValue() {
        XFactory xFactory;
        CheckReturnValueAnnotation annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation(this.callSeen, false);
        if (annotation == null && (xFactory = AnalysisContext.currentXFactory()).isFunctionshatMightBeMistakenForProcedures(this.callSeen.getMethodDescriptor())) {
            annotation = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_INFERRED;
        }
        if (annotation != null && annotation.getPriority() <= 3) {
            int popPC = this.getPC();
            if (DEBUG) {
                System.out.println("Saw POP @" + popPC);
            }
            int catchSize = this.getSizeOfSurroundingTryBlock(popPC);
            int priority = annotation.getPriority();
            if (catchSize <= 1) {
                priority += 2;
            } else if (catchSize <= 2) {
                ++priority;
            }
            if (!this.checkReturnAnnotationDatabase.annotationIsDirect(this.callSeen) && !this.callSeen.getSignature().endsWith(this.callSeen.getClassName().replace('.', '/') + ";")) {
                ++priority;
            }
            if (this.callSeen.isPrivate()) {
                ++priority;
            }
            if (this.callSeen.getName().equals("clone") || this.callSeen.getName().startsWith("get")) {
                ++priority;
            }
            String pattern = annotation.getPattern();
            if (this.callSeen.getName().equals("<init>") && (this.callSeen.getClassName().endsWith("Exception") || this.callSeen.getClassName().endsWith("Error"))) {
                pattern = "RV_EXCEPTION_NOT_THROWN";
            }
            BugInstance warning = new BugInstance(this, pattern, priority).addClassAndMethod(this).addMethod(this.callSeen).describe("METHOD_CALLED");
            this.bugAccumulator.accumulateBug(warning, SourceLineAnnotation.fromVisitedInstruction(this, this.callPC));
        }
        this.state = 0;
    }

    private boolean isPop(int seen) {
        return seen == 87 || seen == 88;
    }

    static {
        INVOKE_OPCODE_SET.set(185);
        INVOKE_OPCODE_SET.set(183);
        INVOKE_OPCODE_SET.set(184);
        INVOKE_OPCODE_SET.set(182);
    }
}

