/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.cloud.AbstractCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugCollectionStorageCloud
extends AbstractCloud {
    public BugCollectionStorageCloud(CloudPlugin plugin, BugCollection bc, Properties properties) {
        super(plugin, bc, properties);
        this.setSigninState(Cloud.SigninState.NO_SIGNIN_REQUIRED);
    }

    @Override
    public boolean initialize() {
        try {
            return super.initialize();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void waitUntilIssueDataDownloaded() {
    }

    @Override
    public void initiateCommunication() {
    }

    @Override
    public boolean waitUntilNewIssuesUploaded(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public boolean waitUntilIssueDataDownloaded(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public Cloud.Mode getMode() {
        return Cloud.Mode.COMMUNAL;
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public Cloud.UserDesignation getUserDesignation(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        return Cloud.UserDesignation.valueOf(bd.getDesignationKey());
    }

    @Override
    public String getUserEvaluation(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return "";
        }
        return bd.getAnnotationText();
    }

    @Override
    public long getUserTimestamp(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return Long.MAX_VALUE;
        }
        return bd.getTimestamp();
    }

    @Override
    public void setMode(Cloud.Mode m) {
    }

    @Override
    public void bugsPopulated() {
    }

    @Override
    public void setSaveSignInInformation(boolean save) {
    }

    @Override
    public boolean isSavingSignInInformationEnabled() {
        return false;
    }

    @Override
    public void signIn() {
    }

    @Override
    public void signOut() {
    }

    @Override
    public boolean availableForInitialization() {
        return true;
    }

    @Override
    public void storeUserAnnotation(BugInstance bugInstance) {
    }

    @Override
    public void bugFiled(BugInstance b, Object bugLink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BugDesignation getPrimaryDesignation(BugInstance b) {
        return b.getUserDesignation();
    }

    @Override
    protected Iterable<BugDesignation> getLatestDesignationFromEachUser(BugInstance bd) {
        BugDesignation designation = this.getPrimaryDesignation(bd);
        if (designation == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(designation);
    }

    @Override
    public Collection<String> getProjects(String className) {
        return Collections.emptyList();
    }

    @Override
    public boolean isInCloud(BugInstance b) {
        return true;
    }

    @Override
    public boolean isOnlineCloud() {
        return false;
    }

    @Override
    public void waitUntilNewIssuesUploaded() {
    }

    @Override
    public void addDateSeen(BugInstance b, long when) {
        if (when > 0L) {
            b.getXmlProps().setFirstSeen(new Date(when));
        }
    }
}

